/*
 * Decompiled with CFR 0.152.
 */
package de.FeynArts;

import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.StdLink;
import java.awt.BasicStroke;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.SwingUtilities;

public class TopologyEditor
extends Frame {
    private static final double DEFAULT_RADIUS = 1.3;
    private static final int BORDER = 7;
    private static final int BOXWIDTH = 10;
    private static final int BOXHEIGHT = 10;
    private static final boolean PAINT = true;
    private static final boolean ERASE = false;
    private static final BasicStroke narrow = new BasicStroke();
    private static final BasicStroke wide = new BasicStroke(3.0f);
    private static final BasicStroke xwide = new BasicStroke(4.0f);
    private static final int COMMITTED = 0;
    private static final int CANCELLED = 1;
    private static final int ABORTED = 2;
    private Graphics2D screenGC;
    private Color bg;
    private double unitX;
    private double unitY;
    private int ybase;
    private CheckboxGroup positioning;
    private Checkbox gridposCheckbox;
    private Checkbox anyposCheckbox;
    private EditorCanvas editor = new EditorCanvas(414, 414);
    private Clickbox[] vertices;
    private Propagator[] propagators;
    private int nVertices;
    private int nPropagators = 0;

    private int scaleX(double d) {
        return (int)Math.round(this.unitX * d) + 7;
    }

    private int scaleY(double d) {
        return this.ybase - (int)Math.round(this.unitY * d);
    }

    private static double hypot(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    public TopologyEditor() {
        super("FeynArts Topology Editor");
        Box box = Box.createVerticalBox();
        Button button = new Button("OK");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopologyEditor.this.quit(0);
            }
        });
        box.add(button);
        Button button2 = new Button("Cancel");
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopologyEditor.this.quit(1);
            }
        });
        box.add(button2);
        Button button3 = new Button("Abort");
        button3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopologyEditor.this.quit(2);
            }
        });
        box.add(button3);
        Button button4 = new Button("Revert");
        button4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < TopologyEditor.this.vertices.length; ++i) {
                    TopologyEditor.this.vertices[i].revert();
                }
                TopologyEditor.this.editor.redraw = true;
                TopologyEditor.this.editor.repaint();
            }
        });
        box.add(button4);
        box.add(Box.createVerticalStrut(10));
        this.positioning = new CheckboxGroup();
        this.gridposCheckbox = new Checkbox("Grid position", this.positioning, true);
        this.anyposCheckbox = new Checkbox("Any position", this.positioning, false);
        box.add(this.gridposCheckbox);
        box.add(this.anyposCheckbox);
        box.add(Box.createVerticalStrut(10));
        HelpCanvas helpCanvas = new HelpCanvas();
        box.add(helpCanvas);
        this.add("Center", this.editor);
        this.add("East", box);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TopologyEditor.this.quit(2);
            }
        });
        this.setVisible(true);
        this.screenGC = (Graphics2D)this.editor.getGraphics();
        this.bg = this.editor.getBackground();
    }

    public void closeWindow() {
        this.dispose();
        this.screenGC.dispose();
    }

    private void quit(int n) {
        KernelLink kernelLink = StdLink.getLink();
        if (kernelLink == null) {
            return;
        }
        try {
            kernelLink.evaluate("(EndModal[]; " + n + ")");
            kernelLink.discardAnswer();
        }
        catch (MathLinkException mathLinkException) {
            System.err.println(mathLinkException.getMessage());
        }
    }

    public void putShapeData(double[] dArray, double[] dArray2) {
        int n;
        this.vertices = new Clickbox[dArray.length / 2 + 2 * dArray2.length / 5];
        this.propagators = new Propagator[dArray2.length / 5];
        int n2 = 0;
        for (n = 0; n < dArray.length; n += 2) {
            this.vertices[n2++] = new Vertexbox(dArray[n], dArray[n + 1]);
        }
        this.nVertices = n2;
        this.nPropagators = 0;
        for (n = 0; n < dArray2.length; n += 5) {
            Propagator propagator = new Propagator(dArray2, n);
            this.propagators[this.nPropagators++] = propagator;
            this.vertices[n2++] = propagator.label;
            this.vertices[n2++] = propagator.mid;
        }
        this.editor.redraw = true;
        this.editor.repaint();
    }

    public void getShapeData() {
        KernelLink kernelLink = StdLink.getLink();
        if (kernelLink == null) {
            return;
        }
        kernelLink.beginManual();
        try {
            Object object;
            int n;
            kernelLink.putFunction("List", 3);
            kernelLink.putFunction("List", this.nVertices);
            for (n = 0; n < this.nVertices; ++n) {
                kernelLink.putFunction("List", 2);
                kernelLink.put(this.vertices[n].x);
                kernelLink.put(this.vertices[n].y);
            }
            kernelLink.putFunction("List", this.nPropagators);
            for (n = 0; n < this.nPropagators; ++n) {
                object = this.propagators[n];
                if (((Propagator)object).tadpole) {
                    kernelLink.putFunction("List", 2);
                    kernelLink.put(((Propagator)object).mid.x);
                    kernelLink.put(((Propagator)object).mid.y);
                    continue;
                }
                kernelLink.put(((Propagator)object).height);
            }
            kernelLink.putFunction("List", this.nPropagators);
            for (n = 0; n < this.nPropagators; ++n) {
                object = this.propagators[n].label;
                if (((Labelbox)object).angle == 0.0) {
                    kernelLink.put(((Labelbox)object).radius / 1.3);
                    continue;
                }
                if (((Labelbox)object).angle == Math.PI) {
                    kernelLink.put(-((Labelbox)object).radius / 1.3);
                    continue;
                }
                kernelLink.putFunction("List", 2);
                kernelLink.put(((Labelbox)object).radius);
                kernelLink.put(((Labelbox)object).angle);
            }
        }
        catch (MathLinkException mathLinkException) {
            System.err.println(mathLinkException.getMessage());
        }
    }

    public class HelpCanvas
    extends Canvas {
        private final int WIDTH = 107;
        private final int HEIGHT = 175;
        private Image mousehelp;

        HelpCanvas() {
            this.setSize(107, 175);
        }

        public void paint(Graphics graphics) {
            if (this.mousehelp == null) {
                this.mousehelp = this.createImage(107, 175);
                Graphics graphics2 = this.mousehelp.getGraphics();
                graphics2.setColor(this.getBackground());
                graphics2.fillRect(0, 0, 107, 175);
                graphics2.setColor(Color.black);
                graphics2.drawString("mouse:", 7, 16);
                graphics2.drawString("left button", 7, 42);
                graphics2.drawString("drag", 46, 58);
                graphics2.drawString("middle button", 7, 84);
                graphics2.drawString("straighten", 20, 100);
                graphics2.drawString("default pos.", 20, 116);
                graphics2.drawString("right button", 7, 142);
                graphics2.drawString("mirror", 33, 158);
                graphics2.setColor(Color.red);
                graphics2.fillRect(7, 49, 10, 10);
                graphics2.setColor(Color.blue);
                graphics2.fillRect(20, 49, 10, 10);
                graphics2.fillRect(7, 91, 10, 10);
                graphics2.fillRect(7, 149, 10, 10);
                graphics2.setColor(Color.green);
                graphics2.fillRect(33, 49, 10, 10);
                graphics2.fillRect(7, 107, 10, 10);
                graphics2.fillRect(20, 149, 10, 10);
            }
            graphics.drawImage(this.mousehelp, 0, 0, null);
        }
    }

    public class EditorCanvas
    extends Canvas
    implements ComponentListener,
    MouseListener,
    MouseMotionListener {
        private Clickbox selected;
        private Image current = null;
        private Graphics2D currentGC;
        private boolean redraw = true;

        EditorCanvas(int n, int n2) {
            this.setSize(n, n2);
            TopologyEditor.this.ybase = n2 - 7;
            TopologyEditor.this.unitX = (double)(n - 14) / 20.0;
            TopologyEditor.this.unitY = (double)(n2 - 14) / 20.0;
            this.addComponentListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            if (TopologyEditor.this.nPropagators == 0) {
                return;
            }
            if (this.current == null || this.redraw) {
                Dimension dimension = this.getSize();
                if (this.current == null) {
                    this.current = this.createImage(dimension.width, dimension.height);
                    this.currentGC = (Graphics2D)(this.current == null ? graphics : this.current.getGraphics());
                }
                this.currentGC.setColor(this.getBackground());
                this.currentGC.fillRect(0, 0, dimension.width, dimension.height);
                this.paintCanvas(this.currentGC);
                this.redraw = false;
            }
            if (this.current != null) {
                graphics.drawImage(this.current, 0, 0, null);
            }
        }

        private void paintCanvas(Graphics2D graphics2D) {
            int n;
            graphics2D.setColor(Color.black);
            double d = 7.0;
            for (n = 20; n >= 0; --n) {
                int n2 = n % 5;
                double d2 = TopologyEditor.this.ybase;
                for (int i = 20; i >= 0; --i) {
                    int n3 = (int)Math.round(d);
                    int n4 = (int)Math.round(d2);
                    if (n2 == 0 && i % 5 == 0) {
                        graphics2D.drawLine(n3 - 2, n4, n3 + 2, n4);
                        graphics2D.drawLine(n3, n4 - 2, n3, n4 + 2);
                    } else {
                        graphics2D.drawRect(n3, n4, 0, 0);
                    }
                    d2 -= TopologyEditor.this.unitY;
                }
                d += TopologyEditor.this.unitX;
            }
            for (n = 0; n < TopologyEditor.this.nVertices; ++n) {
                TopologyEditor.this.vertices[n].update();
            }
            for (n = 0; n < TopologyEditor.this.nPropagators; ++n) {
                TopologyEditor.this.propagators[n].draw(graphics2D, true);
            }
            graphics2D.setColor(Color.red);
            for (n = 0; n < TopologyEditor.this.nVertices; ++n) {
                graphics2D.fill(((TopologyEditor)TopologyEditor.this).vertices[n].box);
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            Dimension dimension = this.getSize();
            TopologyEditor.this.ybase = Math.round(dimension.height) - 7;
            TopologyEditor.this.unitX = (double)(dimension.width - 14) / 20.0;
            TopologyEditor.this.unitY = (double)(dimension.height - 14) / 20.0;
            if (this.current != null) {
                this.currentGC.dispose();
                this.current = null;
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.selected != null) {
                double d = (double)(mouseEvent.getX() - 7) / TopologyEditor.this.unitX;
                double d2 = (double)(TopologyEditor.this.ybase - mouseEvent.getY()) / TopologyEditor.this.unitY;
                if (TopologyEditor.this.positioning.getSelectedCheckbox() == TopologyEditor.this.gridposCheckbox) {
                    d = 0.5 * (double)Math.round(2.0 * d);
                    d2 = 0.5 * (double)Math.round(2.0 * d2);
                }
                d = Math.max(Math.min(d, 20.0), 0.0);
                d2 = Math.max(Math.min(d2, 20.0), 0.0);
                this.selected.dragTo(TopologyEditor.this.screenGC, d, d2);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                for (int i = 0; i < TopologyEditor.this.vertices.length; ++i) {
                    if (!((TopologyEditor)TopologyEditor.this).vertices[i].box.contains(mouseEvent.getPoint())) continue;
                    this.selected = TopologyEditor.this.vertices[i];
                    break;
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.selected != null) {
                this.selected = null;
                this.redraw = true;
                this.repaint();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            Clickbox clickbox = null;
            for (int i = TopologyEditor.this.nVertices; i < TopologyEditor.this.vertices.length; ++i) {
                if (!((TopologyEditor)TopologyEditor.this).vertices[i].box.contains(mouseEvent.getPoint())) continue;
                clickbox = TopologyEditor.this.vertices[i];
                break;
            }
            if (clickbox == null) {
                return;
            }
            if (clickbox instanceof Propagatorbox) {
                Propagator propagator = ((Propagatorbox)clickbox).parent;
                if (propagator.tadpole) {
                    return;
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    propagator.height = -propagator.height;
                    propagator.label.angle = -propagator.label.angle;
                } else {
                    if (propagator.height < 0.0) {
                        propagator.label.angle = -propagator.label.angle;
                    }
                    propagator.height = 0.0;
                }
                propagator.update();
            } else {
                Labelbox labelbox = (Labelbox)clickbox;
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    labelbox.angle = Math.PI - labelbox.angle;
                } else {
                    labelbox.radius = 1.3;
                    labelbox.angle = 0.0;
                }
                labelbox.setXY();
            }
            this.redraw = true;
            this.repaint();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    private class Propagator {
        Vertexbox from;
        Vertexbox to;
        Propagatorbox mid;
        Labelbox label;
        boolean tadpole;
        double height;
        double arcCenterAngle;
        private double arcRadius;
        private double arcCenterX;
        private double arcCenterY;
        private int arcAngleStart;
        private int arcAngleExtent;

        Propagator(double[] dArray, int n) {
            this.tadpole = dArray[n] < 0.0;
            if (this.tadpole) {
                this.from = this.to = (Vertexbox)TopologyEditor.this.vertices[-((int)dArray[n]) - 1];
                this.mid = new Propagatorbox(dArray[n + 1], dArray[n + 2], this);
            } else {
                this.from = (Vertexbox)TopologyEditor.this.vertices[(int)dArray[n] - 1];
                this.to = (Vertexbox)TopologyEditor.this.vertices[(int)dArray[n + 1] - 1];
                this.height = dArray[n + 2];
                this.mid = new Propagatorbox(0.0, 0.0, this);
            }
            this.label = new Labelbox(dArray[n + 3], dArray[n + 4], this);
            this.update();
        }

        void update() {
            if (this.tadpole) {
                this.arcCenterX = 0.5 * (this.from.x + this.mid.x);
                this.arcCenterY = 0.5 * (this.from.y + this.mid.y);
                double d = this.arcCenterX - this.from.x;
                double d2 = this.arcCenterY - this.from.y;
                this.arcRadius = TopologyEditor.hypot(d, d2);
                this.arcCenterAngle = Math.atan2(d2, d);
                this.arcAngleStart = 0;
                this.arcAngleExtent = 360;
            } else {
                double d;
                double d3;
                double d4 = this.to.x - this.from.x;
                double d5 = this.to.y - this.from.y;
                double d6 = 0.5 * TopologyEditor.hypot(d4, d5);
                double d7 = Math.atan2(d5, d4) - 1.5707963267948966;
                this.arcCenterX = this.mid.x = 0.5 * (this.from.x + this.to.x);
                this.arcCenterY = this.mid.y = 0.5 * (this.from.y + this.to.y);
                if (this.height == 0.0) {
                    d3 = 20000.0;
                    this.arcRadius = 20000.0;
                    d = Math.asin(d6 / d3);
                } else {
                    if (this.height < 0.0) {
                        d7 += Math.PI;
                    }
                    d3 = Math.abs(this.height);
                    d = 2.0 * Math.atan(d3);
                    this.mid.x += d3 * d6 * Math.cos(d7);
                    this.mid.y += d3 * d6 * Math.sin(d7);
                    this.arcRadius = d3 = d6 / Math.sin(d);
                    d3 = Math.sqrt(d3 * d3 - d6 * d6);
                    if (Math.abs(this.height) > 1.0) {
                        d3 = -d3;
                    }
                }
                this.arcCenterX -= d3 * Math.cos(d7);
                this.arcCenterY -= d3 * Math.sin(d7);
                this.arcCenterAngle = d7;
                this.arcAngleStart = (int)Math.round(Math.toDegrees(d7 - d));
                this.arcAngleExtent = (int)Math.round(Math.toDegrees(2.0 * d));
            }
            this.label.setXY();
        }

        void draw(Graphics2D graphics2D, boolean bl) {
            if (bl) {
                graphics2D.setStroke(wide);
                graphics2D.setColor(Color.black);
            } else {
                graphics2D.setStroke(xwide);
                graphics2D.setColor(TopologyEditor.this.bg);
            }
            if (this.arcRadius < 20000.0) {
                graphics2D.drawArc(TopologyEditor.this.scaleX(this.arcCenterX - this.arcRadius), TopologyEditor.this.scaleY(this.arcCenterY + this.arcRadius), (int)Math.round(2.0 * this.arcRadius * TopologyEditor.this.unitX), (int)Math.round(2.0 * this.arcRadius * TopologyEditor.this.unitY), this.arcAngleStart, this.arcAngleExtent);
            } else {
                graphics2D.drawLine(this.from.center.x, this.from.center.y, this.to.center.x, this.to.center.y);
            }
            graphics2D.setStroke(narrow);
            this.mid.update();
            this.label.update();
            graphics2D.drawLine(this.mid.center.x, this.mid.center.y, this.label.center.x, this.label.center.y);
            if (bl) {
                graphics2D.setColor(Color.blue);
            }
            graphics2D.fill(this.mid.box);
            if (bl) {
                graphics2D.setColor(Color.green);
            }
            graphics2D.fill(this.label.box);
        }
    }

    private class Labelbox
    extends Clickbox {
        Propagator parent;
        double radius;
        double angle;

        Labelbox(double d, double d2, Propagator propagator) {
            this.parent = propagator;
            this.backup1 = this.radius = d;
            this.backup2 = this.angle = d2;
        }

        void revert() {
            this.radius = this.backup1;
            this.angle = this.backup2;
        }

        void setXY() {
            double d = this.angle + this.parent.arcCenterAngle;
            this.x = this.parent.mid.x + this.radius * Math.cos(d);
            this.y = this.parent.mid.y + this.radius * Math.sin(d);
        }

        void dragTo(Graphics2D graphics2D, double d, double d2) {
            if (d == this.x && d2 == this.y) {
                return;
            }
            double d3 = d - this.parent.mid.x;
            double d4 = d2 - this.parent.mid.y;
            this.radius = TopologyEditor.hypot(d3, d4);
            this.angle = Math.atan2(d4, d3) - this.parent.arcCenterAngle;
            if (Math.abs(this.angle) < 0.1) {
                this.angle = 0.0;
            } else if (Math.abs(this.angle - Math.PI) < 0.1) {
                this.angle = Math.PI;
            }
            graphics2D.setColor(TopologyEditor.this.bg);
            graphics2D.drawLine(this.parent.mid.center.x, this.parent.mid.center.y, this.center.x, this.center.y);
            graphics2D.fill(this.box);
            this.setXY();
            this.update();
            graphics2D.setColor(Color.black);
            graphics2D.drawLine(this.parent.mid.center.x, this.parent.mid.center.y, this.center.x, this.center.y);
            graphics2D.setColor(Color.green);
            graphics2D.fill(this.box);
        }
    }

    private class Propagatorbox
    extends Clickbox {
        Propagator parent;
        private double backupheight;

        Propagatorbox(double d, double d2, Propagator propagator) {
            super(d, d2);
            this.parent = propagator;
            this.backupheight = propagator.height;
        }

        void revert() {
            this.x = this.backup1;
            this.y = this.backup2;
            this.parent.height = this.backupheight;
            this.parent.update();
        }

        void dragTo(Graphics2D graphics2D, double d, double d2) {
            if (d == this.x && d2 == this.y) {
                return;
            }
            if (this.parent.tadpole) {
                this.parent.draw(graphics2D, false);
            } else {
                double d3;
                double d4;
                double d5 = 0.5 * (this.parent.to.x + this.parent.from.x);
                double d6 = 0.5 * (this.parent.to.y + this.parent.from.y);
                double d7 = this.parent.to.x - this.parent.from.x;
                double d8 = this.parent.to.y - this.parent.from.y;
                if (d7 == 0.0) {
                    d2 = d6;
                } else if (d8 == 0.0) {
                    d = d5;
                } else {
                    d4 = d8 / d7;
                    d3 = d4 + d7 / d8;
                    d = (d5 / d4 + d6 - d2 + d4 * d) / d3;
                    d2 = (d5 + d6 * d4 - d + d2 / d4) / d3;
                }
                d4 = TopologyEditor.hypot(d5 - d, d6 - d2);
                if (d4 < 0.3) {
                    d4 = 0.0;
                } else if ((d4 = 2.0 * d4 / TopologyEditor.hypot(d7, d8)) * (d3 = d8 * (d - this.parent.from.x) - d7 * (d2 - this.parent.from.y)) < 0.0) {
                    d4 = -d4;
                }
                if (d4 == this.parent.height) {
                    return;
                }
                this.parent.draw(graphics2D, false);
                if (d4 >= 0.0 && this.parent.height < 0.0 || d4 < 0.0 && this.parent.height >= 0.0) {
                    this.parent.label.angle = -this.parent.label.angle;
                }
                this.parent.height = d4;
            }
            this.x = d;
            this.y = d2;
            this.parent.update();
            this.parent.draw(graphics2D, true);
        }
    }

    private class Vertexbox
    extends Clickbox {
        Vertexbox(double d, double d2) {
            super(d, d2);
        }

        void revert() {
            this.x = this.backup1;
            this.y = this.backup2;
        }

        void dragTo(Graphics2D graphics2D, double d, double d2) {
            Propagator propagator;
            int n;
            double d3 = d - this.x;
            double d4 = d2 - this.y;
            if (d3 == 0.0 && d4 == 0.0) {
                return;
            }
            graphics2D.setColor(TopologyEditor.this.bg);
            graphics2D.fill(this.box);
            for (n = 0; n < TopologyEditor.this.nPropagators; ++n) {
                propagator = TopologyEditor.this.propagators[n];
                if (this != propagator.from && this != propagator.to) continue;
                propagator.draw(graphics2D, false);
                if (!propagator.tadpole) continue;
                propagator.mid.x += d3;
                propagator.mid.y += d4;
            }
            this.x = d;
            this.y = d2;
            this.update();
            for (n = 0; n < TopologyEditor.this.nPropagators; ++n) {
                propagator = TopologyEditor.this.propagators[n];
                if (this != propagator.from && this != propagator.to) continue;
                propagator.update();
                propagator.draw(graphics2D, true);
            }
            graphics2D.setColor(Color.red);
            graphics2D.fill(this.box);
        }
    }

    private abstract class Clickbox {
        double x;
        double y;
        double backup1;
        double backup2;
        Point center = new Point();
        Rectangle box = new Rectangle(10, 10);

        Clickbox() {
        }

        Clickbox(double d, double d2) {
            this();
            this.backup1 = this.x = d;
            this.backup2 = this.y = d2;
        }

        void update() {
            this.center.x = TopologyEditor.this.scaleX(this.x);
            this.center.y = TopologyEditor.this.scaleY(this.y);
            this.box.x = this.center.x - 5;
            this.box.y = this.center.y - 5;
        }

        abstract void dragTo(Graphics2D var1, double var2, double var4);

        abstract void revert();
    }
}

