(* ::Package:: *)

M$ModelName = "Fermionic and Scalar QED";

M$Information = {
  Authors      -> {"Lucas Heck"},
  Institutions -> {"UFABC"},
  Emails       -> {"lucas.heck@ufabc.edu.br"},
  Date         -> "03.12.2025"
};

IndexRange[ Index[ Generation ] ] = Range[3];
IndexStyle[Generation,f];
IndexRange[ Index[ Scalar ] ] = Range[4];
IndexStyle[Scalar, i];

M$Parameters = {
    lambda == {ParameterType -> Internal},
    EL == {ParameterType -> Internal}
    };

M$GaugeGroups = {
    U1 == {
        Abelian -> True,
        CouplingConstant -> EL,
        GaugeBoson -> A,
        Charge -> Q
    }
};

M$ClassesDescription = {
    S[1] == {
        ClassName     -> phi,
        ClassMembers -> {phi1, phi2, phi3, phi4},
        SelfConjugate -> False,
        Indices -> {Index[Scalar]},
        FlavorIndex -> Scalar,
        PropagatorLabel -> {"\[Phi]","\!\(\*SubscriptBox[\(\[Phi]\), \(1\)]\)","\!\(\*SubscriptBox[\(\[Phi]\), \(2\)]\)","\!\(\*SubscriptBox[\(\[Phi]\), \(3\)]\)","\!\(\*SubscriptBox[\(\[Phi]\), \(4\)]\)"},
        QuantumNumbers -> {Q -> -1},
        Mass -> {Mphi, Mphi, Mphi, Mphi, Mphi},
        PropagatorArrow -> None
    },
    F[1] == {
        ClassName     -> l,
        ClassMembers -> {e, mu, tau},
        SelfConjugate -> False,
        Indices -> {Index[Generation]},
        FlavorIndex -> Generation,
        PropagatorLabel -> {"l","e","mu", "tau"},
        QuantumNumbers -> {Q -> -1},
        Mass -> {ML, ME, MM, MT},
        PropagatorType -> Straight,
        PropagatorArrow -> Forward
    },
    V[1] == {
        ClassName -> A,
        SelfConjugate -> True,
        Mass -> 0,
        PropagatorLabel -> "\\gamma",
        PropagatorType -> W,
        PropagatorArrow -> None
    }
};

LFSQED = LGauge + LScalar + LLepton;
LGauge = -1/4 FS[A, imu, inu] FS[A, imu, inu];
LScalar = DC[phibar[i], imu] DC[phi[i], imu] - Mphi^2*phibar[i] phi[i] - 1/4 lambda * (phibar[i] phi[i])(phibar[j] phi[j]);
LLepton = I lbar[s,fi] Ga[imu] DC[l[s,fi],imu] - ML[fi] lbar[s,fi] l[s,fi];
