(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[      8288,        231]
NotebookOptionsPosition[      6978,        202]
NotebookOutlinePosition[      7378,        218]
CellTagsIndexPosition[      7335,        215]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.9740468966751976`*^9, 3.9740468994222717`*^9}, {
  3.9741914883226433`*^9, 3.974191491401222*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"53deadbd-e8ec-d740-95d0-3e93c471dd9b"],

Cell[BoxData[
 RowBox[{"FrontEndTokenExecute", "[", "\"\<DeleteGeneratedCells\>\"", 
  "]"}]], "Input",
 CellLabel->"In[15]:=",ExpressionUUID->"5cf08a9c-e169-254c-a6cb-3544bfcee0cd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$LoadAddOns", "=", 
   RowBox[{"{", "\"\<FeynArts\>\"", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynCalc`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FAVerbose", "=", "0"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"1ec32034-ca1d-5c44-b320-be1f184104d7"],

Cell[CellGroupData[{

Cell[TextData[{
 "Espalhamento ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{"2", "\[Rule]", "2"}], TraditionalForm], "errors" -> {}, 
     "input" -> "2\\to 2", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "471bb95e-78b6-c743-a2ac-0729ca89726f"],
 " em ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       SuperscriptBox["\[Lambda]\[Phi]", "4"], TraditionalForm], 
     "errors" -> {}, "input" -> "\\lambda \\phi^4", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "917f3f0f-cfc9-ad4c-bb6a-d0d936773621"],
 ":"
}], "Subsection",
 CellChangeTimes->{{3.9740469432102623`*^9, 
  3.9740469610244827`*^9}},ExpressionUUID->"00b1686c-4892-5d48-bdaa-\
a2cdfcd890ec"],

Cell[CellGroupData[{

Cell["N\[IAcute]vel \[AAcute]rvore", "Subsubsection",
 CellChangeTimes->{{3.9740471644753284`*^9, 
  3.974047168322012*^9}},ExpressionUUID->"daf37b90-c57c-964d-8566-\
4588e8de0bfe"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"topology", "=", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"0", ",", 
     RowBox[{"2", "->", "2"}], ",", 
     RowBox[{"Adjacencies", "->", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Paint", "[", 
   RowBox[{"topology", ",", 
    RowBox[{"SheetHeader", "->", "None"}], ",", 
    RowBox[{"Numbering", "->", "None"}], ",", 
    RowBox[{"ColumnsXRows", "->", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "->", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "200"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.974046966757303*^9, 3.9740469958847237`*^9}, {
  3.9740471170646896`*^9, 3.9740471172331543`*^9}, {3.9742209612829323`*^9, 
  3.974220964393753*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"4cf78007-471f-7f41-9242-56736ac97e13"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"diagram", "=", 
   RowBox[{"InsertFields", "[", 
    RowBox[{"topology", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"S", "[", "1", "]"}], ",", 
        RowBox[{"S", "[", "1", "]"}]}], "}"}], "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"S", "[", "1", "]"}], ",", 
        RowBox[{"S", "[", "1", "]"}]}], "}"}]}], ",", 
     RowBox[{"Model", "->", 
      RowBox[{"FileNameJoin", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<Phi4\>\"", ",", "\"\<Phi4\>\""}], "}"}], "]"}]}], ",", 
     RowBox[{"InsertionLevel", "->", 
      RowBox[{"{", "Classes", "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Paint", "[", 
   RowBox[{"diagram", ",", 
    RowBox[{"SheetHeader", "->", "None"}], ",", 
    RowBox[{"Numbering", "->", "None"}], ",", 
    RowBox[{"ColumnsXRows", "->", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "->", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "200"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.974047036950012*^9, 3.9740471521042805`*^9}, {
  3.9741915532358665`*^9, 3.9741915555928535`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"4c15966a-29e5-b747-b1c5-b3c14d13c2e1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Um Loop", "Subsubsection",
 CellChangeTimes->{{3.9740471856691055`*^9, 
  3.9740471866722965`*^9}},ExpressionUUID->"8e163039-cd56-9d4f-9191-\
c3483bd0cfe7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"topologiesOneLoop", "=", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"1", ",", 
     RowBox[{"2", "->", "2"}], ",", 
     RowBox[{"Adjacencies", "->", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}], ",", 
     RowBox[{"ExcludeTopologies", "->", "WFCorrections"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Paint", "[", 
   RowBox[{"topologiesOneLoop", ",", 
    RowBox[{"SheetHeader", "->", "None"}], ",", 
    RowBox[{"Numbering", "->", "None"}], ",", 
    RowBox[{"ColumnsXRows", "->", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "->", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "200"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9740471932107563`*^9, 3.9740472372339153`*^9}, {
  3.9741916943266144`*^9, 3.9741916944061947`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"959cb6db-7f46-bb4b-b2da-361cb43d95af"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"diagramsOneLoop", "=", 
   RowBox[{"InsertFields", "[", 
    RowBox[{"topologiesOneLoop", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"S", "[", "1", "]"}], ",", 
        RowBox[{"S", "[", "1", "]"}]}], "}"}], "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"S", "[", "1", "]"}], ",", 
        RowBox[{"S", 
         RowBox[{"{", "1", "}"}]}]}], "}"}]}], ",", 
     RowBox[{"Model", "->", 
      RowBox[{"FileNameJoin", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<Phi4\>\"", ",", "\"\<Phi4\>\""}], "}"}], "]"}]}], ",", 
     RowBox[{"InsertionLevel", "->", 
      RowBox[{"{", "Classes", "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Paint", "[", 
   RowBox[{"diagramsOneLoop", ",", 
    RowBox[{"SheetHeader", "->", "None"}], ",", 
    RowBox[{"Numbering", "->", "None"}], ",", 
    RowBox[{"ColumnsXRows", "->", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "->", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "200"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9740472460038357`*^9, 3.9740472621760387`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"2d741154-3182-ba40-8e93-7d7ebbbaa038"]
}, Closed]]
}, Closed]]
},
WindowSize->{1141.2, 568.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"14.3 for Microsoft Windows (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"e4ccce43-edbf-b145-ade8-f2cbd25e7fa5"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[554, 20, 252, 4, 28, "Input",ExpressionUUID->"53deadbd-e8ec-d740-95d0-3e93c471dd9b"],
Cell[809, 26, 182, 3, 28, "Input",ExpressionUUID->"5cf08a9c-e169-254c-a6cb-3544bfcee0cd"],
Cell[994, 31, 327, 7, 66, "Input",ExpressionUUID->"1ec32034-ca1d-5c44-b320-be1f184104d7"],
Cell[CellGroupData[{
Cell[1346, 42, 797, 21, 53, "Subsection",ExpressionUUID->"00b1686c-4892-5d48-bdaa-a2cdfcd890ec"],
Cell[CellGroupData[{
Cell[2168, 67, 181, 3, 43, "Subsubsection",ExpressionUUID->"daf37b90-c57c-964d-8566-4588e8de0bfe"],
Cell[2352, 72, 920, 23, 47, "Input",ExpressionUUID->"4cf78007-471f-7f41-9242-56736ac97e13"],
Cell[3275, 97, 1260, 33, 47, "Input",ExpressionUUID->"4c15966a-29e5-b747-b1c5-b3c14d13c2e1"]
}, Closed]],
Cell[CellGroupData[{
Cell[4572, 135, 162, 3, 35, "Subsubsection",ExpressionUUID->"8e163039-cd56-9d4f-9191-c3483bd0cfe7"],
Cell[4737, 140, 955, 23, 47, "Input",ExpressionUUID->"959cb6db-7f46-bb4b-b2da-361cb43d95af"],
Cell[5695, 165, 1255, 33, 66, "Input",ExpressionUUID->"2d741154-3182-ba40-8e93-7d7ebbbaa038"]
}, Closed]]
}, Closed]]
}
]
*)

