(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[     11105,        299]
NotebookOptionsPosition[      9572,        266]
NotebookOutlinePosition[      9972,        282]
CellTagsIndexPosition[      9929,        279]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.974100725441864*^9, 3.974100727080036*^9}, {
  3.974128083646017*^9, 3.9741280843127174`*^9}, {3.974191744407139*^9, 
  3.974191745918133*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"5957cf3e-a038-2a49-99c6-176759cf962d"],

Cell[BoxData[
 RowBox[{"FrontEndTokenExecute", "[", "\"\<DeleteGeneratedCells\>\"", 
  "]"}]], "Input",
 CellLabel->"In[13]:=",ExpressionUUID->"fdfcc379-e3c1-054a-a76b-0e9bc9c82f3d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$LoadAddOns", "=", 
   RowBox[{"{", "\"\<FeynArts\>\"", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynCalc`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FAVerbose", "=", "0"}], ";"}]}], "Input",
 CellChangeTimes->{{3.97410072929846*^9, 3.9741007516468163`*^9}, {
  3.974101554628069*^9, 3.9741015645225544`*^9}, {3.974274660353279*^9, 
  3.9742746605803185`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"e1802652-0936-1e41-bc0b-947805f57f80"],

Cell[CellGroupData[{

Cell[TextData[{
 "Espalhamentos ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{"2", "\[Rule]", "2"}], TraditionalForm], "errors" -> {}, 
     "input" -> "2 \\to 2", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "a3eff053-b040-924e-b237-9e9f1c738765"],
 " em QED (e QED escalar):"
}], "Section",
 CellChangeTimes->{{3.974100788941208*^9, 
  3.9741008184113083`*^9}},ExpressionUUID->"2d5a8490-d225-ec45-8d1c-\
5676730f6d7c"],

Cell[CellGroupData[{

Cell["N\[IAcute]vel \[AAcute]rvore:", "Subsection",
 CellChangeTimes->{{3.97410082292449*^9, 
  3.9741008270602856`*^9}},ExpressionUUID->"edd3f980-f7e0-0d4b-97eb-\
b087c414650e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"topologies", "=", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"0", ",", 
     RowBox[{"2", "->", "2"}], ",", 
     RowBox[{"Adjacencies", "->", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Paint", "[", 
   RowBox[{"topologies", ",", 
    RowBox[{"SheetHeader", "->", "None"}], ",", 
    RowBox[{"Numbering", "->", "None"}], ",", 
    RowBox[{"ColumnsXRows", "->", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "->", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "200"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9741008698376617`*^9, 3.974100881579115*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"9f885889-4434-0245-93c0-7c7068268094"],

Cell[CellGroupData[{

Cell["Algumas possibilidades:", "Subsubsection",
 CellChangeTimes->{
  3.97410115569866*^9, {3.974101295819582*^9, 3.974101331325224*^9}, {
   3.974102411576372*^9, 
   3.974102413986597*^9}},ExpressionUUID->"65d1cd89-6911-2c4d-91de-\
aedf03483142"],

Cell[BoxData[
 RowBox[{
  TemplateBox[<|"boxes" -> FormBox[
      RowBox[{"\[Phi]\[Gamma]", "\[Rule]", "\[Phi]\[Gamma]", ",", 
        SuperscriptBox["\[Phi]\[Phi]", "\[Dagger]"], "\[Rule]", 
        SuperscriptBox["\[Phi]\[Phi]", "\[Dagger]"], ",", 
        SuperscriptBox[
         RowBox[{"(", 
           RowBox[{"\[Phi]\[Gamma]", "\[Rule]", 
             StyleBox["l", "TI"], "\[Gamma]"}], ")"}], "*"], ",", 
        SuperscriptBox["\[Phi]\[Phi]", "\[Dagger]"], "\[Rule]", 
        StyleBox["l", "TI"], 
        OverscriptBox[
         StyleBox["l", "TI"], "_"], ",", "..."}], TraditionalForm], 
    "errors" -> {}, "input" -> 
    "\\phi \\gamma \\to \\phi\\gamma, \\phi \\phi^\\dagger \\to \\phi \
\\phi^\\dagger, (\\phi \\gamma \\to l \\gamma)^*, \\phi\\phi^\\dagger \\to l \
\\bar{l},...", "state" -> "Boxes"|>,
   "TeXAssistantTemplate"], " "}]], "Input",
 CellChangeTimes->{{3.9741016086888447`*^9, 3.9741016366064777`*^9}},
 TextAlignment->Center,
 FontSize->36,ExpressionUUID->"765d6bfc-eac8-524e-a371-eaeef667e8a1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"lepton", "=", 
   RowBox[{"F", "[", "1", "]"}]}], ";", 
  RowBox[{"leptonbar", "=", 
   RowBox[{"-", 
    RowBox[{"F", "[", "1", "]"}]}]}], ";", 
  RowBox[{"scalar", "=", 
   RowBox[{"S", "[", "1", "]"}]}], ";", 
  RowBox[{"scalarbar", "=", 
   RowBox[{"-", 
    RowBox[{"S", "[", "1", "]"}]}]}], ";", 
  RowBox[{"photon", "=", 
   RowBox[{"V", "[", "1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"possibilities", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"scalar", ",", "photon"}], "}"}], "->", 
      RowBox[{"{", 
       RowBox[{"scalar", ",", "photon"}], "}"}]}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"scalar", ",", "scalarbar"}], "}"}], "->", 
      RowBox[{"{", 
       RowBox[{"scalar", ",", "scalarbar"}], "}"}]}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"scalar", ",", "photon"}], "}"}], "->", 
      RowBox[{"{", 
       RowBox[{"photon", ",", "lepton"}], "}"}]}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"scalar", ",", "scalarbar"}], "}"}], "->", 
      RowBox[{"{", 
       RowBox[{"lepton", ",", "leptonbar"}], "}"}]}]}], "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9741016879278297`*^9, 3.9741018939368267`*^9}, {
  3.9741020064472103`*^9, 3.974102009953993*^9}, {3.9741281448679924`*^9, 
  3.9741281678291855`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"be4b94e7-31e4-7643-93d9-096eeb0c964e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"diagramsTreeLevel", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"InsertFields", "[", 
      RowBox[{"topologies", ",", "p", ",", 
       RowBox[{"Model", "->", 
        RowBox[{"FileNameJoin", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<FSQED\>\"", ",", "\"\<FSQED\>\""}], "}"}], "]"}]}], ",", 
       RowBox[{"GenericModel", "->", 
        RowBox[{"FileNameJoin", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<FSQED\>\"", ",", "\"\<FSQED\>\""}], "}"}], "]"}]}], ",", 
       RowBox[{"InsertionLevel", "->", 
        RowBox[{"{", "Classes", "}"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "possibilities"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Paint", "[", 
     RowBox[{"d", ",", 
      RowBox[{"SheetHeader", "->", "None"}], ",", 
      RowBox[{"Numbering", "->", "None"}], ",", 
      RowBox[{"ColumnsXRows", "->", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}]}], ",", 
      RowBox[{"ImageSize", "->", 
       RowBox[{"{", 
        RowBox[{"1000", ",", "200"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "diagramsTreeLevel"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.9741008496713066`*^9, {3.974101512999811*^9, 3.974101575063555*^9}, {
   3.9741019041776047`*^9, 3.974101931748169*^9}, {3.9741024295813084`*^9, 
   3.974102444244566*^9}, {3.9741276674442577`*^9, 3.9741276686017723`*^9}, {
   3.9741278249915733`*^9, 3.9741278464618816`*^9}, {3.974128133768881*^9, 
   3.9741281391201305`*^9}, {3.9741283848457184`*^9, 3.974128395117012*^9}, {
   3.9742213469611397`*^9, 3.974221362453865*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"0f575250-0e97-6b4e-ad65-c253a08e6be0"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Um loop:", "Subsection",
 CellChangeTimes->{{3.974102478022459*^9, 
  3.974102480417944*^9}},ExpressionUUID->"cd9863ce-d877-544c-9a9c-\
cba03468b7c7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"diagramsOneLoop", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"InsertFields", "[", 
      RowBox[{
       RowBox[{"CreateTopologies", "[", 
        RowBox[{"1", ",", 
         RowBox[{"2", "->", "2"}], ",", 
         RowBox[{"Adjacencies", "->", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4"}], "}"}]}], ",", 
         RowBox[{"ExcludeTopologies", "->", "WFCorrections"}]}], "]"}], ",", 
       "p", ",", 
       RowBox[{"Model", "->", 
        RowBox[{"FileNameJoin", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<FSQED\>\"", ",", "\"\<FSQED\>\""}], "}"}], "]"}]}], ",", 
       RowBox[{"GenericModel", "->", 
        RowBox[{"FileNameJoin", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<FSQED\>\"", ",", "\"\<FSQED\>\""}], "}"}], "]"}]}], ",", 
       RowBox[{"InsertionLevel", "->", 
        RowBox[{"{", "Classes", "}"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "possibilities"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Paint", "[", 
     RowBox[{"d", ",", 
      RowBox[{"Numbering", "->", "Simple"}], ",", 
      RowBox[{"ColumnsXRows", "->", 
       RowBox[{"{", 
        RowBox[{"6", ",", "1"}], "}"}]}], ",", 
      RowBox[{"ImageSize", "->", 
       RowBox[{"{", 
        RowBox[{"1000", ",", "200"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "diagramsOneLoop"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.974102283640272*^9, 3.974102369607088*^9}, {
  3.9742213950609818`*^9, 3.974221395651104*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"ff206fa9-4c64-2c4c-8651-01cc48ba39ce"]
}, Closed]]
}, Closed]]
},
WindowSize->{1141.2, 568.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"14.3 for Microsoft Windows (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"9a219735-db81-e34c-beea-8c11b1e34321"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[554, 20, 296, 5, 28, "Input",ExpressionUUID->"5957cf3e-a038-2a49-99c6-176759cf962d"],
Cell[853, 27, 182, 3, 28, "Input",ExpressionUUID->"fdfcc379-e3c1-054a-a76b-0e9bc9c82f3d"],
Cell[1038, 32, 496, 10, 66, "Input",ExpressionUUID->"e1802652-0936-1e41-bc0b-947805f57f80"],
Cell[CellGroupData[{
Cell[1559, 46, 498, 13, 66, "Section",ExpressionUUID->"2d5a8490-d225-ec45-8d1c-5676730f6d7c"],
Cell[CellGroupData[{
Cell[2082, 63, 178, 3, 53, "Subsection",ExpressionUUID->"edd3f980-f7e0-0d4b-97eb-b087c414650e"],
Cell[2263, 68, 820, 21, 47, "Input",ExpressionUUID->"9f885889-4434-0245-93c0-7c7068268094"],
Cell[CellGroupData[{
Cell[3108, 93, 249, 5, 43, "Subsubsection",ExpressionUUID->"65d1cd89-6911-2c4d-91de-aedf03483142"],
Cell[3360, 100, 1029, 21, 55, "Input",ExpressionUUID->"765d6bfc-eac8-524e-a371-eaeef667e8a1"],
Cell[4392, 123, 1461, 42, 66, "Input",ExpressionUUID->"be4b94e7-31e4-7643-93d9-096eeb0c964e"],
Cell[5856, 167, 1789, 41, 85, "Input",ExpressionUUID->"0f575250-0e97-6b4e-ad65-c253a08e6be0"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[7694, 214, 156, 3, 37, "Subsection",ExpressionUUID->"cd9863ce-d877-544c-9a9c-cba03468b7c7"],
Cell[7853, 219, 1691, 43, 66, "Input",ExpressionUUID->"ff206fa9-4c64-2c4c-8651-01cc48ba39ce"]
}, Closed]]
}, Closed]]
}
]
*)

