(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[     36295,        720]
NotebookOptionsPosition[     33873,        667]
NotebookOutlinePosition[     34677,        693]
CellTagsIndexPosition[     34634,        690]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.9741179510118217`*^9, 3.9741179524577217`*^9}},
 TextAlignment->Left,
 CellLabel->"In[14]:=",ExpressionUUID->"66abec83-6fe0-eb45-b944-3989803ebbc3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FrontEndTokenExecute", "[", "\"\<DeleteGeneratedCells\>\"", "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{3.9741179744238415`*^9},
 TextAlignment->Left,
 CellLabel->"In[12]:=",ExpressionUUID->"9a9b16bc-f612-3049-846a-e7933b98738f"],

Cell[CellGroupData[{

Cell["Importar pacotes", "Section",
 CellChangeTimes->{{3.9742067849519196`*^9, 
  3.974206792729582*^9}},ExpressionUUID->"128df80e-ca2c-8a45-8e6c-\
7b88d793fb1c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$LoadAddOns", "=", 
   RowBox[{"{", "\"\<FeynArts\>\"", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynCalc`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FAVerbose", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FAPatch", "[", 
   RowBox[{"PatchModelsOnly", "->", "True"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.97411797855982*^9, 3.974118012653036*^9}},
 TextAlignment->Left,
 CellLabel->"In[2]:=",ExpressionUUID->"46cbb879-fe81-bd41-980a-443f975b2ea3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Espalhamento ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{"2", "\[Rule]", "2"}], TraditionalForm], "errors" -> {}, 
     "input" -> "2\\to 2", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "18c3e445-1918-414b-b794-c6c7609a7624"],
 " em ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       SuperscriptBox["\[Lambda]\[Phi]", "4"], TraditionalForm], 
     "errors" -> {}, "input" -> "\\lambda \\phi^4", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "d301d5c7-0560-7740-bf04-30fd3b3d5213"]
}], "Section",
 CellChangeTimes->{{3.974118048058855*^9, 
  3.974118060546404*^9}},ExpressionUUID->"608161c8-5846-e14a-9beb-\
9397c7cf2ed0"],

Cell[CellGroupData[{

Cell["Come\[CCedilla]amos desenhando o diagrama do processo:", "Subsection",
 CellChangeTimes->{{3.9741180708813305`*^9, 3.974118079021927*^9}},
 TextAlignment->Left,ExpressionUUID->"ae16ad4c-0919-764f-ab03-9ea8f31edd75"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"diagram", "=", 
   RowBox[{"InsertFields", "[", 
    RowBox[{
     RowBox[{"CreateTopologies", "[", 
      RowBox[{"0", ",", 
       RowBox[{"2", "->", "2"}]}], "]"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"S", "[", "1", "]"}], ",", 
        RowBox[{"S", "[", "1", "]"}]}], "}"}], "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"S", "[", "1", "]"}], ",", 
        RowBox[{"S", "[", "1", "]"}]}], "}"}]}], ",", 
     RowBox[{"Model", "->", 
      RowBox[{"FileNameJoin", "[", 
       RowBox[{"\"\<Phi4\>\"", ",", "\"\<Phi4\>\""}], "]"}]}], ",", 
     RowBox[{"InsertionLevel", "->", 
      RowBox[{"{", "Classes", "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Paint", "[", 
   RowBox[{"diagram", ",", 
    RowBox[{"ColumnsXRows", "->", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], ",", 
    RowBox[{"SheetHeader", "->", "None"}], ",", 
    RowBox[{"Numbering", "->", "None"}], ",", 
    RowBox[{"ImageSize", "->", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "200"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9741180833627453`*^9, 3.974118189344799*^9}},
 TextAlignment->Left,
 CellLabel->"In[6]:=",ExpressionUUID->"93eb37f3-9c1b-ab4a-8f9f-8be41670b863"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Agora, calculamos a amplitude ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         StyleBox["i", FontSlant -> "Plain"], 
         StyleBox["M", "TI"]}], TraditionalForm], "errors" -> {}, "input" -> 
     "\\mathrm{i}\\mathcal{M}", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "e399813a-2c5f-8641-b253-fa16cd29fe91"],
 ":"
}], "Subsection",
 CellChangeTimes->{{3.9741181972978344`*^9, 3.9741182148927975`*^9}},
 TextAlignment->Left,ExpressionUUID->"4050bb4e-3491-6e45-acc3-d26ad6e2be87"],

Cell[BoxData[
 RowBox[{"amplitude", "=", 
  RowBox[{"FCFAConvert", "[", 
   RowBox[{
    RowBox[{"CreateFeynAmp", "[", 
     RowBox[{"diagram", ",", 
      RowBox[{"PreFactor", "->", "1"}]}], "]"}], ",", 
    RowBox[{"IncomingMomenta", "->", 
     RowBox[{"{", 
      RowBox[{"p1", ",", "p2"}], "}"}]}], ",", 
    RowBox[{"OutgoingMomenta", "->", 
     RowBox[{"{", 
      RowBox[{"k1", ",", "k2"}], "}"}]}], ",", 
    RowBox[{"List", "->", "False"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9741182283731117`*^9, 3.974118314292261*^9}},
 TextAlignment->Left,
 CellLabel->"In[8]:=",ExpressionUUID->"fe84b60f-d40b-6f4d-9148-1a9e4f9fd5c4"]
}, Closed]],

Cell[CellGroupData[{

Cell["E o m\[OAcute]dulo ao quadrado:", "Subsection",
 CellChangeTimes->{{3.9741183282751293`*^9, 3.9741183326936264`*^9}},
 TextAlignment->Left,ExpressionUUID->"f46ff54c-a244-bf41-8608-a36310108515"],

Cell[BoxData[
 RowBox[{"amplitudeSquared", "=", 
  RowBox[{"amplitude", " ", 
   RowBox[{"ComplexConjugate", "[", "amplitude", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.974118336911846*^9, 3.974118351513645*^9}, 
   3.974221524470625*^9},
 TextAlignment->Left,
 CellLabel->"In[9]:=",ExpressionUUID->"34b5f9e9-1a5f-564e-9d8a-2b7dc61946fb"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Calculamos a se\[CCedilla]\[ATilde]o de choque diferencial ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       FractionBox[
        RowBox[{
          StyleBox["d", FontSlant -> "Plain"], "\[Sigma]"}], 
        RowBox[{
          StyleBox["d", FontSlant -> "Plain"], "\[CapitalOmega]"}]], 
       TraditionalForm], "errors" -> {}, "input" -> 
     "\\frac{\\mathrm{d}\\sigma}{\\mathrm{d}\\Omega}", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "13cd2b87-6c40-524b-9e05-76363a77f68b"],
 " [Peskin]:"
}], "Subsection",
 CellChangeTimes->{{3.974118409418585*^9, 3.974118461173685*^9}, {
  3.974118577952627*^9, 3.9741185819645977`*^9}},
 TextAlignment->Left,ExpressionUUID->"eb3d5117-d08b-d749-8886-3d0fba46d519"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztvQdYFcf3/39FQOygiBVFJfbYG7GLxoa9t2CLsUTsvcTeW2Lv+Whii11j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    "], {{0, 76.8}, {639.6, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{120., 120.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{639.6, 76.8},
  PlotRange->{{0, 639.6}, {0, 76.8}}]], "Input",
 CellChangeTimes->{{3.9741184436124153`*^9, 3.9741184585793533`*^9}, {
  3.974118514581608*^9, 
  3.97411852808486*^9}},ExpressionUUID->"c097d35f-30fb-424a-a12c-\
c4beab70dc24"],

Cell[BoxData[
 RowBox[{"dXSec", "=", 
  RowBox[{
   FractionBox["1", "2"], 
   FractionBox["amplitudeSquared", 
    RowBox[{"64", 
     SuperscriptBox["\[Pi]", "2"], 
     SuperscriptBox["ECM", "2"]}]]}]}]], "Input",
 CellChangeTimes->{{3.974118593070032*^9, 3.974118623439766*^9}, {
  3.9742069907359276`*^9, 3.974206993591898*^9}},
 TextAlignment->Left,
 CellLabel->"In[10]:=",ExpressionUUID->"ee318d2d-26b6-a34c-b54a-4288ab19dfb3"]
}, Closed]],

Cell[CellGroupData[{

Cell["E a se\[CCedilla]\[ATilde]o de choque total \[Sigma]:", "Subsection",
 CellChangeTimes->{{3.9741186311232433`*^9, 3.974118639173624*^9}},
 TextAlignment->Left,ExpressionUUID->"28508d5a-ae23-d645-823e-166ee0a4337b"],

Cell[BoxData[
 RowBox[{"xSec", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"dXSec", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Phi]", ",", "0", ",", 
      RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.974118642185688*^9, 3.974118660345892*^9}, {
  3.9742069753658676`*^9, 3.9742069777925243`*^9}},
 TextAlignment->Left,
 CellLabel->"In[11]:=",ExpressionUUID->"e78e3fa8-cb59-a441-8786-049ce418f8fd"]
}, Closed]]
}, Closed]]
},
Alignment->Center,
WindowSize->{1141.2, 568.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
CommonDefaultFormatTypes->{"Output"->TraditionalForm},
TextAlignment->Center,
Magnification:>1. Inherited,
FrontEndVersion->"14.3 for Microsoft Windows (64-bit) (July 8, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    StyleData["CenteredCell"], MenuSortingValue -> 10000]}, Visible -> False, 
  FrontEndVersion -> "14.3 for Microsoft Windows (64-bit) (July 8, 2025)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"],
ExpressionUUID->"d5c4d289-2c20-7d4a-a009-8074431e8c59"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[554, 20, 223, 4, 28, "Input",ExpressionUUID->"66abec83-6fe0-eb45-b944-3989803ebbc3"],
Cell[780, 26, 266, 6, 28, "Input",ExpressionUUID->"9a9b16bc-f612-3049-846a-e7933b98738f"],
Cell[CellGroupData[{
Cell[1071, 36, 163, 3, 66, "Section",ExpressionUUID->"128df80e-ca2c-8a45-8e6c-7b88d793fb1c"],
Cell[1237, 41, 535, 12, 85, "Input",ExpressionUUID->"46cbb879-fe81-bd41-980a-443f975b2ea3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1809, 58, 784, 20, 66, "Section",ExpressionUUID->"608161c8-5846-e14a-9beb-9397c7cf2ed0"],
Cell[CellGroupData[{
Cell[2618, 82, 221, 2, 53, "Subsection",ExpressionUUID->"ae16ad4c-0919-764f-ab03-9ea8f31edd75"],
Cell[2842, 86, 1295, 35, 47, "Input",ExpressionUUID->"93eb37f3-9c1b-ab4a-8f9f-8be41670b863"]
}, Closed]],
Cell[CellGroupData[{
Cell[4174, 126, 585, 14, 37, "Subsection",ExpressionUUID->"4050bb4e-3491-6e45-acc3-d26ad6e2be87"],
Cell[4762, 142, 640, 16, 28, "Input",ExpressionUUID->"fe84b60f-d40b-6f4d-9148-1a9e4f9fd5c4"]
}, Closed]],
Cell[CellGroupData[{
Cell[5439, 163, 200, 2, 37, "Subsection",ExpressionUUID->"f46ff54c-a244-bf41-8608-a36310108515"],
Cell[5642, 167, 339, 7, 28, "Input",ExpressionUUID->"34b5f9e9-1a5f-564e-9d8a-2b7dc61946fb"]
}, Closed]],
Cell[CellGroupData[{
Cell[6018, 179, 791, 18, 56, "Subsection",ExpressionUUID->"eb3d5117-d08b-d749-8886-3d0fba46d519"],
Cell[6812, 199, 25761, 428, 89, "Input",ExpressionUUID->"c097d35f-30fb-424a-a12c-c4beab70dc24"],
Cell[32576, 629, 434, 11, 44, "Input",ExpressionUUID->"ee318d2d-26b6-a34c-b54a-4288ab19dfb3"]
}, Closed]],
Cell[CellGroupData[{
Cell[33047, 645, 220, 2, 37, "Subsection",ExpressionUUID->"28508d5a-ae23-d645-823e-166ee0a4337b"],
Cell[33270, 649, 575, 14, 28, "Input",ExpressionUUID->"e78e3fa8-cb59-a441-8786-049ce418f8fd"]
}, Closed]]
}, Closed]]
}
]
*)

