(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[      6501,        167]
NotebookOptionsPosition[      5107,        135]
NotebookOutlinePosition[      5562,        152]
CellTagsIndexPosition[      5519,        149]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.974035664386326*^9, 3.974035664952631*^9}, {
  3.9742739892780437`*^9, 3.9742739904036255`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"3ccc4417-1f40-514c-90e3-28f90a040e8e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FrontEndTokenExecute", "[", "\"\<DeleteGeneratedCells\>\"", "]"}], 
  ";"}]], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"69919ce2-12ff-034a-a6de-49d092ee6a21"],

Cell[CellGroupData[{

Cell["Importa FeynRules e o modelo", "Subsection",
 CellChangeTimes->{{3.9740361146323967`*^9, 3.9740361224076347`*^9}, {
  3.9741309808848553`*^9, 
  3.9741309872246647`*^9}},ExpressionUUID->"1e1528dc-dc7f-644d-a69b-\
e115fcd85609"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", 
   RowBox[{"Commutator", ",", "NonCommutativeMultiply", ",", "MatrixSymbol"}],
    "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FR$Parallel", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "$UserBaseDirectory", ",", "\"\<Applications\>\"", 
      ",", "\"\<FeynRules\>\""}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"LoadModel", "[", "\"\<Phi4.fr\>\"", "]"}]}], "Input",
 CellChangeTimes->{{3.9740356671985073`*^9, 3.9740358383713837`*^9}, {
   3.9740358751030235`*^9, 3.9740358769720535`*^9}, {3.9741253060716457`*^9, 
   3.974125307317892*^9}, {3.974125950536867*^9, 3.97412596546846*^9}, {
   3.9742739668231335`*^9, 3.9742739673988705`*^9}, 3.974274020136307*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"b5855de0-e496-eb4e-899c-20bb3ac1a119"]
}, Closed]],

Cell[CellGroupData[{

Cell["Pretty Printing", "Subsection",
 CellChangeTimes->{{3.974036093820673*^9, 
  3.974036097012272*^9}},ExpressionUUID->"04214d8f-7d9d-224d-96f3-\
a1c303399fda"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MakeBoxes", "[", 
    RowBox[{"phi", ",", "TraditionalForm"}], "]"}], ":=", "\"\<\[Phi]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeBoxes", "[", 
    RowBox[{"mu", ",", "TraditionalForm"}], "]"}], ":=", "\"\<\[Mu]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeBoxes", "[", 
    RowBox[{"lambda", ",", "TraditionalForm"}], "]"}], 
   ":=", "\"\<\[Lambda]\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeBoxes", "[", 
    RowBox[{"mphi", ",", "TraditionalForm"}], "]"}], ":=", "\"\<m\>\""}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9740358886901875`*^9, 3.9740358960286617`*^9}, {
  3.974035995185419*^9, 3.9740360784189014`*^9}, {3.9740361904798145`*^9, 
  3.974036200923706*^9}, {3.974036368516367*^9, 3.9740364001348724`*^9}, {
  3.974125333657093*^9, 3.974125337555725*^9}, {3.974126722788027*^9, 
  3.974126738808874*^9}, {3.9742739745216427`*^9, 3.974273985896988*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"8c22b3ac-cfd3-de47-9fa8-1931ee6bf5bf"]
}, Closed]],

Cell[CellGroupData[{

Cell["Lagrangiana", "Subsection",
 CellChangeTimes->{{3.9740361057249413`*^9, 3.9740361066329975`*^9}, {
   3.9741309906690826`*^9, 3.974130990965231*^9}, 
   3.9742741321151695`*^9},ExpressionUUID->"4f883d23-581a-8b40-92c2-\
16258b1e579e"],

Cell[BoxData["LPhi4"], "Input",
 CellChangeTimes->{{3.974035675211792*^9, 3.9740356759798584`*^9}, {
   3.9740358520177364`*^9, 3.974035852690647*^9}, {3.974190910285839*^9, 
   3.974190913773489*^9}, 3.9742061846361485`*^9, {3.974274003614004*^9, 
   3.9742740043880634`*^9}, {3.974274129343855*^9, 3.9742741301709595`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"6e33ecee-fac3-2743-b46b-14cabf1f1fce"]
}, Closed]],

Cell[CellGroupData[{

Cell["Regra de Feynman", "Section",
 CellChangeTimes->{{3.9740400322865944`*^9, 3.974040034695795*^9}, {
   3.974129889036539*^9, 3.9741299188344955`*^9}, {3.9741309946224403`*^9, 
   3.974130997736185*^9}, {3.9742062381747074`*^9, 3.974206241622532*^9}, {
   3.974220314153305*^9, 3.9742203234457893`*^9}, {3.974273963462435*^9, 
   3.974273965697199*^9}, 3.9742741424854717`*^9, 
   3.974274498054039*^9},ExpressionUUID->"ce254506-33f6-bc40-99bb-\
db11e39e7730"],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LPhi4", "]"}]], "Input",
 CellChangeTimes->{{3.974274152121935*^9, 3.974274157107538*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"d92c2e61-78cf-1243-810f-f7f6768851c7"]
}, Closed]]
},
WindowSize->{1141.2, 568.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
CommonDefaultFormatTypes->{"Output"->TraditionalForm},
FrontEndVersion->"14.3 for Microsoft Windows (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"dd4b0f37-182b-5f41-84d5-3f2599d5649e"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[554, 20, 249, 4, 28, "Input",ExpressionUUID->"3ccc4417-1f40-514c-90e3-28f90a040e8e"],
Cell[806, 26, 200, 4, 28, "Input",ExpressionUUID->"69919ce2-12ff-034a-a6de-49d092ee6a21"],
Cell[CellGroupData[{
Cell[1031, 34, 233, 4, 53, "Subsection",ExpressionUUID->"1e1528dc-dc7f-644d-a69b-e115fcd85609"],
Cell[1267, 40, 1121, 23, 123, "Input",ExpressionUUID->"b5855de0-e496-eb4e-899c-20bb3ac1a119"]
}, Closed]],
Cell[CellGroupData[{
Cell[2425, 68, 163, 3, 37, "Subsection",ExpressionUUID->"04214d8f-7d9d-224d-96f3-a1c303399fda"],
Cell[2591, 73, 1098, 26, 85, "Input",ExpressionUUID->"8c22b3ac-cfd3-de47-9fa8-1931ee6bf5bf"]
}, Closed]],
Cell[CellGroupData[{
Cell[3726, 104, 240, 4, 37, "Subsection",ExpressionUUID->"4f883d23-581a-8b40-92c2-16258b1e579e"],
Cell[3969, 110, 404, 5, 28, "Input",ExpressionUUID->"6e33ecee-fac3-2743-b46b-14cabf1f1fce"]
}, Closed]],
Cell[CellGroupData[{
Cell[4410, 120, 464, 7, 52, "Section",ExpressionUUID->"ce254506-33f6-bc40-99bb-db11e39e7730"],
Cell[4877, 129, 214, 3, 28, "Input",ExpressionUUID->"d92c2e61-78cf-1243-810f-f7f6768851c7"]
}, Closed]]
}
]
*)

