(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[     14839,        399]
NotebookOptionsPosition[     12178,        344]
NotebookOutlinePosition[     12633,        361]
CellTagsIndexPosition[     12590,        358]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.9740434856794624`*^9, 3.9740434869668503`*^9}, {
  3.9740445529044514`*^9, 3.9740445705128727`*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"84fafd90-6b75-f646-9264-300fd62c36a0"],

Cell[BoxData[
 RowBox[{"FrontEndTokenExecute", "[", "\"\<DeleteGeneratedCells\>\"", 
  "]"}]], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"9545bbb6-f3d4-f541-b272-022338aa18ad"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$LoadAddOns", "=", 
   RowBox[{"{", "\"\<FeynArts\>\"", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynCalc`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FAVerbose", "=", "0"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9740434910951347`*^9, 3.97404351039876*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"2c6fc924-b17b-9647-a3b5-23370148d3da"],

Cell[CellGroupData[{

Cell[TextData[{
 "Processo simples: decaimento ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{"1", "\[Rule]", "2"}], TraditionalForm], "errors" -> {}, 
     "input" -> "1\\to 2", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "accffb5f-fc60-624c-8d4f-fc060192751e"]
}], "Section",
 CellChangeTimes->{{3.974045334485773*^9, 
  3.9740453503543186`*^9}},ExpressionUUID->"90cebfbe-71c7-de4d-aa74-\
918f19199beb"],

Cell[CellGroupData[{

Cell[TextData[{
 "A n\[IAcute]vel \[AAcute]rvore, quais s\[ATilde]o todos os diagramas de \
processos ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{"1", "\[Rule]", "2"}], TraditionalForm], "errors" -> {}, 
     "input" -> "1 \\to 2", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "f7299294-b76d-5146-854e-1254084deaa1"],
 " que existem com tr\[EHat]s arestas ligando um v\[EAcute]rtice?"
}], "Subsection",
 CellChangeTimes->{{3.9740437834803867`*^9, 
  3.9740438504716663`*^9}},ExpressionUUID->"848c2242-509b-4c46-9936-\
967b8fc686f3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"oneToTwoTreeLevel", "=", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"0", ",", 
     RowBox[{"1", "->", "2"}], ",", 
     RowBox[{"Adjacencies", "->", 
      RowBox[{"{", "3", "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Paint", "[", 
   RowBox[{"oneToTwoTreeLevel", ",", 
    RowBox[{"ColumnsXRows", "->", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], ",", 
    RowBox[{"Numbering", "->", "None"}], ",", 
    RowBox[{"ImageSize", "->", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "200"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.974043855557976*^9, 3.9740439212012653`*^9}, {
  3.97404412746743*^9, 3.974044132605982*^9}, {3.9740448903636436`*^9, 
  3.9740448905184975`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"4936452e-3359-474c-a345-abf521ceb7d7"]
}, Closed]],

Cell[CellGroupData[{

Cell["E a um loop?", "Subsection",
 CellChangeTimes->{{3.9740439346159573`*^9, 
  3.974043939731209*^9}},ExpressionUUID->"ec7b6cfc-e845-9d40-a1a2-\
506d524fcc04"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"oneToTwoOneLoop", "=", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"1", ",", 
     RowBox[{"1", "->", "2"}], ",", 
     RowBox[{"Adjacencies", "->", 
      RowBox[{"{", "3", "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Paint", "[", 
   RowBox[{"oneToTwoOneLoop", ",", 
    RowBox[{"ColumnsXRows", "->", 
     RowBox[{"{", 
      RowBox[{"5", ",", "1"}], "}"}]}], ",", 
    RowBox[{"Numbering", "->", "None"}], ",", 
    RowBox[{"SheetHeader", "->", "None"}], ",", 
    RowBox[{"ImageSize", "->", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "200"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9740439453745136`*^9, 3.9740440073647156`*^9}, {
  3.974044056233135*^9, 3.9740441213909416`*^9}, {3.9740451027106266`*^9, 
  3.9740451073295193`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"92684a4f-c0e3-0e44-ad93-6d101830e8a5"],

Cell[CellGroupData[{

Cell["Mas... ", "Subsubsection",
 CellChangeTimes->{{3.974044247762785*^9, 3.9740442618596325`*^9}, 
   3.974046715414423*^9},ExpressionUUID->"d4bf435a-f113-fd46-ae3e-\
65416a882958"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"oneToTwoOneLoopAmputated", "=", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"1", ",", 
     RowBox[{"1", "->", "2"}], ",", 
     RowBox[{"Adjacencies", "->", 
      RowBox[{"{", "3", "}"}]}], ",", 
     RowBox[{"ExcludeTopologies", "->", "WFCorrections"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Paint", "[", 
   RowBox[{"oneToTwoOneLoopAmputated", ",", 
    RowBox[{"ColumnsXRows", "->", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], ",", 
    RowBox[{"Numbering", "->", "None"}], ",", 
    RowBox[{"SheetHeader", "->", "None"}], ",", 
    RowBox[{"ImageSize", "->", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "200"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.974044273374548*^9, 3.9740443352853127`*^9}, {
  3.9740444649472294`*^9, 3.9740444735585423`*^9}, {3.974044884317259*^9, 
  3.974044884407444*^9}, {3.974045072108633*^9, 3.9740450761719704`*^9}, {
  3.974045110645281*^9, 3.974045113743948*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"506f97c5-e260-2046-ba61-bf1a42383ecf"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["E a 3 loop??", "Subsection",
 CellChangeTimes->{{3.9740443921267204`*^9, 
  3.9740444005784283`*^9}},ExpressionUUID->"e72460e1-bc8e-6c42-b540-\
4ee877b4f7b3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"oneToTwoThreeLoop", "=", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"3", ",", 
     RowBox[{"1", "->", "2"}], ",", 
     RowBox[{"Adjacencies", "->", 
      RowBox[{"{", "3", "}"}]}], ",", 
     RowBox[{"ExcludeTopologies", "->", "WFCorrections"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Paint", "[", 
   RowBox[{"oneToTwoThreeLoop", ",", 
    RowBox[{"ColumnsXRows", "->", 
     RowBox[{"{", 
      RowBox[{"5", ",", "1"}], "}"}]}], ",", 
    RowBox[{"Numbering", "->", "None"}], ",", 
    RowBox[{"SheetHeader", "->", "None"}], ",", 
    RowBox[{"ImageSize", "->", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "200"}], "}"}]}], ",", 
    RowBox[{"AutoEdit", "->", "False"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.974044406721369*^9, 3.9740444266950703`*^9}, {
  3.9740444797361603`*^9, 3.9740444856386185`*^9}, {3.97404492833243*^9, 
  3.974044928747097*^9}, {3.9740449650988293`*^9, 3.974045028008133*^9}, {
  3.974045117080124*^9, 3.9740451210893993`*^9}, {3.9741912958281975`*^9, 
  3.9741912962097797`*^9}, {3.9742207681100445`*^9, 3.974220768869478*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"cafa13e7-ba8a-104e-ac92-9e7fe7cd47f3"],

Cell[BoxData[
 RowBox[{"oneToTwoThreeLoop", "//", "Length"}]], "Input",
 CellChangeTimes->{{3.97404449599753*^9, 3.974044503427532*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"a3291070-a180-8f44-aab5-cfefc8e7984a"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Outros processos", "Section",
 CellChangeTimes->{{3.9740453279032097`*^9, 3.9740453299854946`*^9}, {
  3.9740453623562393`*^9, 
  3.974045362698147*^9}},ExpressionUUID->"0638cd51-b1ef-884f-a02b-\
40c36caa75fd"],

Cell[CellGroupData[{

Cell[TextData[{
 "Espalhamento ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{"2", "\[Rule]", "2"}], TraditionalForm], "errors" -> {}, 
     "input" -> "2 \\to 2", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "196d76fb-a7e3-a847-8a2c-af368f5d6fb9"],
 " com 3 ou 4 arestas permitidas"
}], "Subsection",
 CellChangeTimes->{{3.9740454389402943`*^9, 
  3.9740454520316296`*^9}},ExpressionUUID->"db93cf45-76be-0843-9b97-\
a74084b619e5"],

Cell[CellGroupData[{

Cell["N\[IAcute]vel \[AAcute]rvore", "Subsubsection",
 CellChangeTimes->{{3.9740454119623985`*^9, 3.9740454177365093`*^9}, 
   3.9740454540741787`*^9},ExpressionUUID->"b6d11c5b-c6e2-1b45-ac8c-\
370bc5e78d58"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"twoToTwoTreeLevel", "=", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"0", ",", 
     RowBox[{"2", "->", "2"}], ",", 
     RowBox[{"Adjacencies", "->", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Paint", "[", 
   RowBox[{"twoToTwoTreeLevel", ",", 
    RowBox[{"SheetHeader", "->", "None"}], ",", 
    RowBox[{"Numbering", "->", "Simple"}], ",", 
    RowBox[{"ColumnsXRows", "->", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "->", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "200"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9740454696976566`*^9, 3.9740455384629517`*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"f29708ea-6149-4444-a688-e09e2ac5f4c8"]
}, Closed]],

Cell[CellGroupData[{

Cell["Um loop", "Subsubsection",
 CellChangeTimes->{{3.974045547296316*^9, 
  3.9740455502578106`*^9}},ExpressionUUID->"ad2b70a9-c374-a940-bf76-\
68ecbee38749"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"twoToTwoOneLoop", "=", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"1", ",", 
     RowBox[{"2", "->", "2"}], ",", 
     RowBox[{"Adjacencies", "->", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}], ",", 
     RowBox[{"ExcludeTopologies", "->", "WFCorrections"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Paint", "[", 
   RowBox[{"twoToTwoOneLoop", ",", 
    RowBox[{"SheetHeader", "->", "None"}], ",", 
    RowBox[{"Numbering", "->", "Simple"}], ",", 
    RowBox[{"ColumnsXRows", "->", 
     RowBox[{"{", 
      RowBox[{"6", ",", "1"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "->", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "200"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.974045558980465*^9, 3.9740456423039455`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"81e07f55-d257-be43-a632-0202b215c83f"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Espalhamento ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{"3", "\[Rule]", "3"}], TraditionalForm], "errors" -> {}, 
     "input" -> "3 \\to 3", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "936ae466-c532-ba4e-b7e6-d852122d5436"],
 " com 3 a 6 arestas permitidas"
}], "Subsection",
 CellChangeTimes->{{3.9740458221303577`*^9, 3.974045841016617*^9}, {
  3.9740464043183556`*^9, 
  3.9740464046160793`*^9}},ExpressionUUID->"cf39f80c-2976-5941-9c56-\
bc1e4c7c62e2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"threeToThreeTreeLevel", "=", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"0", ",", 
     RowBox[{"3", "->", "3"}], ",", 
     RowBox[{"Adjacencies", "->", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Paint", "[", 
   RowBox[{"threeToThreeTreeLevel", ",", 
    RowBox[{"SheetHeader", "->", "None"}], ",", 
    RowBox[{"Numbering", "->", "Simple"}], ",", 
    RowBox[{"ColumnsXRows", "->", 
     RowBox[{"{", 
      RowBox[{"6", ",", "1"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "->", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "200"}], "}"}]}], ",", 
    RowBox[{"AutoEdit", "->", "False"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9740458654992943`*^9, 3.974045897280178*^9}, {
  3.9740463035774727`*^9, 3.974046303662218*^9}, {3.974046336981701*^9, 
  3.974046401240919*^9}, {3.974046447758713*^9, 3.9740464480202293`*^9}, {
  3.974046798533348*^9, 3.9740468013644295`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"16a3004b-64ab-6940-96b7-110f7afb9d63"]
}, Closed]]
}, Closed]]
},
WindowSize->{1141.2, 568.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
SpellingDictionaries->{"CorrectWords"->{"processos"}},
FrontEndVersion->"14.3 for Microsoft Windows (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"caf5304e-6394-f54d-a15d-564be0476db6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[554, 20, 254, 4, 28, "Input",ExpressionUUID->"84fafd90-6b75-f646-9264-300fd62c36a0"],
Cell[811, 26, 182, 3, 28, "Input",ExpressionUUID->"9545bbb6-f3d4-f541-b272-022338aa18ad"],
Cell[996, 31, 394, 8, 66, "Input",ExpressionUUID->"2c6fc924-b17b-9647-a3b5-23370148d3da"],
Cell[CellGroupData[{
Cell[1415, 43, 483, 12, 66, "Section",ExpressionUUID->"90cebfbe-71c7-de4d-aa74-918f19199beb"],
Cell[CellGroupData[{
Cell[1923, 59, 612, 14, 53, "Subsection",ExpressionUUID->"848c2242-509b-4c46-9936-967b8fc686f3"],
Cell[2538, 75, 858, 21, 47, "Input",ExpressionUUID->"4936452e-3359-474c-a345-abf521ceb7d7"]
}, Closed]],
Cell[CellGroupData[{
Cell[3433, 101, 162, 3, 37, "Subsection",ExpressionUUID->"ec7b6cfc-e845-9d40-a1a2-506d524fcc04"],
Cell[3598, 106, 908, 22, 47, "Input",ExpressionUUID->"92684a4f-c0e3-0e44-ad93-6d101830e8a5"],
Cell[CellGroupData[{
Cell[4531, 132, 183, 3, 43, "Subsubsection",ExpressionUUID->"d4bf435a-f113-fd46-ae3e-65416a882958"],
Cell[4717, 137, 1084, 24, 47, "Input",ExpressionUUID->"506f97c5-e260-2046-ba61-bf1a42383ecf"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[5850, 167, 164, 3, 37, "Subsection",ExpressionUUID->"e72460e1-bc8e-6c42-b540-4ee877b4f7b3"],
Cell[6017, 172, 1220, 26, 47, "Input",ExpressionUUID->"cafa13e7-ba8a-104e-ac92-9e7fe7cd47f3"],
Cell[7240, 200, 215, 3, 28, "Input",ExpressionUUID->"a3291070-a180-8f44-aab5-cfefc8e7984a"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[7504, 209, 216, 4, 52, "Section",ExpressionUUID->"0638cd51-b1ef-884f-a02b-40c36caa75fd"],
Cell[CellGroupData[{
Cell[7745, 217, 508, 13, 53, "Subsection",ExpressionUUID->"db93cf45-76be-0843-9b97-a74084b619e5"],
Cell[CellGroupData[{
Cell[8278, 234, 208, 3, 43, "Subsubsection",ExpressionUUID->"b6d11c5b-c6e2-1b45-ac8c-370bc5e78d58"],
Cell[8489, 239, 839, 21, 47, "Input",ExpressionUUID->"f29708ea-6149-4444-a688-e09e2ac5f4c8"]
}, Closed]],
Cell[CellGroupData[{
Cell[9365, 265, 160, 3, 35, "Subsubsection",ExpressionUUID->"ad2b70a9-c374-a940-bf76-68ecbee38749"],
Cell[9528, 270, 898, 22, 47, "Input",ExpressionUUID->"81e07f55-d257-be43-a632-0202b215c83f"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[10475, 298, 558, 14, 37, "Subsection",ExpressionUUID->"cf39f80c-2976-5941-9c56-bc1e4c7c62e2"],
Cell[11036, 314, 1114, 26, 47, "Input",ExpressionUUID->"16a3004b-64ab-6940-96b7-110f7afb9d63"]
}, Closed]]
}, Closed]]
}
]
*)

