## A0

`A0[m^2]` is the Passarino-Veltman one-point integral $A_0.$.

### See also

[Overview](Extra/FeynCalc.md), [B0](B0.md), [C0](C0.md), [D0](D0.md), [PaVe](PaVe.md).

### Examples

By default $A_0$ is not expressed in terms of $B_0$.

```mathematica
A0[m^2]
```

$$\text{A}_0\left(m^2\right)$$

```mathematica
SetOptions[A0, A0ToB0 -> True]; 
 
A0[m^2]
```

$$-\frac{2 m^2 \;\text{B}_0\left(0,m^2,m^2\right)}{2-D}$$

```mathematica
SetOptions[A0, A0ToB0 -> False];
```

According to the rules of dimensional regularization $A_0(0)$ is set to 0.

```mathematica
A0[0]
```

$$0$$

```mathematica
A0[SmallVariable[M^2]]
```

$$0$$