## B00

`B00[pp, ma^2, mb^2]` is the Passarino-Veltman $B_{00}$-function, i.e., the coefficient function of the metric tensor. All arguments are scalars and have dimension mass squared.

### See also

[Overview](Extra/FeynCalc.md), [B0](B0.md), [B1](B1.md), [PaVe](PaVe.md).

### Examples

```mathematica
B00[SPD[p], m^2, M^2]
```

$$\frac{\left(m^2-2 m M+M^2-p^2\right) \left(m^2+2 m M+M^2-p^2\right) \;\text{B}_0\left(p^2,m^2,M^2\right)}{4 (1-D) p^2}+\frac{\text{A}_0\left(M^2\right) \left(m^2-M^2-p^2\right)}{4 (1-D) p^2}-\frac{\text{A}_0\left(m^2\right) \left(m^2-M^2+p^2\right)}{4 (1-D) p^2}$$

```mathematica
B00[SPD[p], m^2, m^2]
```

$$-\frac{\left(4 m^2-p^2\right) \;\text{B}_0\left(p^2,m^2,m^2\right)}{4 (1-D)}-\frac{\text{A}_0\left(m^2\right)}{2 (1-D)}$$

```mathematica
B00[SPD[p], m^2, M^2, BReduce -> False]
```

$$\text{B}_{00}\left(p^2,m^2,M^2\right)$$

```mathematica
B00[0, m^2, m^2]
```

$$-\frac{m^2 \;\text{B}_0\left(0,m^2,m^2\right)}{1-D}-\frac{\text{A}_0\left(m^2\right)}{2 (1-D)}$$

```mathematica
B00[SmallVariable[M^2], m^2, m^2]
```

$$-\frac{m^2 \;\text{B}_0\left(M^2,m^2,m^2\right)}{1-D}-\frac{\text{A}_0\left(m^2\right)}{2 (1-D)}$$