## B1

`B1[pp, ma^2, mb^2]` the Passarino-Veltman $B_1$-function. All arguments are scalars and have dimension mass squared.

### See also

[Overview](Extra/FeynCalc.md), [B0](B0.md), [B00](B00.md), [B11](B11.md), [PaVe](PaVe.md), [PaVeReduce](PaVeReduce.md).

### Examples

```mathematica
B1[SPD[p], m^2, M^2]
```

$$-\frac{\left(m^2-M^2+p^2\right) \;\text{B}_0\left(p^2,m^2,M^2\right)}{2 p^2}+\frac{\text{A}_0\left(m^2\right)}{2 p^2}-\frac{\text{A}_0\left(M^2\right)}{2 p^2}$$

```mathematica
B1[SPD[p], m^2, M^2, BReduce -> False]
```

$$\text{B}_1\left(p^2,m^2,M^2\right)$$

```mathematica
B1[SP[p], m^2, m^2]
```

$$-\frac{1}{2} \;\text{B}_0\left(\overline{p}^2,m^2,m^2\right)$$

```mathematica
B1[SPD[p], m^2, m^2, BReduce -> False]
```

$$\text{B}_1\left(p^2,m^2,m^2\right)$$

```mathematica
B1[m^2, m^2, 0]
```

$$\frac{\text{A}_0\left(m^2\right)}{2 m^2}-\text{B}_0\left(m^2,0,m^2\right)$$

```mathematica
B1[m^2, m^2, 0, BReduce -> False]
```

$$\text{B}_1\left(m^2,m^2,0\right)$$

```mathematica
B1[0, 0, m^2]
```

$$\text{B}_1\left(0,0,m^2\right)$$

```mathematica
B1[pp, SmallVariable[SMP["m_e"]^2], Subsuperscript[m, 2, 2]]
```

$$-\frac{(\text{pp}-m_2^2) \;\text{B}_0\left(\text{pp},m_e^2,m_2^2\right)}{2 \;\text{pp}}-\frac{\text{A}_0(m_2^2)}{2 \;\text{pp}}$$