## B11

`B11[pp, ma^2, mb^2]` is the Passarino-Veltman $B_{11}$-function, i.e. the coefficient function of $p^{\mu } p^{\nu }$. All arguments are scalars and have dimension mass squared.

### See also

[Overview](Extra/FeynCalc.md), [B0](B0.md), [B00](B00.md), [B1](B1.md), [PaVe](PaVe.md).

### Examples

```mathematica
B11[SPD[p], m^2, M^2]
```

$$-\frac{\left(D m^4-2 D m^2 M^2+2 D m^2 p^2+D M^4-2 D M^2 p^2+D p^4-4 m^2 p^2\right) \;\text{B}_0\left(p^2,m^2,M^2\right)}{4 (1-D) p^4}+\frac{D \;\text{A}_0\left(m^2\right) \left(m^2-M^2+p^2\right)}{4 (1-D) p^4}-\frac{\text{A}_0\left(M^2\right) \left(D m^2-D M^2+3 D p^2-4 p^2\right)}{4 (1-D) p^4}$$

```mathematica
B11[SPD[p], m^2, M^2, BReduce -> False]
```

$$\text{B}_{11}\left(p^2,m^2,M^2\right)$$

```mathematica
B11[SPD[p], m^2, m^2]
```

$$\frac{\left(4 m^2-D p^2\right) \;\text{B}_0\left(p^2,m^2,m^2\right)}{4 (1-D) p^2}+\frac{(2-D) \;\text{A}_0\left(m^2\right)}{2 (1-D) p^2}$$

```mathematica
B11[SPD[p], m^2, m^2, BReduce -> False]
```

$$\text{B}_{11}\left(p^2,m^2,m^2\right)$$

```mathematica
B11[0, m^2, m^2]
```

$$\frac{1}{3} \;\text{B}_0\left(0,m^2,m^2\right)$$

```mathematica
B11[0, m^2, m^2, BReduce -> False]
```

$$\text{B}_{11}\left(0,m^2,m^2\right)$$

```mathematica
B11[SmallVariable[M^2], m^2, m^2]
```

$$\frac{m^2 \;\text{B}_0\left(M^2,m^2,m^2\right)}{(1-D) M^2}+\frac{(2-D) \;\text{A}_0\left(m^2\right)}{2 (1-D) M^2}$$

```mathematica
B11[SmallVariable[M^2], m^2, m^2, BReduce -> False]
```

$$\text{B}_{11}\left(M^2,m^2,m^2\right)$$