## C0

`C0[p10, p12, p20, m1^2, m2^2, m3^2]` is the scalar Passarino-Veltman $C_0$ function. The convention for the arguments is that if the denominator of the integrand has the form $([q^2-m1^2] [(q+p1)^2-m2^2] [(q+p2)^2-m3^2])$, the first three arguments of C0 are the scalar products $p10 = p1^2$, $p12 = (p1-p2).(p1-p2)$, $p20 = p2^2$.

### See also

[Overview](Extra/FeynCalc.md), [B0](B0.md), [D0](D0.md), [PaVe](PaVe.md), [PaVeOrder](PaVeOrder.md).

### Examples

```mathematica
C0[a, b, c, m12, m22, m32]
```

$$\text{C}_0(a,b,c,\text{m12},\text{m22},\text{m32})$$

```mathematica
C0[b, a, c, m32, m22, m12] // PaVeOrder
```

$$\text{C}_0(a,b,c,\text{m12},\text{m22},\text{m32})$$

```mathematica
PaVeOrder[C0[b, a, c, m32, m22, m12], PaVeOrderList -> {c, a}]
```

$$\text{C}_0(c,a,b,\text{m32},\text{m12},\text{m22})$$