## D0

`D0[p10, p12, p23, p30, p20, p13, m1^2, m2^2, m3^2, m4^2 ]` is the Passarino-Veltman $D_0$ function. The convention for the arguments is that if the denominator of the integrand has the form $([q^2-m1^2] [(q+p1)^2-m2^2] [(q+p2)^2-m3^2] [(q+p3)^2-m4^2])$, the first six arguments of `D0` are the scalar products $p10 = p1^2$, $p12 = (p1-p2)^2$, $p23 = (p2-p3)^2$, $p30 = p3^2$, $p20 = p2^2$, $p13 = (p1-p3)^2$.

### See also

[Overview](Extra/FeynCalc.md), [B0](B0.md), [C0](C0.md), [PaVe](PaVe.md), [PaVeOrder](PaVeOrder.md).

### Examples

```mathematica
D0[p10, p12, p23, p30, p20, p13, m1^2, m2^2, m3^2, m4^2]
```

$$\text{D}_0\left(\text{p10},\text{p12},\text{p23},\text{p30},\text{p20},\text{p13},\text{m1}^2,\text{m2}^2,\text{m3}^2,\text{m4}^2\right)$$

```mathematica
PaVeOrder[D0[p10, p12, p23, p30, p20, p13, m1^2, m2^2, m3^2, m4^2], PaVeOrderList -> {p13, p20}]
```

$$\text{D}_0\left(\text{p10},\text{p30},\text{p23},\text{p12},\text{p13},\text{p20},\text{m2}^2,\text{m1}^2,\text{m4}^2,\text{m3}^2\right)$$

```mathematica
PaVeOrder[%]
```

$$\text{D}_0\left(\text{p10},\text{p12},\text{p23},\text{p30},\text{p20},\text{p13},\text{m1}^2,\text{m2}^2,\text{m3}^2,\text{m4}^2\right)$$