## DiracBasis

`DiracBasis[any]` is a head which is wrapped around Dirac structures (and the `1`) as a result of the function `DiracReduce`. For more details, see the documentation for `DiracReduce`.

### See also

[Overview](Extra/FeynCalc.md)

### Examples

```mathematica
Options[DiracReduce]
```

$$\{\text{Contract}\to \;\text{True},\text{DiracGammaCombine}\to \;\text{True},\text{DiracSimplify}\to \;\text{False},\text{DiracSpinorNormalization}\to \;\text{Relativistic},\text{DiracOrder}\to \;\text{True},\text{DotSimplify}\to \;\text{True},\text{FeynCalcExternal}\to \;\text{False},\text{FeynCalcInternal}\to \;\text{False},\text{FCVerbose}\to \;\text{False},\text{Factoring}\to \;\text{False},\text{FinalSubstitutions}\to \{\text{DiracBasis}\to \;\text{Identity}\},\text{SpinorChainEvaluate}\to \;\text{True}\}$$

```mathematica
DiracReduce[GA[\[Mu], \[Nu], \[Rho]], FinalSubstitutions -> {}]
```

$$i \;\text{DiracBasis}\left(\text{DiracBasis}\left(\bar{\gamma }^{\text{\$MU}(\text{\$19})}\right).\text{DiracBasis}\left(\bar{\gamma }^5\right)\right) \bar{\epsilon }^{\mu \nu \rho \;\text{\$MU}(\text{\$19})}+\text{DiracBasis}\left(\bar{\gamma }^{\rho }\right) \bar{g}^{\mu \nu }-\text{DiracBasis}\left(\bar{\gamma }^{\nu }\right) \bar{g}^{\mu \rho }+\text{DiracBasis}\left(\bar{\gamma }^{\mu }\right) \bar{g}^{\nu \rho }$$