## LorentzIndex

`LorentzIndex[mu]` denotes a $4$-dimensional Lorentz index.

For other than $4$ dimensions: `LorentzIndex[mu, D]` or `LorentzIndex[mu]` etc.

`LorentzIndex[mu, 4]` simplifies to `LorentzIndex[mu]`.

### See also

[Overview](Extra/FeynCalc.md), [ChangeDimension](ChangeDimension.md), [Momentum](Momentum.md).

### Examples

This denotes a $4$-dimensional Lorentz index.

```mathematica
LorentzIndex[\[Alpha]]
```

$$\alpha$$

An optional second argument can be given for a dimension different from $4$.

```mathematica
LorentzIndex[\[Alpha], n]
```

$$\alpha$$