## UnDeclareAntiCommutator

`UnDeclareAntiCommutator[a, b]` undeclares the value assigned to the anti-commutator of `a` and `b`.

### See also

[Overview](Extra/FeynCalc.md), [FCCommutator](FCCommutator.md), [CommutatorExplicit](CommutatorExplicit.md), [DeclareNonCommutative](DeclareNonCommutative.md), [DotSimplify](DotSimplify.md).

### Examples

```mathematica
FCAntiCommutator[QuantumField[FCPartialD[LorentzIndex[xxx_]], A], QuantumField[A]] = 0;
```

```mathematica
QuantumField[A] . QuantumField[A] . LeftPartialD[\[Nu]] 
 
ExpandPartialD[%]
```

$$A.A.\overleftarrow{\partial }_{\nu }$$

$$0$$

```mathematica
UnDeclareAntiCommutator[QuantumField[FCPartialD[LorentzIndex[xxx_]], A], QuantumField[A]];
```

```mathematica
ExpandPartialD[QuantumField[A] . QuantumField[A] . LeftPartialD[\[Nu]]]
```

$$A.\left(\partial _{\nu }A\right)+\left(\partial _{\nu }A\right).A$$