
(***************** This is the FeynRules model file for QCD, with three flavors ************************)

M$ModelName = "First_Example";

M$Information = {Authors -> "C. Duhr",
                 Institutions -> "Universite catholique de Louvain (CP3)",
                 Emails -> "claude.duhr@uclouvain.be",
                 Date -> "05. 03. 2008"};



(********** Index definition *********)

IndexRange[ Index[Generation] ] = Range[3]

IndexRange[ Index[Colour] ] = Range[3]

IndexRange[ Index[Gluon] ] = Range[8]


IndexStyle[Colour, i]

IndexStyle[Gluon, a]

IndexStyle[Generation, f]

(***** Parameter list ******)

M$Parameters = {

  gs == {
     InteractionOrder -> {QCD, 1},
     Value -> 1.2,
     TeX -> Subscript[g, s]}

}

(***** Gauge group list ******)

M$GaugeGroups = {

  SU3C == {
      Abelian -> False,
      GaugeBoson -> G,
      StructureConstant -> f,
      Representations -> {T, Colour},
      CouplingConstant -> gs} 

}

(***** Particle classes list ******)

M$ClassesDescription = {

  F[1] == {
      ClassName -> q,
      ClassMembers -> {u, c, t},
      SelfConjugate -> False,
      Indices -> {Index[Generation], Index[Colour]},
      FlavorIndex -> Generation,
      Mass -> {MQ, {MU, 1.2}, {MC, 5.7}, {MT, 20.4}},
      Width -> {0, {WC, 8}, {WT, 120}}},
 
  V[1] == {
      ClassName -> G,
      SelfConjugate -> True,
      Indices -> {Index[Gluon]},
      Mass -> 0,
      Width -> 0}       

}














