M$ModelName = "Phi4";

M$Information = {
   Authors -> {"Lucas Heck"},
   Institutions -> {"UFABC"},
   Emails -> {"lucas.heck@ufabc.edu.br"},
   Date -> "November 22, 2025"
   };

M$Parameters = {
   lambda == {
     ParameterType -> Internal,
     ParameterName -> \[Lambda],
     Description -> "self-interaction coupling"
     }
   };

M$ClassesDescription = {
   S[1] == {
     ClassName -> phi,
     ParticleName -> "\[Phi]",
     PropagatorLabel -> "\[Phi]",
     SelfConjugate -> True,
     Mass -> mphi
     }
   };

LFree = 1/2 del[phi, mu] del[phi, mu] - 1/2 mphi^2 phi^2;
LInteraction = - 1/(4!) lambda phi^4;
LPhi4 = LFree + LInteraction;