M$ModelName = "Scalar QE";

M$Information = {
  Authors      -> {"Lucas Heck"},
  Institutions -> {"UFABC"},
  Emails       -> {"lucas.heck@ufabc.edu.br"},
  Date         -> "03.12.2025"
};

M$Parameters = {
    g3 == {ParameterType -> Internal},
    g4 == {ParameterType -> Internal},
    EL == {ParameterType -> Internal}
    };

M$GaugeGroups = {
    U1 == {
        Abelian -> True,
        CouplingConstant -> EL,
        GaugeBoson -> A,
        Charge -> Q
    }
};

M$ClassesDescription = {
    S[1] == {
        ClassName     -> phi,
        SelfConjugate -> False,
        ParticleName    -> "\[Phi]",
        AntiParticleName -> "Superscipt[\[Phi],\[Dagger]]"
        PropagatorLabel -> "\[Phi]",
        QuantumNumbers -> {Q -> 1},
        Mass -> Mphi,
        PropagatorArrow -> None
    },
    V[1] == {
        ClassName -> A,
        SelfConjugate -> True,
        Mass -> 0,
        PropagatorLabel -> "\\gamma",
        PropagatorType -> W,
        PropagatorArrow -> None
    }
};

LSQED = LGauge + LScalar + LInt;
LGauge = -1/4 FS[A, mu, nu] FS[A, mu, nu];
LScalar = DC[phibar, mu] DC[phi, mu] - Mphi^2*phibar phi - 1/4 g4*(phibar phi)^2;
LInt = EL^2 A[mu] A[mu] phibar phi;
