(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    530630,      14247]
NotebookOptionsPosition[    459694,      13467]
NotebookOutlinePosition[    460094,      13483]
CellTagsIndexPosition[    460051,      13480]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.973601451883024*^9, 3.973601486051441*^9}, {
  3.9736015643596535`*^9, 3.973601576374487*^9}, {3.9736016730844574`*^9, 
  3.973601688026371*^9}, {3.9736022103512096`*^9, 3.973602213609564*^9}, {
  3.9736044058653107`*^9, 3.973604409744526*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"ac5cfdb8-898d-5c4c-af18-94f0d527cfb9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynArtsPath", "=", 
   RowBox[{
   "SetDirectory", 
    "[", "\"\<C:\\\\Users\\\\lucas\\\\Documents\\\\UFABC\\\\Quadrimestres\\\\\
2025.2\\\\tqc1\\\\seminario\\\\FeynArts\>\"", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"<<", "FeynArts`"}], ";"}]}], "Input",
 CellChangeTimes->{{3.973602217948185*^9, 3.9736022347188168`*^9}, {
   3.973602772828539*^9, 3.9736027870990047`*^9}, 3.973602835477352*^9, {
   3.973602875916073*^9, 3.973602876076166*^9}, {3.9736044368071938`*^9, 
   3.9736044606693*^9}, {3.9736044956433296`*^9, 3.973604502582777*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"972b9f63-3a45-a44e-9436-79c3777ec4f9"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.9736045339417763`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"6b014403-b1bc-4747-a79f-f0afb6c3721e"],

Cell[BoxData["\<\"FeynArts 3.12 (27 Mar 2025)\"\>"], "Print",
 CellChangeTimes->{3.973604533942793*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"ca4d05d8-708c-ad45-a898-c1794d24abde"],

Cell[BoxData["\<\"by Hagen Eck, Sepp Kueblbeck, and Thomas Hahn\"\>"], "Print",
 CellChangeTimes->{3.9736045339437733`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"af14c6d5-01f4-7f41-9f99-76a10335e13b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", 
    "[", "\"\<C:\\\\Users\\\\lucas\\\\Documents\\\\UFABC\\\\Quadrimestres\\\\\
2025.2\\\\tqc1\\\\seminario\\\\FeynRules\>\"", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"<<", "FeynRules`"}], ";"}]}], "Input",
 CellChangeTimes->{{3.973602240848076*^9, 3.9736022453972263`*^9}, {
  3.9736044661695786`*^9, 3.973604527508047*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"075c974c-b192-b14a-ba66-e2709fb4161c"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{
  3.9736042464964294`*^9, {3.973604478738104*^9, 3.9736044920769634`*^9}, 
   3.9736045340754433`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"3ae00364-64de-0740-bddd-4220f9e198a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.49\"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"29 September 2021\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.49", " (" "29 September 2021", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9736042464964294`*^9, {3.973604478738104*^9, 3.9736044920769634`*^9}, 
   3.973604534076475*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"461bd41e-0961-2a4f-8c90-5131cfcf1003"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.9736042464964294`*^9, {3.973604478738104*^9, 3.9736044920769634`*^9}, 
   3.973604534077463*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"e8cc1f2e-96d7-d247-b5d5-c0a88ef1bd45"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.9736042464964294`*^9, {3.973604478738104*^9, 3.9736044920769634`*^9}, 
   3.973604534077463*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"3539ffc5-3c05-794f-b5b5-e09d5c114f1c"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{
  3.9736042464964294`*^9, {3.973604478738104*^9, 3.9736044920769634`*^9}, 
   3.973604534077463*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"34d6bde5-9464-194b-8984-5a92246d927b"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{
  3.9736042464964294`*^9, {3.973604478738104*^9, 3.9736044920769634`*^9}, 
   3.973604534078457*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"942463f7-a670-0246-8bee-6a5dc156912b"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{
  3.9736042464964294`*^9, {3.973604478738104*^9, 3.9736044920769634`*^9}, 
   3.973604534078457*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"c021ba75-4d94-5b47-aa27-32c37ab5f188"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.9736042464964294`*^9, {3.973604478738104*^9, 3.9736044920769634`*^9}, 
   3.9736045340794373`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"fc8a7484-7fa3-ef43-91bf-2b75492a49ab"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{
  3.9736042464964294`*^9, {3.973604478738104*^9, 3.9736044920769634`*^9}, 
   3.9736045340794373`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"66dff0ac-cf0c-6346-aa75-146d006dc5a0"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.9736042464964294`*^9, {3.973604478738104*^9, 3.9736044920769634`*^9}, 
   3.9736045340794373`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"d60d92dc-a6ab-a749-aa88-320c718e6c19"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{
  3.9736042464964294`*^9, {3.973604478738104*^9, 3.9736044920769634`*^9}, 
   3.9736045340794373`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"d15c31ff-443d-804f-8669-ef879bf8a13b"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "M$ClassesDescription", "shdw", 
   "\"Symbol \
\\!\\(\\*RowBox[{\\\"\\\\\\\"M$ClassesDescription\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 1, 17259147130221567992, "Local", 
   "FeynRules`M$ClassesDescription"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604534107605*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"95ab091f-bd34-3c42-8ab1-6b7cffcd679e"],

Cell[BoxData[
 TemplateBox[{
  "SelfConjugate", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"SelfConjugate\\\\\\\"\\\"}]\\) \
appears in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 2, 17259147130221567992, "Local", 
   "FeynRules`SelfConjugate"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045341110935`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"877b9536-6ec3-0a4a-82bc-3be1f84d4279"],

Cell[BoxData[
 TemplateBox[{
  "QuantumNumbers", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"QuantumNumbers\\\\\\\"\\\"}]\\) \
appears in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 3, 17259147130221567992, "Local", 
   "FeynRules`QuantumNumbers"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045341300926`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"8711a5e0-77a7-c748-bb82-7a1838f49b7d"],

Cell[BoxData[
 TemplateBox[{
  "Mass", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"Mass\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 4, 17259147130221567992, "Local", 
   "FeynRules`Mass"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604534164032*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"833f53d3-2008-704b-9fb3-6d77cdaa653a"],

Cell[BoxData[
 TemplateBox[{
  "PropagatorType", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"PropagatorType\\\\\\\"\\\"}]\\) \
appears in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 5, 17259147130221567992, "Local", 
   "FeynRules`PropagatorType"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604534166868*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"25d8cc1e-625f-3d4a-a37a-2638cd1d980d"],

Cell[BoxData[
 TemplateBox[{
  "PropagatorLabel", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"PropagatorLabel\\\\\\\"\\\"}]\\) \
appears in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 6, 17259147130221567992, "Local", 
   "FeynRules`PropagatorLabel"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604534170868*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"35b73843-bfaf-a24f-bd38-35512a9ffd6a"],

Cell[BoxData[
 TemplateBox[{
  "PropagatorArrow", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"PropagatorArrow\\\\\\\"\\\"}]\\) \
appears in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 7, 17259147130221567992, "Local", 
   "FeynRules`PropagatorArrow"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604534189762*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"788528b1-1399-2c44-9916-7659381be3ab"],

Cell[BoxData[
 TemplateBox[{
  "MixingPartners", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"MixingPartners\\\\\\\"\\\"}]\\) \
appears in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 8, 17259147130221567992, "Local", 
   "FeynRules`MixingPartners"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045341978264`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"b0a89713-764a-0846-b74f-f1dacfce9b06"],

Cell[BoxData[
 TemplateBox[{
  "MatrixTraceFactor", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"MatrixTraceFactor\\\\\\\"\\\"}]\\) \
appears in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 9, 17259147130221567992, "Local", 
   "FeynRules`MatrixTraceFactor"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045342169724`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"474a2ac0-24f7-f048-8c9c-ebe30291f866"],

Cell[BoxData[
 TemplateBox[{
  "InsertOnly", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"InsertOnly\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 10, 17259147130221567992, "Local", 
   "FeynRules`InsertOnly"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604534234665*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"8bb4280d-709d-3545-a457-4e5e02b0233a"],

Cell[BoxData[
 TemplateBox[{
  "S", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"S\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 11, 17259147130221567992, "Local", 
   "FeynRules`S"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045342411537`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"2e41e521-04ed-a043-aa4c-a0519d0a51b0"],

Cell[BoxData[
 TemplateBox[{
  "T", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"T\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 12, 17259147130221567992, "Local", 
   "FeynRules`T"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604534261278*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"5ad9dc1b-6ae9-e448-8ee4-1ceb8365d8f3"],

Cell[BoxData[
 TemplateBox[{
  "Indices", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"Indices\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 13, 17259147130221567992, "Local", 
   "FeynRules`Indices"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045342793617`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"52e6fab8-4a9d-954b-ad6d-ef6d55812281"],

Cell[BoxData[
 TemplateBox[{
  "Straight", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"Straight\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 14, 17259147130221567992, "Local", 
   "FeynRules`Straight"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045342979145`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"68f67ed1-5b50-3b4a-98f1-e4e367d908fd"],

Cell[BoxData[
 TemplateBox[{
  "ScalarDash", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"ScalarDash\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 15, 17259147130221567992, "Local", 
   "FeynRules`ScalarDash"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045343009014`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"b7d5deeb-77cc-a342-9352-b3d85f49c769"],

Cell[BoxData[
 TemplateBox[{
  "GhostDash", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"GhostDash\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 16, 17259147130221567992, "Local", 
   "FeynRules`GhostDash"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045343220253`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"25a9db29-f5b2-5048-8dd2-669efe14aa68"],

Cell[BoxData[
 TemplateBox[{
  "Sine", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"Sine\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 17, 17259147130221567992, "Local", 
   "FeynRules`Sine"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.97360453434214*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"44f91c81-ea5b-244b-8e28-2ac7a1545875"],

Cell[BoxData[
 TemplateBox[{
  "F", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"F\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 18, 17259147130221567992, "Local", 
   "FeynRules`F"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045343451405`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"7aa76c5a-5a7f-ce4e-92cb-cd969de89c48"],

Cell[BoxData[
 TemplateBox[{
  "V", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"V\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 19, 17259147130221567992, "Local", 
   "FeynRules`V"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604534363062*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"2cdbb681-5868-bd46-957c-f878bb126f53"],

Cell[BoxData[
 TemplateBox[{
  "U", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"U\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 20, 17259147130221567992, "Local", 
   "FeynRules`U"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045343826103`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"16d27ae4-7357-d342-8910-d2520c696647"],

Cell[BoxData[
 TemplateBox[{
  "External", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"External\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 21, 17259147130221567992, "Local", 
   "FeynRules`External"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045343866386`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"334ae3a0-0830-2c49-8118-0cb566c04dd8"],

Cell[BoxData[
 TemplateBox[{
  "Internal", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"Internal\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 22, 17259147130221567992, "Local", 
   "FeynRules`Internal"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045344037304`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"8d0b96e8-4cbc-af43-865d-652489d92bf8"],

Cell[BoxData[
 TemplateBox[{
  "LoadModel", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"LoadModel\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 23, 17259147130221567992, "Local", 
   "FeynRules`LoadModel"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045344212646`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"accb8009-9fac-f842-99b9-1c42c63ff3fa"],

Cell[BoxData[
 TemplateBox[{
  "IndexRange", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"IndexRange\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 24, 17259147130221567992, "Local", 
   "FeynRules`IndexRange"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045344428215`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"6a9553c3-1ab8-2347-a196-7abc9a3bd9f3"],

Cell[BoxData[
 TemplateBox[{
  "IndexStyle", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"IndexStyle\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 25, 17259147130221567992, "Local", 
   "FeynRules`IndexStyle"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045344458466`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"de0f5fe1-136e-164a-9c7b-0cac82d3c6ed"],

Cell[BoxData[
 TemplateBox[{
  "Index", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"Index\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 26, 17259147130221567992, "Local", 
   "FeynRules`Index"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045344664*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"7e6292b0-48da-4240-8518-ed414979a284"],

Cell[BoxData[
 TemplateBox[{
  "Vertices", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"Vertices\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 27, 17259147130221567992, "Local", 
   "FeynRules`Vertices"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045344845257`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"d8975a5c-a3ff-b846-960b-c9df067fd043"],

Cell[BoxData[
 TemplateBox[{
  "GaugeXi", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"GaugeXi\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 28, 17259147130221567992, "Local", 
   "FeynRules`GaugeXi"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045344885387`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"d5d189db-e56d-9049-bec9-90965e6a373f"],

Cell[BoxData[
 TemplateBox[{
  "SymmetryFactor", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"SymmetryFactor\\\\\\\"\\\"}]\\) \
appears in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 29, 17259147130221567992, "Local", 
   "FeynRules`SymmetryFactor"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045345096226`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"25790802-c5f7-b242-917f-69d54248cdb9"],

Cell[BoxData[
 TemplateBox[{
  "Restrictions", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"Restrictions\\\\\\\"\\\"}]\\) \
appears in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 30, 17259147130221567992, "Local", 
   "FeynRules`Restrictions"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045345283604`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"2b84a5b9-ca44-e246-a925-7caccfa76131"],

Cell[BoxData[
 TemplateBox[{
  "CC", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"CC\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 31, 17259147130221567992, "Local", 
   "FeynRules`CC"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604534547329*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"4b7c10dd-b6f6-7c43-9019-dd3118fd438b"],

Cell[BoxData[
 TemplateBox[{
  "LeviCivita", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"LeviCivita\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 32, 17259147130221567992, "Local", 
   "FeynRules`LeviCivita"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604534551756*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"c01081cd-c03a-de42-a213-3032f98da367"],

Cell[BoxData[
 TemplateBox[{
  "IndexEps", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"IndexEps\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 33, 17259147130221567992, "Local", 
   "FeynRules`IndexEps"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045345732727`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"d0b85543-1063-0947-aced-261b7995d9b5"],

Cell[BoxData[
 TemplateBox[{
  "Lorentz", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"Lorentz\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"Global`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \\!\
\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 34, 17259147130221567992, "Local", 
   "FeynRules`Lorentz"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045345904217`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"2b640d9f-4441-8e44-b9d5-478df30141f7"],

Cell[BoxData[
 TemplateBox[{
  "NoUnfold", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"NoUnfold\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 35, 17259147130221567992, "Local", 
   "FeynRules`NoUnfold"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604534594412*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"48cb9491-4c5a-5741-9c9e-5765e2b467f0"],

Cell[BoxData[
 TemplateBox[{
  "G", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"G\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 36, 17259147130221567992, "Local", 
   "FeynRules`G"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045346114044`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"e1a3e8f0-d479-f344-aa15-4bb9e0b91917"],

Cell[BoxData[
 TemplateBox[{
  "IndexSum", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"IndexSum\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 37, 17259147130221567992, "Local", 
   "FeynRules`IndexSum"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045346320095`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"a6eeebe4-67a1-b240-bc27-f70c87a83230"],

Cell[BoxData[
 TemplateBox[{
  "Mix", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"Mix\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 38, 17259147130221567992, "Local", 
   "FeynRules`Mix"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045346365623`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"7ab4cf84-19c9-b344-bc9c-e8e88fb7217d"],

Cell[BoxData[
 TemplateBox[{
  "Particles", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"Particles\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 39, 17259147130221567992, "Local", 
   "FeynRules`Particles"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604534654009*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"23dec6a6-778d-e348-bd86-ce4972f38a5d"],

Cell[BoxData[
 TemplateBox[{
  "Vertex", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"Vertex\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 40, 17259147130221567992, "Local", 
   "FeynRules`Vertex"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045346728992`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"d05419e1-d078-c043-b1e1-ddafd284c4c1"],

Cell[BoxData[
 TemplateBox[{
  "IndexDelta", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"IndexDelta\\\\\\\"\\\"}]\\) appears \
in multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\", \\\",\\\", \
\\\"\\\\\\\"FeynArts`\\\\\\\"\\\"}], \\\"}\\\"}]\\); definitions in context \
\\!\\(\\*RowBox[{\\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}]\\) may shadow or be \
shadowed by other definitions.\"", 2, 4, 41, 17259147130221567992, "Local", 
   "FeynRules`IndexDelta"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604534727646*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"25496c4a-3d52-2e4b-93d0-d0e974b7cfad"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"Commutator\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"Commutator\\\", \\\"[\\\", RowBox[{RowBox[{SubscriptBox[\
\\\"\\\\\\\"\[PartialD]\\\\\\\"\\\", \\\"mu_\\\"], \\\"[\\\", \\\"psi_\\\", \
\\\"]\\\"}], \\\",\\\", \\\"aa_\\\"}], \\\"]\\\"}]\\) is Protected.\"", 2, 4, 
   42, 17259147130221567992, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604534860033*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"e5293c4e-d68c-344f-a3e0-81473e1bf17d"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"Commutator\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"Commutator\\\", \\\"[\\\", RowBox[{\\\"psi1_\\\", \
\\\",\\\", RowBox[{\\\"crea\\\", \\\"[\\\", RowBox[{\\\"psi2_\\\", \\\",\\\", \
\\\"inds_\\\", \\\",\\\", \\\"i_\\\"}], \\\"]\\\"}]}], \\\"]\\\"}]\\) is \
Protected.\"", 2, 4, 43, 17259147130221567992, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045348630466`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"30c9597b-d9c4-0f44-bfd3-ca77e4ab8071"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", 2, 4, 44, 
   17259147130221567992, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045349075527`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"4fc6d023-d20f-8b44-b553-c5847dd41522"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 4, 45, 17259147130221567992, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604534926111*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"610728c0-5825-7340-b8ce-886ecfb22136"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"Commutator\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"Commutator\\\", \\\"[\\\", RowBox[{RowBox[{SubscriptBox[\
\\\"\\\\\\\"\[PartialD]\\\\\\\"\\\", \\\"mu_\\\"], \\\"[\\\", \\\"psi_\\\", \
\\\"]\\\"}], \\\",\\\", \\\"aa_\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 
   4, 46, 17259147130221567992, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.973604542258295*^9},
 CellLabel->
  "kernel 1 (Local)",ExpressionUUID->"11659b13-1bd0-284d-a28c-df6370f11864"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"Commutator\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"Commutator\\\", \\\"[\\\", RowBox[{RowBox[{SubscriptBox[\
\\\"\\\\\\\"\[PartialD]\\\\\\\"\\\", \\\"mu_\\\"], \\\"[\\\", \\\"psi_\\\", \
\\\"]\\\"}], \\\",\\\", \\\"aa_\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 
   4, 47, 17259147130221567992, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9736045422835464`*^9},
 CellLabel->
  "kernel 2 (Local)",ExpressionUUID->"2548b8c4-8084-004e-bdb1-bb260c0c87cf"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"Commutator\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"Commutator\\\", \\\"[\\\", RowBox[{RowBox[{SubscriptBox[\
\\\"\\\\\\\"\[PartialD]\\\\\\\"\\\", \\\"mu_\\\"], \\\"[\\\", \\\"psi_\\\", \
\\\"]\\\"}], \\\",\\\", \\\"aa_\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 
   4, 48, 17259147130221567992, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.973604542319168*^9},
 CellLabel->
  "kernel 3 (Local)",ExpressionUUID->"64a57c39-612c-4149-8b14-928a00dedf32"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"Commutator\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"Commutator\\\", \\\"[\\\", RowBox[{RowBox[{SubscriptBox[\
\\\"\\\\\\\"\[PartialD]\\\\\\\"\\\", \\\"mu_\\\"], \\\"[\\\", \\\"psi_\\\", \
\\\"]\\\"}], \\\",\\\", \\\"aa_\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 
   4, 49, 17259147130221567992, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.973604542351116*^9},
 CellLabel->
  "kernel 4 (Local)",ExpressionUUID->"427d000c-5b19-2441-b738-d2baba35e211"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"Commutator\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"Commutator\\\", \\\"[\\\", RowBox[{RowBox[{SubscriptBox[\
\\\"\\\\\\\"\[PartialD]\\\\\\\"\\\", \\\"mu_\\\"], \\\"[\\\", \\\"psi_\\\", \
\\\"]\\\"}], \\\",\\\", \\\"aa_\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 
   4, 50, 17259147130221567992, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.973604542378378*^9},
 CellLabel->
  "kernel 5 (Local)",ExpressionUUID->"7380f0b0-10dc-0647-b7bb-5ec9820e7852"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 4, 51, 17259147130221567992, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.9736045424148655`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"9dc7b312-317f-ce44-8d55-15a3348aab6c"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 4, 52, 17259147130221567992, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.973604542462866*^9},
 CellLabel->
  "kernel 1 (Local)",ExpressionUUID->"22bd1f94-9961-f84a-b362-872dfbd6e60e"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 4, 53, 17259147130221567992, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9736045424813023`*^9},
 CellLabel->
  "kernel 2 (Local)",ExpressionUUID->"4f6752e2-a727-af48-b462-b449d0d85fb4"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 4, 54, 17259147130221567992, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.973604542496395*^9},
 CellLabel->
  "kernel 3 (Local)",ExpressionUUID->"fa3c3bf2-feea-3f4b-806a-a5bc6bd4da87"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 4, 55, 17259147130221567992, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.973604542513794*^9},
 CellLabel->
  "kernel 4 (Local)",ExpressionUUID->"75a37fea-40a8-3545-816f-dc319c4d12e2"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 4, 56, 17259147130221567992, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.973604542530216*^9},
 CellLabel->
  "kernel 5 (Local)",ExpressionUUID->"d115802f-9372-3d48-bb2c-fcd17533a9ab"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*RowBox[{\\\"\\\\\\\"Further output of `1` \
will be suppressed during this calculation.\\\\\\\"\\\"}]\\) will be \
suppressed during this calculation.\"", 2, 4, 57, 17259147130221567992, 
   "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736042466734295`*^9, {3.97360447792898*^9, 3.9736044920319004`*^9}, 
   3.973604542545826*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"28db163f-fab3-ec43-a2d3-2d0335218958"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", "\"\<qed.fr\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.9736022625168056`*^9, 3.973602275448387*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"7cb380c0-1c2a-d842-91d1-f6e63d939fa1"],

Cell[CellGroupData[{

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.973604253469837*^9, 3.9736045488469677`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"64252716-e6c0-8b46-83dc-ef5110f5f00f"],

Cell[BoxData["\<\"Lucas Heck\"\>"], "Print",
 CellChangeTimes->{3.973604253469837*^9, 3.973604548847904*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"3f907c28-1aad-0a40-aa7e-4d9de7d4e4ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.973604253469837*^9, 3.9736045488489456`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"aa9c7dc7-f65c-1543-b2f9-591b058e7580"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.973604253469837*^9, 3.9736045488489456`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"8b980ec3-2b4b-4049-906f-69871970cdfe"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.973604253469837*^9, 3.973604548849945*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"e9449411-9b1e-4f47-b000-cd552ede87cc"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.973604253469837*^9, 3.973604548849945*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"35c62669-4a31-2045-a2cd-6de921297b04"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.973604253469837*^9, 3.973604548866022*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"b78a572a-34e0-5644-b1b0-bf7b66218ec7"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.973604253469837*^9, 3.9736045488669777`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"d1a93e13-28f4-df49-8820-98ef953745b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"QED\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "QED", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.973604253469837*^9, 3.973604548868042*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"0ca8cef9-fc3f-554d-b347-a69c2164ff61"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["FullLag"], "Input",
 CellChangeTimes->{{3.973602554280279*^9, 3.9736025552053223`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"5f45133a-30c4-4f49-a490-39b934c560e8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "4"]}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
        SubscriptBox["A", "mu"], "]"}]}], "+", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
       SubscriptBox["A", "nu"], "]"}]}], ")"}], "2"]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "Me"}], " ", 
      SubscriptBox["e", "s"], " ", 
      SubscriptBox[
       OverscriptBox["e", "\<\"-\"\>"], "s"]}], "+", 
     RowBox[{
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
       SubscriptBox["e", "r"], "]"}], " ", 
      SubscriptBox[
       OverscriptBox["e", "\<\"-\"\>"], "s"], " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"s", ",", "r"}]], "mu"},
       "Superscript"]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      SubscriptBox["A", "mu"], " ", 
      SubscriptBox["e", "r"], " ", 
      SubscriptBox[
       OverscriptBox["e", "\<\"-\"\>"], "s"], " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"s", ",", "r"}]], "mu"},
       "Superscript"]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.9736042535141087`*^9, 3.973604551317833*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"11c98f54-55ed-3241-b670-830a047d3f29"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"vertsElectron", "=", 
  RowBox[{"FeynmanRules", "[", 
   RowBox[{"LElectron", ",", 
    RowBox[{"ScreenOutput", "->", "False"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vertsPhoton", "=", 
   RowBox[{"FeynmanRules", "[", "LGauge", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"vertsQED", "=", 
  RowBox[{"FeynmanRules", "[", "FullLag", "]"}]}]}], "Input",
 CellChangeTimes->{{3.9736022988798676`*^9, 3.973602304893301*^9}, {
  3.9736025389126377`*^9, 3.973602552293741*^9}, {3.973602970521164*^9, 
  3.9736029753643208`*^9}, {3.9736030100006027`*^9, 3.9736030760907383`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"b15df37a-7f9d-9b4a-93ad-a3c241b7b11e"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.9736042535317383`*^9, 3.9736047279354076`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a3980c96-2558-f642-ad0b-2a82b829affb"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.9736042535317383`*^9, 3.973604727936407*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"e0eafb7b-6985-a344-aecd-6265a9fed6cd"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.9736042535317383`*^9, 3.973604727936407*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"00b5ec0c-5bda-bc45-870f-fd39cae14710"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{6.59765625, {0., 7.693359375}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9736042535317383`*^9, 3.973604727937414*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"76b7ea4b-23c0-cc4e-9c2a-444af3e76f63"],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{3.9736042535317383`*^9, 3.9736047280913143`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"6fee55f0-c0da-c440-9c7f-706934e95948"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        OverscriptBox["e", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}]}]}], 
   "}"}], "}"}]], "Output",
 CellChangeTimes->{3.9736042537357845`*^9, 3.9736047281142464`*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"2fc48fb1-580f-c04a-a2b6-49c965da966b"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.9736042535317383`*^9, 3.973604728122225*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"67de92c1-c858-ec4d-9d21-dbe341d88d54"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.9736042535317383`*^9, 3.973604728123228*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"b39ed512-ff3e-b04e-b144-e3c562457ee4"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.9736042535317383`*^9, 3.9736047281242085`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f009e715-d5c0-4e45-ad1c-980b7e858b67"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{3.9736042535317383`*^9, 3.973604728125223*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c6fc8b6f-b69f-584c-8135-2cecf6e2e555"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9736042535317383`*^9, 3.973604728125223*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"717a9e8a-c45a-e643-9eed-26eaa94d5f9c"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.9736042535317383`*^9, 3.973604728125223*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"688e9f50-04ed-4443-b6d6-679191079b19"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.9736042535317383`*^9, 3.9736047281262264`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"52e9eafc-028d-144a-bb0c-e6c1ee94294f"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.9736042535317383`*^9, 3.9736047281432133`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c89123aa-2829-9e4b-a85f-943f0efb83dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{6.59765625, {0., 7.693359375}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9736042535317383`*^9, 3.973604728144209*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a38a8c1d-4e2c-ba40-8436-83d16d18e942"],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{3.9736042535317383`*^9, 3.9736047283073483`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9b0598c3-7c7f-9f42-a62f-c32f5bd1dbab"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        OverscriptBox["e", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["e", "b1"]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       SubscriptBox["A", "\[Alpha]1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{"a1", ",", "b1"}]], "\[Alpha]1"},
       "Superscript"], " ", 
      RowBox[{
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"A", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], "}"}], ",", "3"}], "]"}], "**", 
       SubscriptBox["A", "\[Alpha]1"]}], " ", 
      RowBox[{
       SubscriptBox["e", "b1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{"e", ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "2"], "}"}], ",", "2"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["e", "\<\"-\"\>"], "a1"], "**", 
       RowBox[{"PRIVATE`crea", "[", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", 
         RowBox[{"{", 
          SubscriptBox["\<\"s\"\>", "1"], "}"}], ",", "1"}], "]"}]}]}]}]}], 
   "}"}], "}"}]], "Output",
 CellChangeTimes->{3.9736042537357845`*^9, 3.9736047283363476`*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"122842ba-8bf7-1a41-9bd1-abdd905a0e46"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteTeXOutput", "[", "vertsQED", "]"}]], "Input",
 CellChangeTimes->{{3.9736030842541294`*^9, 3.9736030896904163`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"fab766d8-d4cb-c84f-bcf1-5f68d84df60f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"TeX output written on \"\>", 
   "\[InvisibleSpace]", "\<\"QED.tex\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["TeX output written on ", "QED.tex", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9736042541001797`*^9, 3.9736047333142967`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"448fc8b4-6ab5-5a46-8700-9a4611c44fe0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComputeWidths", "[", "vertsQED", "]"}]], "Input",
 CellChangeTimes->{{3.9736042630752697`*^9, 3.9736042970816574`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"93da15f7-93e0-b54d-8ed8-99a3080a2062"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{6.59765625, {0., 7.693359375}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.973604270931223*^9, 3.9736042985155563`*^9}, 
   3.973604734172613*^9},
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"14748a72-26b5-7d47-9b60-33f3162b7205"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.973604270931223*^9, 3.9736042985155563`*^9}, 
   3.9736047341956196`*^9},
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"8960ad36-a41c-2a4f-8408-507509e6b569"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{6.59765625, {0.10546875, 7.763671875}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.973604270931223*^9, 3.9736042985155563`*^9}, 
   3.9736047341976204`*^9},
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"34e6b173-8dce-144c-8d09-3af1839289b8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{{3.9736042709332314`*^9, 3.97360429853961*^9}, 
   3.973604734198618*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"ddfe502a-0aee-d64d-8653-414b3178ef0e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "FullLag", "]"}]], "Input",
 CellChangeTimes->{{3.9736047356652184`*^9, 3.973604741899927*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"cae30d0a-cd99-7642-8e93-df400f366ab9"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{3.973604742107401*^9},
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"721e1c85-0c72-ad4d-bef8-167913d7f606"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{3.9736047421083984`*^9},
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"4dd11042-9d52-8346-8781-b8c4a82e8ff3"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.973604742141222*^9},
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"d8d38cc9-b3db-3a49-91e8-b4c7c0dc2b56"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.9736047421432285`*^9},
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"6dfcdca0-7beb-f149-a2e3-8dad6362e898"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.9736047421642056`*^9},
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"09d3dfcf-a1f2-c944-96f3-21e9817f1ae6"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{3.973604742165209*^9},
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"66813e60-f75c-1b4e-a180-80f72fbb65c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.973604742165209*^9},
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"cde200dd-5485-074c-a294-bb0478da4cb3"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{3.9736047421662045`*^9},
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"f33cbc5c-0168-e247-af5c-aef78c7b3878"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{3.9736047421662045`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"fa39c3f5-ceaf-804d-b68b-e3e021a2c9a4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "FullLag", "]"}]], "Input",
 CellChangeTimes->{{3.9736047529539433`*^9, 3.9736047827070885`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"a5e57f33-df29-404b-9ea8-8312192af198"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.973604768789156*^9, 3.97360478294483*^9}},
 CellLabel->
  "During evaluation of \
In[16]:=",ExpressionUUID->"5dd62e48-55a0-e648-9a2d-fa3301445a0b"],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{{3.973604768789156*^9, 3.9736047829458313`*^9}},
 CellLabel->
  "During evaluation of \
In[16]:=",ExpressionUUID->"30f7ce88-a58f-3c45-9737-2da163bf9013"],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->{{3.973604768789156*^9, 3.9736047829701233`*^9}},
 CellLabel->
  "During evaluation of \
In[16]:=",ExpressionUUID->"1a682066-6112-fd4d-891d-855ab61a2465"],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->{{3.973604768789156*^9, 3.973604782971121*^9}},
 CellLabel->
  "During evaluation of \
In[16]:=",ExpressionUUID->"ad49d252-9fcb-fc4a-a2a4-788065b50d5f"]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.9736047547485237`*^9, 3.973604782993288*^9}},
 CellLabel->
  "Out[16]//TableForm=",ExpressionUUID->"c43918c8-cc39-c741-a20e-\
cbbb6bf5447d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteFeynArtsOutput", "[", "FullLag", "]"}]], "Input",
 CellChangeTimes->{{3.973604858404726*^9, 3.9736048649775352`*^9}, {
  3.9736049006264477`*^9, 3.973604901889433*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"fa8c60d7-a1b8-af45-980f-4c9c452debee"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - - - FeynRules interface to FeynArts - - -\"\>"], "Print",
 CellChangeTimes->{3.973604902148739*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8f339c16-c822-5949-a8f7-a62ac4f151b6"],

Cell[BoxData["\<\"      C. Degrande C. Duhr, 2013\"\>"], "Print",
 CellChangeTimes->{3.973604902148739*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"34ed119b-4651-aa4e-9093-9bb214aee6d8"],

Cell[BoxData["\<\"      Counterterms: B. Fuks, 2012\"\>"], "Print",
 CellChangeTimes->{3.9736049021507607`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"aadfdcd9-a49f-f64c-822f-065946822bb2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Creating output directory: \"\>", 
   "\[InvisibleSpace]", "\<\"QED_FA\"\>"}],
  SequenceForm["Creating output directory: ", "QED_FA"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9736049021507607`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"30ecf34a-0ca7-894b-b247-5267c4f74939"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating Feynman rules for \"\>", 
   "\[InvisibleSpace]", "\<\"L1\"\>"}],
  SequenceForm["Calculating Feynman rules for ", "L1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.973604902151764*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8837650c-1ccd-ca4b-a36d-e5a5cd2de4ce"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rules calculation for L1.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.9736049021527596`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"34b0a267-5897-9b45-9d38-c2b40af3e951"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.9736049021527596`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8d31b8ad-19ca-d240-9a2c-a2177f5f9487"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.973604902167282*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8f42cc36-a80e-e643-8383-b1db65f25484"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{6.59765625, {0., 7.693359375}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.973604902168682*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"652c950e-aeac-674c-9488-fd283e174482"],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{3.973604902331066*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a82d896e-2d53-b444-bc19-adf9c0903128"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Global`a$", "shdw", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"a$\\\\\\\"\\\"}]\\) appears in \
multiple contexts \\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"\\\\\\\"Global`\\\\\
\\\"\\\", \\\",\\\", \\\"\\\\\\\"FeynRules`\\\\\\\"\\\"}], \\\"}\\\"}]\\); \
definitions in context \\!\\(\\*RowBox[{\\\"\\\\\\\"Global`\\\\\\\"\\\"}]\\) \
may shadow or be shadowed by other definitions.\"", 2, 17, 58, 
   17259147130221567992, "Local", "Global`a$"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.9736049024763336`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f875df1c-81cf-424a-a9e7-6777a00fbea1"],

Cell[CellGroupData[{

Cell[BoxData["\<\"mytimecheck,after LGC\"\>"], "Print",
 CellChangeTimes->{3.9736049025393314`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d062801a-340e-054a-9b40-4ae33c1c16f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Writing FeynArts model file into directory \"\>", 
   "\[InvisibleSpace]", "\<\"QED_FA\"\>"}],
  SequenceForm["Writing FeynArts model file into directory ", "QED_FA"],
  Editable->False]], "Print",
 CellChangeTimes->{3.973604902540329*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"9c615287-eb36-3742-8995-b45e6fed6510"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Writing FeynArts generic file on \"\>", 
   "\[InvisibleSpace]", "\<\"QED_FA.gen\"\>", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["Writing FeynArts generic file on ", "QED_FA.gen", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.97360490254233*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6f6ea25d-c9b9-6646-9fa1-72ffd0e69694"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.97360490254233*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b4fac9db-37f5-ec48-af95-9c8813054169"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025433292`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"951a397c-8c3f-8b43-bb83-f7891b8aebaa"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025433292`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"05f6f0f6-7df3-d340-92a0-bfc11f0bf730"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025443287`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"566860e9-620c-e644-b30b-de02e60b0045"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025453415`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"74473d4b-adcb-2c4e-8ee0-8a9b079f49af"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025453415`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"fb17053e-f051-0847-8d77-8c3fa51a4a30"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025463333`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e348400c-9be8-b140-a250-469672ddeb77"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025463333`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"241c955e-0c23-d344-b555-15ca7a1d2672"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025473347`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d0f12a6b-bcc3-6746-bc17-22c00f4bc194"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025483303`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"2b12cb14-7967-4243-a9f2-8fb8bf53cf26"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025483303`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"bce928b5-250c-6646-b1dc-4c9cafbd1c95"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025493317`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"818d7c10-ad78-ba4d-94e4-feb30790db46"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025493317`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a4aa327d-2379-8040-9ecc-f5244d05eb27"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025503483`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8e09b104-b42d-7a4f-9c40-41b2bf9767bc"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025513496`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"af12f06b-0f99-704a-85ac-6d7dd62721dc"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025513496`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4a7c098b-b5f8-8b4a-badf-c973ec9c6eb6"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902552349*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"bdb54263-941a-a440-9a5c-9820d764a2e2"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902552349*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"aa2ab119-cb61-f84a-bf1e-0d91b4769963"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025533466`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"9c7071cb-8217-4144-bd12-1b1ede36636a"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902554348*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e63b24e2-9227-0c4b-b49b-f870294a1f78"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902554348*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ee1fdab9-abbf-4e48-a030-92b72d73b10b"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025563526`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"474cdcc6-943f-c64c-aa53-51e37d09b5c1"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025563526`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f1e3fac3-340f-d949-8d52-78001c43bfe9"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902557358*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"55e11c97-3bc6-bb46-9f7e-e2e88036fb55"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025583496`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8b101dbd-8097-aa4d-8ba4-c61fb8cc08c7"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902559353*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"010744c2-732e-7540-8bef-952d26c608bb"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902560354*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8bff4b1b-9b94-a345-98dc-450f3958498f"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902561348*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c1c38424-a529-1c4b-807c-1bc7e12018c2"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902562351*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"afee26a9-c7ea-b34c-b88f-c3f15136a23d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025633507`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"76f19121-dbcb-ec4f-a3b6-7cb759064124"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025633507`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"fb9716ef-801c-be46-a189-be89a7a4e722"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902564867*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"293364a1-5c48-ca42-b9f2-7fdb415a4c00"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902565895*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"16b0600a-bb6d-a647-b880-60313f2f6687"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902565895*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f800bf68-563b-2f41-b199-a8fd3394067b"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902566889*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"9880b0a4-5c32-2c47-b448-a1921c193276"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902566889*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"130e97b0-a6a7-cc49-8a0d-ec36e12ec86e"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025678844`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"20abcc77-f0e7-ba46-af5d-0dc8dfd3e6c3"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902568886*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"36447c8f-f98a-f249-ba39-ad351a7c18ef"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902568886*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5febde11-7ebb-8140-835a-0fd44a79c7ee"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902569893*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"fe8e655b-8451-7d43-b830-b0aa7d79dff6"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902569893*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d8495231-2f1d-ef49-89c6-cbe9ead3adea"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025709095`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"94ceb256-f6ee-4245-9f03-3461b2e03e37"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025709095`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"776a7bc0-2dcd-5c46-8db4-ac3e35be0b4e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902571907*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"68c5af62-d372-6442-ac96-066a92b36721"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902571907*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"448de6e0-a124-324a-b0fe-a97d3a7231e1"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025729027`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"20e14f90-ef72-a14b-9e1d-6b8908e9fac4"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902573902*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"453b2eaa-9e30-2643-90e7-85433699f8cf"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902573902*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"19e4325c-4088-fa4b-8451-7365bc95b898"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025749035`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"be082952-b12c-5349-9925-99c9e52af2fd"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902575905*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1994bfae-2ad6-6648-95f7-2282f79a7b07"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902575905*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"37e0a00a-868b-a140-b6f9-1c590ddea276"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902576906*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1f395944-17c6-254f-a6b6-b2957e4ace1c"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902576906*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b9808f30-9ab1-ff43-9f50-2fb09c61427b"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902577902*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8533b95c-c74c-064d-9eef-e23f5e6b10bd"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902578886*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5ce56cb3-bed2-f545-9805-c5f2d20840fb"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902578886*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3893a505-327b-4446-897f-eb2e06e8f9aa"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025799046`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"582651aa-9c0c-2248-a327-ac366328a358"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902580904*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"aa3447df-86a1-b140-89c1-735005f8ab66"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902580904*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"11a16906-6fa4-a44c-83f4-ed122b7cb50c"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025818844`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1c7b996b-3b81-294a-9c0c-52f0a77cafc8"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025818844`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"87f6efb4-df2b-fd4b-aa38-85b0e3318843"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025828857`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4ce6375e-a8f2-4c4e-a7ad-42bf25f4e3b4"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025828857`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"9f2345e1-5dac-2b4f-a89a-70cec99c8942"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902583887*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1caaa453-2b5e-2747-b406-2c996b4100e5"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902583887*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0fb8434a-5fd7-0c44-9886-d01b780a6678"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025848866`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b2c0cd50-5b44-5e45-86e6-424dad7a08ea"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902585888*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e80a9bc7-884a-0c41-98d0-4e5f0ed91e50"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902585888*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a428ed13-825a-2045-b565-6c9363e38343"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025868874`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b654b88b-8f66-fa44-846f-0147b27ddacc"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025868874`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"117d0f3f-fef3-0049-b90f-91d6abf4de69"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025878887`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5161a2b0-ddd7-f449-9431-0e2c14f758a7"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025878887`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"dbe052f3-eee8-cb41-a8ee-e5f26ee6e460"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902588888*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6efcaefe-fbc3-a549-9ae5-8a5f8fe34b2f"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025898952`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a4056ee3-9bf4-eb48-8ce9-64146e617ff2"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025898952`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ea252aef-e633-934f-bf9e-b9e4970f342c"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025908947`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d7ef1960-2b09-e34c-bf89-823bebeb4268"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025908947`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1fbbf054-72a1-7f40-a503-16c9d6a07260"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025918884`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b79f0232-99b4-f24b-aa7a-67610bc77543"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025918884`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6b17e117-0701-8849-959c-92a07c4f5421"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902592884*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"20bba717-f82f-234a-b74b-18fc8e4e77b5"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025938854`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"24b6f2aa-18d9-bb44-8c69-895ce3230a6c"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025938854`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"85a5613a-bf56-9f43-b739-b5cf2c578aff"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902594885*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"283ea457-9df6-db4d-8274-c7a548559ae3"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902595894*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"847a51a1-2534-dd44-8d2e-7a9ca8b4600f"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902595894*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"28f20238-15a6-454c-8657-5e7c5cc3409b"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025968933`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4272107c-7feb-614e-852e-3c482afc53aa"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025968933`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"18b00cc0-39a8-014a-a366-beb5675de193"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902597906*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a4557512-8a2a-f445-a0f4-fb06e8fcac5b"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049025989037`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1e4ffe7b-9877-bc4c-b51e-0c8a7a525965"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049025989037`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6cf70ded-6188-bb48-9849-506d41c0a38c"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902599903*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"fc007bd4-0128-084a-96a5-d87e0ca2f944"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026008873`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"61a4f3d0-4c95-204f-a28c-e893e528460a"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026008873`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"35d6d05e-d0d5-c646-bd63-75def190384e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902601902*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"652d10e8-401c-234c-8eeb-15d298ed9f9a"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902601902*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"09d69c2e-bc46-0041-9981-6674d63f1ae3"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026049004`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"19c9c441-b4f7-2743-9482-9a8b8ade49e1"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026059017`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d13d839b-b8d0-394f-bedc-ad46466022cc"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902606903*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"9f51f731-eb76-fc41-892c-b415f7777a12"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902606903*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0a68a7c0-39d6-8241-b44d-6a673403d318"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026079025`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"549f2502-0ab0-934c-b98b-4e91c5733bf0"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026079025`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8a64df04-1342-ed49-89e1-c76cec68964b"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902608879*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e45b3f58-2ace-0945-98cf-ce0e9c7461cd"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026099033`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c46ed651-ef91-ec42-9d99-030d2cc6fa60"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026099033`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"11e756ee-4577-e04c-8a11-8eee6745ef39"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902610903*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d0486e09-c191-b54b-9b69-ed62efcbfa28"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902610903*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"dfb5ad6d-1c66-a847-af90-d156c9c6aa68"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902611902*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"fa142299-6f51-7b46-b95d-39b576c73bad"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026129017`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ad56cd8c-319f-1446-bbe9-9cabff9ee61e"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026129017`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1ae9f5d1-86dc-c14c-bff2-e5727fe5f3a4"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902613903*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e60388b9-3908-e047-941f-be6986d14237"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902613903*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6272cae8-2ad0-5844-b2a1-8e55ecbd7221"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026148987`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6e647ff3-0bf6-2745-a6f8-c9d71f321946"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026148987`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"568d8aa8-a61d-db4d-9046-338a16fa6141"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902615902*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"edfaa767-8407-0742-89d3-c90e7898b431"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902615902*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f20b708a-d9f6-db44-b9d0-b484e0757e93"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026169033`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ec386c58-34b5-5a42-b34b-b0712814d735"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026179028`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e95aedbb-afd7-4b4a-a749-ef938a2cb124"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026179028`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a0f04f5b-0883-534b-8745-7543124649b1"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902618887*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"16a24df5-e4ae-a14f-b647-1ecfdf1ac435"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902618887*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"dc4ee1ab-b3aa-ab42-8248-e229c45f27d4"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902619892*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"eaa4d9c7-8259-5d45-aa71-fd4b15d91f48"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902620905*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"91c53cd7-dbd3-6241-a119-a114210c39a8"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902620905*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"aee2c2c8-879c-a943-9a11-065aaa30c4a2"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026219025`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3ee58789-8180-ea49-bf71-89a957151f56"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026219025`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"7acb717b-ef27-e344-9bf0-b961fea33f27"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902622919*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"59426181-eb38-bf46-a647-797cffdb7032"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902623913*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"7b0321a1-570b-ad46-abd8-6451b393ad4d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902624918*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8c922dbf-1a91-ea40-83a4-4c9081bb8af4"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902624918*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"364e014f-85de-f845-aa7a-7e01d60ec456"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026259117`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"da4797de-1fe3-4e41-b9df-42adc7946b7d"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026259117`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"31cca2aa-d58b-304a-8775-bab2769b2876"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026269207`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5de9828e-1a22-c84a-b372-995befb3120b"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026279182`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"35d699d9-d72a-694b-8da9-ecf6f27f7eae"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026279182`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d592bb9b-a5ac-a94f-9f49-2944e8472e18"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902628891*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"9aa75a05-562b-a343-9cda-90ff5472fc11"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902628891*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"22def0b4-9c6e-4946-ad03-8391ddcf7a74"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902629923*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3f0a2afd-a1ed-5a4a-9e44-c8c72f6abff3"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902630907*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"476bce57-0476-1349-a7dd-e9fdbc83893b"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902630907*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"63ac4901-288f-1c48-8eb4-29c795285045"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026318874`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"55e8cea3-ce60-0142-82d1-bbdcbfac323e"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026318874`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f220c5be-a7ff-374c-9019-faa7b4eceb5c"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902632906*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"21c01988-f45b-314c-b4a0-da870a745889"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026339035`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f53c05c8-3f4a-c647-97d2-ec4f306b8ff1"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026339035`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6d40bebb-e3f0-9346-ab54-06d49d56b537"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902634884*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ea773232-0080-9941-9a85-17d780f8e80d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902634884*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a6fe568f-0fac-964a-a193-426b0fe077be"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902635895*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f34c1877-8506-1a45-ae79-d584cf0f7be6"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902636919*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"986f789f-b588-d141-8f62-6405c9d362d6"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902636919*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"64374aff-1a04-af4d-93fa-01b5c9a66e9a"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902637888*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e3a54635-a51a-4343-aa9f-d140a0201a84"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026388855`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4e1fbbd9-3971-1445-adbf-d2b1e0c9c5c9"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026388855`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d4f87efb-2a83-1a44-a754-1cc5f680cc94"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902639889*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"210f421b-40a9-ab40-8640-8a4dbed3bff5"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.97360490264089*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"930d4a24-fa18-5546-a206-d7633cdecb4b"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.97360490264089*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"20da0257-5028-704f-8375-0688867311e8"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902641918*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4a81caf0-b3e1-0849-b2d8-9e3a7885d877"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902642908*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"07c395d7-5285-e74a-a7e2-6b3e263397ab"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902642908*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"fe34fad8-7fcb-824c-b493-7fbb81cab458"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026438847`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"146edcd0-9ab8-f243-bf51-bf0e9991c3c9"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902644884*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4d09ffd8-b07a-8945-9f5f-189ec469cfeb"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902644884*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3a606d5d-0d2b-fb42-9fb1-d8d47ead352e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026459026`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4b7dcb46-4b6b-cd4b-be66-b16ce20b9dae"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026459026`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b0938b89-78c5-5942-996c-6084b6820889"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902646902*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d090fc1b-7a1e-ba4d-9fd9-5f26be3d9745"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902647909*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"15f8e599-a63c-3545-80ab-88bdadfba1c1"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902647909*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"7bb198ec-7b3c-ee48-a02f-73350cee5b0d"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.97360490264892*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1463eb6f-42a2-be44-9604-b190d8a0c399"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026499023`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"91074f11-87b4-364e-aacf-926f8aaa428d"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026499023`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ac38b41e-1fcf-f84e-90e7-b17ae05474dd"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.97360490265094*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a8a69325-0da0-5444-a16d-f47ac474def0"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.97360490265094*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"9eda5ddf-e3f1-eb49-a65e-fa763cdbb1f8"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026519413`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"7f9d1ef3-4c3b-6e4c-848f-5263d0bcbab3"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026519413`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0461b527-d110-714e-babd-be7fc1c2a0be"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902652939*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"390bd92f-de04-9b46-b1b5-3dede350af83"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902653942*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"79fb19c0-c2de-c046-9a5a-f27435334cab"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902653942*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c3f9825c-f946-7c4e-8e79-3306cd9c620b"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026549397`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d640b857-b07d-0340-b5e7-6729312bee62"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902655937*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3bcc5b62-16de-dd42-a3ab-8ec3ba3df639"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902655937*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"037ebe3e-93ce-544e-a5a8-7f6a1e40298f"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026569386`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"dda4c25f-320e-994b-9a09-406c730ca2ee"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026569386`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b1d18180-e3e6-e046-9526-4383da403011"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.97360490265794*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6627345a-be7b-7d42-9c79-d9499f4b9fdc"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026589394`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ebed2611-0ae6-c74e-b373-5041b5c0dae3"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902659916*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1a53abfb-0e1a-4449-a88f-04579293a133"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902659916*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"723a2610-f138-4945-a7cb-6b6339ae4d8d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902660927*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d77dfddd-2b14-0d4c-ae07-d42a1e423f2d"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902660927*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4472ac7d-f9d5-444e-874b-2583fa9b7b87"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026619244`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"582a7154-065d-dc47-8a7a-f2c951dfe397"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026619244`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d98b29d1-880d-ba48-a3d5-b880a075a348"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902662924*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e50659c4-e7d9-4740-a7b3-a0d0af39e00f"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902663925*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"04073f13-2dc4-f147-bcb0-3e108acbeefb"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902663925*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"eb1c93ac-7979-9543-acc4-a103ab06f727"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902663925*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4c8f657d-3c23-104e-8d84-2115cd435c0d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026654415`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"66494fc1-5a29-574f-95f9-fc7723bf50c0"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026654415`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"281ff91e-f9cd-2446-b420-80f3cbe18fa4"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026664658`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"eccdbb1e-2aa5-dd45-8ac3-542ad8f84352"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902667465*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"77dc912c-870d-0140-b269-779e6c7f3db3"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902667465*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"bf3babe3-3ddb-934c-993a-71ce9f95ed5a"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026684647`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3eb53d20-bef9-ef47-a2c2-6da1053ed25b"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902669466*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"78e70cdf-03cd-4d4d-836f-af04fc1968cb"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902669466*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"15bf3ee6-135d-154b-9abb-1b3092440a74"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026704655`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c8f4f002-6832-2d41-90d0-e377f5bcbb46"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902671465*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5f6228fc-6605-3344-9d73-2a1a87a60837"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902671465*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"434d4f13-8135-cb49-b289-fb748d089b8d"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026724663`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"61c9e518-f0ba-0e46-8465-2bcd4697286a"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026734657`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"19bc22b9-cceb-3b41-87ed-96f10b427860"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026734657`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b495fdaf-978f-5a4c-90f4-f2f5dea4098e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902674467*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c6bb6b14-e0f0-5a42-8615-5acf1a63fc9e"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902674467*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8a3a8817-3a2f-ad48-ad6e-3682ac88afc6"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026754665`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a8feb84f-2796-904e-80ba-5ddbd3f66a51"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026765175`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c363727c-a859-764d-a91a-4901cc4c94be"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026765175`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"7a937aaa-f94f-0445-898c-2c3416523ae0"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026775208`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"acb2de20-7982-004a-96a8-ecd1065911fe"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902678507*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0506e947-a8ef-924c-a6e3-b6361297c784"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902678507*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f9c98893-0fed-794c-a11d-f39f73663f3f"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026795197`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a2363f93-183f-0e42-bbb4-b5d688d26dce"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026795197`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4d3c2dce-5661-eb44-96a6-41ffad900427"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902680519*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"42cda035-e744-244d-8fe9-e8d57166b13f"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902680519*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"92ef3bbc-ac7d-e449-b5a1-c3435bb898ae"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026815147`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"600cd014-80ad-a349-b8e2-7fe6fc971a51"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902682583*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d5c3c4a9-7fa5-fb48-bb0d-f9642678473e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902682583*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f9c84573-69d4-2347-9c35-28825ce0e874"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026835747`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f82c6dee-a24a-6641-8097-609d5f97cc30"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902684557*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"603bd344-c391-2c4d-b178-75bff7f149e3"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902684557*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"12a10d6e-f05f-6248-964a-2037e9738e1e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026855583`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6b3d68ff-8eb9-1c4d-a954-8157808eddfd"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902686487*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a37ab36b-ceda-d049-bbba-9aa21a014499"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902686487*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c65e1be0-852e-b74b-99b9-00495876b5f4"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902687496*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"75d8047a-20e4-a14a-b8a0-b2e90f97fffd"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.97360490268849*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"bde3a1ec-71d3-c74e-abe6-04e16d201837"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.97360490268849*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8663a46a-07ba-7c43-a4a8-2fa4c6ca156b"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026894913`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"9f143447-d1cc-f24c-bc4f-4b0886975dbc"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026904716`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b22f9033-2f4e-1e43-9a56-15936e8df634"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026904716`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"9efc4a40-7dc2-ec40-b1cf-e6260ee3559a"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902691471*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"25ced738-2158-ff49-885d-569ebdfeb978"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902692461*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d9615ba9-db7f-d246-8c87-246b0e85d1ec"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902692461*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"62d06363-f0f0-0249-92ff-8eb269d2d842"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026934624`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6bc848d4-4f36-224e-a986-412e91736e8c"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026934624`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b86f171b-979f-c246-9078-2ae7c19c380d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902694462*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"efa8d52c-08f2-bc4f-a3a1-6ea5cc6b856e"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902694462*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"47099bf4-8bfb-c045-b767-2b18fd303f34"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026954594`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8e1d50f9-3641-594c-b4d4-babe2cd489c5"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902696472*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6090da84-8963-a242-ba0b-a2e45dbb3dca"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902696472*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"52e00ace-f1cd-e64b-82de-85da83aee391"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902697464*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"900bced6-ce16-0448-9da5-77f3b25e9efb"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049026984653`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a005a061-b98f-3b47-97fa-bd5d64572707"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049026984653`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a64451cc-d6b9-f24b-ac32-57ec47768284"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902699465*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ebfc37e2-ece6-f64a-b207-2c0549a63521"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027004604`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a46dff40-d68e-5f4c-bc29-b604526f7058"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027004604`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a7eb8397-3d4d-ad4a-8581-0309432ab96b"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027014637`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"10cc6d50-b84f-2e4d-bc03-31432df895dd"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902702469*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0d976be3-352a-8c4f-b182-9e915a6df369"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027034645`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8c3b62f8-1dd3-8c41-87b0-785f894f7bde"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027034645`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6da48cd9-dae9-8d4c-993c-5ef315853163"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902704466*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3c792239-a397-6b43-b7a7-220b500f4248"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027054615`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"496ae409-838a-0643-8162-cf61ce4c3a72"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027054615`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0193e05e-4edb-5940-8273-e0c31ffcf0dd"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902706463*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6aaae9ab-d91a-1e4f-bb16-d1d6f53264c1"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902706463*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"75bd458d-f6bb-5e47-b24d-eea33801c2c0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027074623`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a7d0ec02-bf34-1046-b989-330bce6140fe"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027084618`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a429ec2e-c868-1c4c-8aab-89131a7fc2da"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027084618`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"63c80ba9-cd45-8e43-8104-8de02ab1ceb5"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027094574`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"30689c94-c594-0741-904e-9dc3021b3474"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027094574`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f7bc2896-c402-bc40-bbca-16cd053eb08f"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027104588`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"90ff6a35-6c83-a24d-b70b-cd3273fe31d0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902711464*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5e14eeea-aac3-fb4d-80b6-1146a5816887"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027134876`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"2f1356eb-aca3-ff4b-8e28-268aef638486"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027144814`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"34b71ffb-b849-b943-baf4-3414381e1b87"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027144814`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"73424537-15f0-2746-bdf1-dee53def4cba"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027154713`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"68441112-79e3-8446-b0bd-92cc80f69a72"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027164936`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1559fc6b-ec30-6044-ac9b-0dceeff71a40"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027174854`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"38aafe61-f359-b541-8d7e-1081de481cae"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027174854`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8220faa6-c3d9-fe4e-baf2-cb961f49524f"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902718479*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6d776577-877b-ee49-b9f4-f3d2cb1b8869"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902718479*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b95cc93e-a70d-ab46-92f7-fe750d91845c"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027194824`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1bcacfb1-720b-df46-83ee-234606355c87"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.97360490272048*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6ef00847-5a66-7347-9396-b3ef43957e62"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.97360490272048*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"7a624fb6-7202-974b-8fcd-bc6462384199"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027214775`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4bf127fb-9533-5045-b5ec-a829b1725745"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027224617`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"2985256c-cc8d-2c46-9385-b1fcd5060e03"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027224617`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e451a78b-2d20-f343-80d7-f246719a5f55"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027234936`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0217ee0d-167b-7444-92c9-444871759dd3"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027244873`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"9d40f566-bc51-bb41-bc67-ee301b39d541"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027244873`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"cfc51660-4a89-e749-b274-46f4f08fe58d"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027254715`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"eadda56e-8b4a-7a45-863b-e606720ea41c"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027254715`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"78de110e-d895-4e47-8ad3-341498285472"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027264786`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"2dae66e5-d1d0-904a-ac29-c87649587753"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902727478*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"498f3c75-8e6a-0e40-9bfa-5e06b5784ffe"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902727478*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0cf7d285-7288-fd40-9925-baa0e61ef304"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027284775`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5b054cdc-455c-7e40-9906-6218a4973bb4"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027284775`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d77e9770-c3e2-af4a-95b5-f34ebc8b3707"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902729479*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ac7d0344-8160-8246-ada3-4e272cc2238d"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027304764`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4d91cb5c-2da5-9b48-acb7-95c00ee0dba0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027304764`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"123b95a3-9dae-6a43-946d-fef6ea57c396"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902731472*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c214a39b-5e87-4b47-a5f2-2df26f2c727d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902732479*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"121fc0e9-e7e0-8d48-a37c-620929a974d2"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902732479*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"7df0c7c4-0bbd-3741-be9c-9d14a4e2a207"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902734482*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"2a8bcdd2-60c4-a84e-ae4d-c207d33b9901"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027354736`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"93a3d009-adce-4c41-96fb-f6de7bcb75a0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027364807`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e818bed2-59f2-0a47-bd48-bb99af540898"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027374783`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"58c90b01-8615-ad43-86c6-534a7abe02c0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027384815`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c1dbfd40-0269-a349-b79d-e37e95271c93"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027384815`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"63d9f6fc-35ba-6648-802d-a78ba67ae1bd"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902739481*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f9ed29da-d9d2-534e-80f1-a2f7429c6632"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902740484*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c29399b1-6388-e142-aedd-9d85f9bc2861"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027414627`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"aa9b57ab-eee6-8244-84f1-2f66a87b7370"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027414627`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"01e3964e-8d6d-f349-a4f3-35f737ffe7e9"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902742464*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6c03cb78-df6c-174a-bb28-fb708e5eed77"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902742464*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c617a7b9-c367-0d45-a544-a05884171b5d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902743479*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"32a1b578-024a-5749-a666-108887044597"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902744463*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"438a1d32-0cbc-1e48-8bdc-7af79d33e7c9"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027454605`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4ccc04e2-925b-8543-a1b6-c1eea04c2f62"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027454605`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4e6090db-b0ef-614e-9a71-f92481b997bc"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027464695`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a6c9213a-f2c2-8249-9d0c-32b5ae8d8086"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902747465*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5d7f17f4-743f-d843-9fbc-31f252a60af5"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902747465*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"df2f1df6-710f-6a48-ba7c-5b0c1180d20f"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027484646`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a219f0dc-3cf5-db4f-b5ea-1bbce8646d62"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902749483*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"19d9b17a-05ce-744e-8a4a-3e0055e13c20"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902749483*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c3186fb4-6ee2-4643-89b0-7f4a0cf78744"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027504807`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3d2d0c4c-8d09-7b44-8fce-422ccdf80c06"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027504807`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ceb83572-74e5-564b-b959-c87075131d93"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027515144`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5ddc2f94-2463-9141-a4fd-07475986b5b7"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027515144`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b6f95af4-2bfc-ec43-8408-bdfecd9bfc34"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027525215`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"2d273c40-d57e-1849-bfcf-0512cdd8eb83"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902753517*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b6e5e070-cbb7-0149-91b6-a5bf12e8f4bf"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902753517*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a1c32d4f-7d87-0f44-8443-fde5cb7bff67"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027544994`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"15ec2de9-6cfc-d14c-a81b-2e0a80fa2ef2"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902755516*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3a05e36e-9225-0b4e-b6a8-9d14461f1e4f"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902755516*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ba4928a6-72c0-bb43-b7b7-a51163e6b677"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027565174`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a6affd35-0806-5843-9d5b-c1f96c9a07aa"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027565174`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"73ebe1cd-af31-8645-ba66-c91860d7dd58"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902757517*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"66d3ef9a-7a37-784b-821f-3920f4b80707"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027585163`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b3ba4fed-382d-994f-94ce-ec69da204209"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027595196`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"2199413c-a020-0148-9e05-8f0654e9ddc3"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027595196`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8e66d96b-ca5b-0043-baa6-29fb20639104"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027604923`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3c67106d-f000-194c-88e4-1eae56ef1963"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027614937`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"aa06c2f3-07e6-cf4e-8802-0c561485f87c"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027625237`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ca060280-fab6-ec44-9f20-1bdfa3675ee5"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027625237`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e75089b5-15d8-fa4a-b145-e7ba59c9e4ca"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027635174`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"60f7b1c5-d5cb-1547-ac30-90c62e3797e2"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902764517*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5becb7b2-ed9f-284e-afbd-ee3d77c2503f"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902765524*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"de08ba84-fea1-e448-9612-b82bfca3bd9c"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902766037*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c4fdd7b1-ce7d-9948-a02e-c75c2ea6b9a9"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902766037*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5ef46536-ce79-2842-90de-fa1582060087"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902767063*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"668ec835-21eb-a74f-ba56-7b667f82735a"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027680664`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b6f5e767-b53c-cc42-8f4c-a40596bb83d5"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027680664`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"282ddbd7-a23e-f64f-b4ad-e5941b4f4e10"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902769068*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"2db474a0-6182-b042-9f2a-dbc64489dbf1"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902769068*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5faed649-286d-c24d-9a3d-7318f9f19883"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902770073*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"7cce2566-9c75-cf45-aae3-5bfe02117fdc"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027710686`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"598dc362-09d9-d541-959e-ab9c14e1c067"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027710686`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"86595acd-a6bb-7d49-925b-72d4c9915312"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902772066*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4d141053-e960-9b48-a57a-6ab91ca3c38c"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027730675`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f22770b7-a746-9b43-94ed-1ea69bc8b79c"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027730675`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b4243af0-10c4-5143-862f-84590b892439"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902774067*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"786ee6fc-1ef7-3f4d-8173-4690fe65d88e"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027750683`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"7af8dafd-7144-5c47-8052-330988a9cae0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027760677`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0400620d-5966-a747-bde2-8c6b8ef69206"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027760677`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"79dc93b6-0bb9-524e-8e4b-e273f170c8b6"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027770653`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"05cd7a6b-b1b0-c041-82d0-278240cdee2d"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027770653`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0f927fb2-d415-1e47-b51c-b24339643613"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027780666`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"086955e5-3c8c-8842-8f62-eaa3aced5041"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902779051*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"310a4a4b-eb5f-8e40-846d-099a1ca861b4"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902780052*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"510a9fb6-0ac1-1547-baba-3eb352a23bc8"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902780052*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"01819f4c-e5e3-364c-99fc-7ae2a7c21d38"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027810535`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d826d495-2c46-1e40-9944-ed62ff2ef5a3"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027810535`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"75b5621f-48f8-fe46-b743-1c5d7ccb2edf"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027820663`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6df6d79a-df33-324e-80c4-79b545bcc7a9"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902783043*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d6908a33-3e5a-ea45-9e5f-22c81cad8c86"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902784071*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c7c96961-d9b0-914d-b5a3-e6fb52bb6ba5"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902784071*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"29dc7061-e6e9-b040-90d2-01d499fe0a0d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027850857`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"39f560dd-8244-ec48-a847-df4e82394abb"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027860775`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b1348b61-ca07-e043-937e-97bded2b253d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027860775`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"46a63286-8ca0-fd45-9c16-71ddbae1e972"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902787075*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"425f4a24-f022-cc42-ae34-969b0610a40e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027880726`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0ca4e8b2-e03c-6d4d-a948-69d22c8800d7"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027880726`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ebf705f1-97a1-734b-a1d9-919293913757"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902789074*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b6c54609-00ea-ac4f-b2c1-926cec76d39e"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902789074*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b48b2ab3-5a3f-f34a-884d-a2cd835b8d6b"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027900715`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"086a4b46-e71e-6442-9b5b-756b14561d6a"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027910633`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"028aa328-b6d5-6640-8a04-1bc908df5931"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027910633`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6b43c85d-5ddc-ef4d-8284-315818057d52"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027920704`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"83459ab6-5821-c448-b174-bea7f59a37c7"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.97360490279307*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"79758ce2-d7f7-214d-acf2-2ceefdbd105f"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049027940693`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8d7ab3eb-2007-ed42-ba3d-e1f7f63f775f"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027940693`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"042302f4-62e9-f44c-8a26-a7b5514b9c77"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902795065*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"2773920c-d6bc-7e42-8f27-e42ad6a429a5"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902796068*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"59381b05-6374-eb4f-a759-0e28a2713235"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902796068*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0e7d0954-4739-8d4d-ba6d-f8e7fa5744c4"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049027970753`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a18dbaa5-8daa-3840-9372-941066acad29"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902798073*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b3baf90d-a823-a74c-8dbe-1f6e9861509f"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902798073*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ceb1abe1-9a14-d847-a09b-8947ec252567"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902799055*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6dfb7568-516a-5741-a5cc-93c7cbcb8fdf"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028000584`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"026351c8-03e1-634b-ba98-25065805a967"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028000584`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"9b65add2-a5eb-8748-9662-dec868d00711"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902801071*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"41e65556-0111-8341-b488-4859f648f149"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028020706`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"9bd8cb42-0c70-b14c-917b-13a73ba480de"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028030624`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4fa9d199-7898-934f-a783-c2c9521a38a4"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028030624`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"dad2e85b-cf82-2d4f-8448-f5c6ad0dbf56"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902804077*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b67d399c-a656-6642-b915-800919a712d5"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902805071*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"699fe89c-e435-a24c-9562-699bbe3124cc"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902805071*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"481ac589-40ba-6549-8aac-e39c89ca2d2c"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028060684`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f08edf7a-6961-4747-8768-3c65596c320f"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902807068*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a1598043-4a89-014b-aa5d-bc12c9090a3d"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902807068*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ead34a8a-5849-c345-a00d-4fde69e2989e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902808069*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c1442b02-a4ba-434a-b320-59da4363f66b"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902808069*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e076741b-6b67-a649-9e4f-bdcdfc6204bc"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902809063*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c355a17f-c972-674e-a09e-256ed6598b3b"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902810068*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a2f89f60-ba91-2848-90ff-97d0bbe464c0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028110695`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"03d350da-c4c6-1648-a800-e7cbfc4031b2"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028110695`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"2e0b026d-706e-6143-9f3f-4e9f175f389f"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902812069*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c55ddd33-1784-4a41-b2fb-8535de3823f7"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028130474`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"17c53f2a-4907-c040-b899-2d0d54683eb9"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028130474`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c07bc799-993a-3b4e-95cb-6ba2b14ce587"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028140526`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"31b33ad7-7250-2144-ae1c-f80a629b9c95"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902815052*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"fd972e1a-807f-1241-b59e-755b45309d44"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902815052*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"422fe2e2-818a-e14c-bbdb-439f01f06360"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028160553`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"eef1943f-2553-c74b-b4cf-b9341aeb97f4"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902817053*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ee3f614d-0103-3e45-b6e5-6a7a34a2dece"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028180523`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"2b2440de-aff1-f044-972b-bfcd375e11e0"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028180523`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"11f012de-400e-9442-82bf-dcdcbb8cddfc"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028190536`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"720b9fdd-4b73-6341-8fe0-ec7f3a241725"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028190536`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3c15f136-bba3-d947-841e-620ac7593452"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028200493`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a63fdd91-7c52-c74b-b08b-a8aa492f34ce"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028210564`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"20a0d3a7-7a08-be46-be1c-8c6cebf88797"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902822052*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d1eed9a1-ce46-cc4a-9075-b65f7c8e731b"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902822052*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"53406ad8-b243-0c45-b663-f9718a3157e3"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028230495`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4f732d5b-d73e-1042-998c-82c2134c7a93"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028230495`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"edd46912-3429-fe41-b988-b927f44d350f"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902824051*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"68f20c32-c0d4-764f-9587-843de7d60919"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028250504`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1a40bd9c-9c44-8048-b837-bc0a7d5d949d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028250504`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1e250019-eafa-8541-8c24-ba4b50a39b94"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028260517`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3c895efb-e0c7-994d-a97b-476b08554f49"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902827053*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ff6d3199-a45f-e541-9965-fe65580bd881"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902828081*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b331ac8e-17a4-844f-813e-fc727d06b98a"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.97360490282905*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0a7207e7-be9b-ff47-a091-4da36434779b"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.97360490282905*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"055cb304-cd21-cb49-b5a9-d80c44746b0e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028300686`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e7e03a24-8760-da4f-89a2-325c1095e502"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902831068*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d101fe69-adf7-c645-a3c7-9a52fb62d928"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902831068*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"68a0a480-2774-9440-9b67-8802c0643a1d"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028320694`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e737a940-0bde-614c-a034-049b961210b9"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902833069*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"2db0b9d8-1f4d-e448-8bdf-50a9f2437099"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902833069*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"73bcf356-5774-bb43-b02f-8a847bb7986c"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028340683`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"dfb0687e-5421-8b44-b2eb-90f445a70bd4"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028350697`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"08575495-af7d-7648-9417-039f5f9456b7"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028350697`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"377f64fd-a4f2-6640-8abd-b000b90d0ffa"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902836071*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"32a22407-954a-4b40-bc07-136b30534dc1"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028370686`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"41cc12be-ab36-fa43-9ed9-ea44bd2917c2"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028370686`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"13c2242b-596d-3041-b0c4-eb3ff831c5f0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902838085*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"fd274538-d3b7-cb40-9403-09122c266a55"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902839079*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c395a0bd-c49f-164c-9ad3-f576aa54457a"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902839079*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e2b52632-3715-9648-ae8b-0a81b8e081e7"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028400707`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"da8890e8-cde8-a441-abc1-f4a619a9691b"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902841053*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"eb28b038-b073-934b-a0b1-06c6321dfbe2"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902841053*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"47b5c4f7-1cfa-0846-9c5c-08f35a4032bd"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028420696`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a3a7e577-80c7-654e-873c-de58521c3187"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902843071*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ea8353e4-8f1c-e34e-ad63-928644e44c66"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902843071*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d9513f22-6da6-e44f-92ef-40208413a958"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028440514`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"bea6cbbb-3782-764e-baa0-60fb1eeebbba"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902845047*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ca0a26b5-f461-724e-8c21-864a4dab52ea"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902845047*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ade3a192-ccd0-ae40-acc8-b4673ad64889"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902846075*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"81518efc-43ad-e742-a54e-b29c4e323c25"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028470726`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"aa8c95ff-08e3-f64b-bf7b-651fd6ccd5cd"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.97360490284807*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e5067cf5-fb46-334c-a7a3-aeec08fabfc7"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.97360490284807*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"7728c701-93ca-ad40-acd1-1c63fb2d1a52"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028490696`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b6a11aee-8767-204c-a59e-1246c1a8c9be"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902850071*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"da810acc-d924-3a4e-8a9f-2c64feb0022a"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902850071*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5175d5c7-5078-5b48-87d4-5dcce182185f"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902851095*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"2d34bfc4-c7c7-eb40-885c-cee4dc08b1bc"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028520947`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b83f8116-9c12-c144-ad22-54305402d1de"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028520947`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"19c923fb-289b-a64c-b0b9-50982a82bb58"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902853094*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"dc2f33dc-cc4a-7a46-9490-b6798ea1c4cc"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028540916`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c3329d11-d67a-4544-a173-665b475936ce"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902855093*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5bcdaaac-5eea-1848-bee4-0acaf4bdac54"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902855093*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"35ca6dfe-333d-234c-ab68-053cb048226e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028560925`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"86b853c6-dbdb-ca4a-be0a-fa19ee5fe30a"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902857092*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1990f630-d7e3-ee48-8347-88363b83323b"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028580933`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c91e23c8-b369-614b-bc57-9803132a8546"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902859091*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e22f1711-5602-8644-8e86-840fdda0a6e1"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028600883`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a1f8bb93-eecd-af43-a500-b1800587ae49"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028600883`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3782f0da-6219-0948-a34e-f9f88685231a"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028610916`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"7e8a28ea-d5c2-7e41-83ab-73fa71386d22"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902862095*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a5a31fd4-743b-f243-b25d-638bed17a289"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028630905`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"036346e3-e00f-6846-bb9b-29d312753986"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028630905`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f07c4520-b2ff-e24d-9d5e-d7cfc02b8f24"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.97360490286409*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a07af9ff-e712-1847-8057-0e06b5d09586"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.97360490286409*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6d91e6a4-1879-cc4f-ac99-55a69097ec78"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028656044`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1f20d445-4c81-3d4b-8f74-334689c27d16"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028656044`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"42fbf703-c0ca-3242-be0d-71d72c883391"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902866617*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ce229bfc-6320-e543-b837-2a5a77db558b"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028676243`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"db395d53-7452-2e40-9b59-39131adfcee5"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902868622*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6e901714-ed5e-f146-a059-0804fb03f604"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902869625*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f141e561-1ba9-3349-9f25-0aeddea5d6d8"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902869625*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e7881a04-7bf3-e942-9ea0-d2bd2be6870f"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028706245`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"02c1abbb-5f29-f64e-ad30-bbec1c3eaa8e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902871626*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0f8ec326-d6e2-6e40-a1aa-8e2334572bc0"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028726234`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"87065f07-f89f-9a4b-98c2-a2fca8f1717a"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028726234`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ba4379f0-6e40-7840-b7e6-8c0b4756bc4c"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902873625*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6314c7a0-a372-1447-9ad6-349071b6e0fd"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028746243`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c952b43a-d400-5b42-8af2-0dbddb92e09f"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028746243`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d9c61074-5f01-0741-8d3e-43aae5f14824"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028756275`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b665b8ea-b9c9-e149-8ef6-190f38bd4801"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902876625*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e90def26-41e4-fa46-a294-5bf02673da6b"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902876625*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"07a4c346-4957-1c44-adda-ffadf31111fb"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028776264`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8d6ab24f-e189-0344-acbf-fee5ef4725d0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028786182`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4f2c114c-742d-6046-b66f-69baedb80006"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028786182`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"95292581-abe7-d348-8b9f-8572fda1b699"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028796253`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3f58612e-d96c-cc48-95e9-44e9c775528e"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902880625*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"826c435f-10a1-4f4e-945d-20e000905405"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902881628*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8cec1a05-8d9d-f34b-a26c-2616184daf8c"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902881628*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"62a6fd4f-5539-0840-ae88-396cafae97d3"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028826294`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ee99d51e-0168-f144-b097-76bc477ea73c"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902883627*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a50823c2-2e41-b443-bc0e-2764759d53b0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028846264`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a38a66fd-24f1-e84e-821f-62818b8b5c3c"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028846264`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1254f354-9983-3f47-8cb5-867162c7ad40"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028856735`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c98c90c8-6f48-9042-9e19-e29b3c6f7fa4"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028866825`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0bce8b9d-d896-ff4e-bc6a-714f69732e26"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028866825`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b8d7a585-9cfc-3447-9ee0-100b7b72a38c"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902887682*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e3bffa4e-292b-2343-aa35-cb2ebe16145d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028887196`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"dc18027f-e286-604c-a63b-533b4899516b"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028896217`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d8339040-fd13-e64e-839c-7ea4b76c9d65"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028896217`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f1cbfafe-0df5-7345-a027-9337493f0b27"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.97360490289073*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6cbabbfc-d23b-894d-be76-1e1b18913e76"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028917255`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6e1e4b53-541e-2d4c-842e-ac0304687be3"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028917255`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5b8e52b8-5e5f-1649-97e4-4ab667758809"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028927193`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1a12a4fd-f83c-3c4a-bc10-39c41447783d"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049028937225`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a199ad55-ef57-8c41-aac3-c67044ba7df6"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902894724*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d687fa6e-f796-af44-9e3e-9c0fe1cf9b8d"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902895727*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ccde92a7-4d57-c641-a8c5-5c79c0ca9557"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902896744*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"16dfeb16-1c89-f145-8f6f-0be3dfdfcc2f"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902897724*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"9d8583d0-ba18-024f-a3c2-6877dcd4e504"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049028987217`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f6c178c3-26a7-4646-bf87-387e8320448d"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902899727*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"516c180b-0d7e-8f49-a7ad-543bc11b5fe3"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902900717*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c6e94a96-4c4b-b648-a137-109c390bf1db"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049029017277`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4c43cf4f-8b21-3b48-9915-c1a1c9b2b2f2"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049029017277`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1f45d244-9c5d-2a4d-bb37-5faf8657a2cf"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049029027596`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0e2ecf87-561a-0144-a9a6-53549fd4f8bf"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902903719*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"32a4ba3c-95a4-c542-87a3-6a1b5b784909"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902904722*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5ea0cc80-590e-2046-9cda-713c9d93daf7"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902904722*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8b86ed02-6024-b540-be2d-8250e4852b87"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902905718*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b9e6b72c-dfb4-cd41-a6db-8b2e519bc194"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902906727*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5da70cb5-1aba-7a43-8430-842e62240772"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902907625*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"390b4869-aa5a-0241-8944-42094cb18546"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902907625*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"592e000f-098b-4646-814b-d97f3e04de03"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049029086456`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"73f4a6a9-fe99-7e4c-b7e0-623d743f66e2"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902909649*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"816ab3ac-7eec-274b-a026-c2eb0ebce66a"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902909649*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"a0e891c7-a8ef-1d41-81f5-aefbf2cbe204"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049029106426`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"25d3aa09-f2fd-974f-a6b7-c53d3eeb6cff"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.97360490291164*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"e6e98792-19ab-f947-a5a4-e2ee4f17f57c"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.97360490291164*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f1e06684-ec21-e340-989f-985c8cac3204"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049029126415`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"6100fcef-d562-8844-90f9-8816d2b14ddd"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902913641*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b8457f67-d794-904e-8535-1cbeb08e2661"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902913641*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"0aedaa03-3522-d448-ad1f-189b5e5a5a4d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049029146404`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"28c8dc00-8bbb-2b47-a832-7c6d271834e1"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.97360490291564*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"11990f92-de61-8445-afa8-6efe43137842"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.97360490291564*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"03eb3d99-4f86-ed4c-b9ae-6bccbf8f6760"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902916641*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c98ea9df-f6ff-8a47-821c-e435d9ce9602"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049029176407`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"58567102-b07f-ee49-95a6-03ca18f15073"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049029176407`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"cbfdc418-c180-8540-92f2-a15726da0abf"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.97360490291864*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"5984b99f-15bd-0942-a41a-0713a08dda4d"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.97360490291864*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"03527b0d-3f3e-f84d-9b3c-0013cb396a89"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049029196396`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"718b4216-f945-c242-a16f-652fd7a16c1f"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902920643*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"62d63a7b-1879-ff46-a716-32c7daf2e905"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049029216423`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3e0c768f-dbaa-0247-8f41-94366daffb4c"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049029216423`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"2f19bb26-6319-054a-b755-ba923b929079"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049029226437`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1171e2f7-5b33-314f-9afd-239d51f40e5c"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049029226437`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d573a2c2-d0b4-db47-b513-a6ca6c52e5d2"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049029236393`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"04b53fbe-5d31-e34b-96c3-5f0ac6744f3a"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049029246616`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c984b85b-5685-9044-9290-371ced54ebf1"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049029256496`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"12256f83-d2c9-774b-ad50-860c9f65ff8f"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.9736049029256496`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"98fd5553-7c18-7d45-8abd-989cf0c94c66"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"A", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Lorentz", ",", 
          RowBox[{"Ext", "[", "3", "]"}]}], "]"}], "]"}], ",", "3"}], "]"}], ",", 
     RowBox[{"A", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902926647*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"b0d61138-0e99-124e-84b3-4b0ba6237fae"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902926647*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"ef466e1b-c0ed-df45-9698-1ff33724486d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"e", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "2", "]"}]}], "]"}], "]"}], ",", "2"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.9736049029276447`*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"c7bf4843-44c8-784a-86e4-fc7654c14535"],

Cell[BoxData["\<\"Warning : the following lorentz structure or part of the \
lorentz structure is not writen in the generic file\"\>"], "Print",
 CellChangeTimes->{3.973604902928631*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8a878769-1e6b-6e47-9bce-d8913ac7a7d8"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{
     RowBox[{"ebar", "[", 
      RowBox[{"Pattern", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Blank", "[", "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"PRIVATE`crea", "[", 
      RowBox[{"ebar", ",", 
       RowBox[{"List", "[", 
        RowBox[{"Index", "[", 
         RowBox[{"Spin", ",", 
          RowBox[{"Ext", "[", "1", "]"}]}], "]"}], "]"}], ",", "1"}], "]"}]}],
     "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Print",
 CellChangeTimes->{3.973604902928631*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8a413389-44f3-ba41-b6f3-2742fa7f49e7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"top2To2", "=", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"0", ",", 
     RowBox[{"2", "->", "2"}], ",", 
     RowBox[{"ExcludeTopologies", "->", 
      RowBox[{"{", "WFCorrections", "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"diags2To2", "=", 
  RowBox[{"InsertFields", "[", 
   RowBox[{"top2To2", ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"F", "[", "1", "]"}], ",", 
       RowBox[{"-", 
        RowBox[{"F", "[", "1", "]"}]}]}], "}"}], "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"F", "[", "1", "]"}], ",", 
       RowBox[{"-", 
        RowBox[{"F", "[", "1", "]"}]}]}], "}"}]}], ",", 
    RowBox[{"Model", "->", "\"\<QED_FA\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.9736051913053207`*^9, 3.9736052571182976`*^9}, {
   3.9736053060076847`*^9, 3.9736054119193497`*^9}, {3.973605467619316*^9, 
   3.973605488356268*^9}, 3.9736056303405895`*^9},
 CellLabel->"In[55]:=",ExpressionUUID->"728e42c4-a9da-ac4d-a4d1-275b0ef2eed5"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.973605413049198*^9, {3.973605468212988*^9, 3.9736054887216873`*^9}, 
   3.97360556511977*^9, {3.9736056045138283`*^9, 3.9736056398540745`*^9}},
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"85a03383-b52e-544e-96cf-94acdec3eaa0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
   "\[InvisibleSpace]", "\<\"classes\"\>", 
   "\[InvisibleSpace]", "\<\" model file \"\>", 
   "\[InvisibleSpace]", \
"\<\"C:\\\\Users\\\\lucas\\\\Documents\\\\UFABC\\\\Quadrimestres\\\\2025.2\\\\\
tqc1\\\\seminario\\\\FeynArts\\\\Models\\\\QED_FA.mod\"\>"}],
  SequenceForm[
  "", "loading ", "classes", " model file ", 
   "C:\\Users\\lucas\\Documents\\UFABC\\Quadrimestres\\2025.2\\tqc1\\\
seminario\\FeynArts\\Models\\QED_FA.mod"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973605413049198*^9, {3.973605468212988*^9, 3.9736054887216873`*^9}, 
   3.97360556511977*^9, {3.9736056045138283`*^9, 3.9736056398551044`*^9}},
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"13903dd8-07a1-c241-a39a-87246fd8db44"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "FeynArts`M$ClassesDescription", "undefinedmod", 
   "\"No or incomplete classes model loaded.\"", 2, 56, 82, 
   17259147130221567992, "Local", "FeynArts`M$ClassesDescription"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{
  3.9736054130992317`*^9, {3.973605468244007*^9, 3.973605488768215*^9}, 
   3.973605565121807*^9, {3.9736056045168495`*^9, 3.973605639856104*^9}},
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"f4e412e9-8dfa-1c43-9fae-12f31e2e0ced"],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{
  3.9736052239646854`*^9, 3.9736054131637726`*^9, {3.97360546824955*^9, 
   3.9736054887722187`*^9}, 3.973605565125786*^9, {3.973605604520836*^9, 
   3.973605639859083*^9}},
 CellLabel->"Out[56]=",ExpressionUUID->"591bad7e-772a-dd4d-af87-b52e66c22205"]
}, Open  ]]
},
WindowSize->{1141.2, 573.6},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"14.3 for Microsoft Windows (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"51865137-a14e-ed43-bc39-ec84cff21562"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[554, 20, 415, 7, 28, "Input",ExpressionUUID->"ac5cfdb8-898d-5c4c-af18-94f0d527cfb9"],
Cell[CellGroupData[{
Cell[994, 31, 681, 13, 47, "Input",ExpressionUUID->"972b9f63-3a45-a44e-9436-79c3777ec4f9"],
Cell[CellGroupData[{
Cell[1700, 48, 182, 4, 22, "Print",ExpressionUUID->"6b014403-b1bc-4747-a79f-f0afb6c3721e"],
Cell[1885, 54, 207, 4, 22, "Print",ExpressionUUID->"ca4d05d8-708c-ad45-a898-c1794d24abde"],
Cell[2095, 60, 227, 4, 22, "Print",ExpressionUUID->"af14c6d5-01f4-7f41-9f99-76a10335e13b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2371, 70, 513, 11, 47, "Input",ExpressionUUID->"075c974c-b192-b14a-ba66-e2709fb4161c"],
Cell[CellGroupData[{
Cell[2909, 85, 276, 6, 22, "Print",ExpressionUUID->"3ae00364-64de-0740-bddd-4220f9e198a7"],
Cell[3188, 93, 553, 12, 22, "Print",ExpressionUUID->"461bd41e-0961-2a4f-8c90-5131cfcf1003"],
Cell[3744, 107, 326, 7, 22, "Print",ExpressionUUID->"e8cc1f2e-96d7-d247-b5d5-c0a88ef1bd45"],
Cell[4073, 116, 260, 6, 22, "Print",ExpressionUUID->"3539ffc5-3c05-794f-b5b5-e09d5c114f1c"],
Cell[4336, 124, 271, 6, 22, "Print",ExpressionUUID->"34d6bde5-9464-194b-8984-5a92246d927b"],
Cell[4610, 132, 323, 7, 22, "Print",ExpressionUUID->"942463f7-a670-0246-8bee-6a5dc156912b"],
Cell[4936, 141, 323, 7, 22, "Print",ExpressionUUID->"c021ba75-4d94-5b47-aa27-32c37ab5f188"],
Cell[5262, 150, 262, 6, 22, "Print",ExpressionUUID->"fc8a7484-7fa3-ef43-91bf-2b75492a49ab"],
Cell[5527, 158, 292, 6, 22, "Print",ExpressionUUID->"66dff0ac-cf0c-6346-aa75-146d006dc5a0"],
Cell[5822, 166, 262, 6, 22, "Print",ExpressionUUID->"d60d92dc-a6ab-a749-aa88-320c718e6c19"],
Cell[6087, 174, 329, 7, 22, "Print",ExpressionUUID->"d15c31ff-443d-804f-8669-ef879bf8a13b"]
}, Open  ]],
Cell[6431, 184, 810, 18, 26, "Message",ExpressionUUID->"95ab091f-bd34-3c42-8ab1-6b7cffcd679e"],
Cell[7244, 204, 789, 17, 26, "Message",ExpressionUUID->"877b9536-6ec3-0a4a-82bc-3be1f84d4279"],
Cell[8036, 223, 792, 17, 26, "Message",ExpressionUUID->"8711a5e0-77a7-c748-bb82-7a1838f49b7d"],
Cell[8831, 242, 760, 17, 26, "Message",ExpressionUUID->"833f53d3-2008-704b-9fb3-6d77cdaa653a"],
Cell[9594, 261, 790, 17, 26, "Message",ExpressionUUID->"25d8cc1e-625f-3d4a-a37a-2638cd1d980d"],
Cell[10387, 280, 793, 17, 26, "Message",ExpressionUUID->"35b73843-bfaf-a24f-bd38-35512a9ffd6a"],
Cell[11183, 299, 793, 17, 26, "Message",ExpressionUUID->"788528b1-1399-2c44-9916-7659381be3ab"],
Cell[11979, 318, 792, 17, 26, "Message",ExpressionUUID->"b0a89713-764a-0846-b74f-f1dacfce9b06"],
Cell[12774, 337, 801, 17, 26, "Message",ExpressionUUID->"474a2ac0-24f7-f048-8c9c-ebe30291f866"],
Cell[13578, 356, 779, 17, 26, "Message",ExpressionUUID->"8bb4280d-709d-3545-a457-4e5e02b0233a"],
Cell[14360, 375, 754, 17, 26, "Message",ExpressionUUID->"2e41e521-04ed-a043-aa4c-a0519d0a51b0"],
Cell[15117, 394, 752, 17, 26, "Message",ExpressionUUID->"5ad9dc1b-6ae9-e448-8ee4-1ceb8365d8f3"],
Cell[15872, 413, 772, 17, 26, "Message",ExpressionUUID->"52e6fab8-4a9d-954b-ad6d-ef6d55812281"],
Cell[16647, 432, 775, 17, 26, "Message",ExpressionUUID->"68f67ed1-5b50-3b4a-98f1-e4e367d908fd"],
Cell[17425, 451, 781, 17, 26, "Message",ExpressionUUID->"b7d5deeb-77cc-a342-9352-b3d85f49c769"],
Cell[18209, 470, 778, 17, 26, "Message",ExpressionUUID->"25a9db29-f5b2-5048-8dd2-669efe14aa68"],
Cell[18990, 489, 760, 17, 26, "Message",ExpressionUUID->"44f91c81-ea5b-244b-8e28-2ac7a1545875"],
Cell[19753, 508, 754, 17, 26, "Message",ExpressionUUID->"7aa76c5a-5a7f-ce4e-92cb-cd969de89c48"],
Cell[20510, 527, 752, 17, 26, "Message",ExpressionUUID->"2cdbb681-5868-bd46-957c-f878bb126f53"],
Cell[21265, 546, 754, 17, 26, "Message",ExpressionUUID->"16d27ae4-7357-d342-8910-d2520c696647"],
Cell[22022, 565, 775, 17, 26, "Message",ExpressionUUID->"334ae3a0-0830-2c49-8118-0cb566c04dd8"],
Cell[22800, 584, 775, 17, 26, "Message",ExpressionUUID->"8d0b96e8-4cbc-af43-865d-652489d92bf8"],
Cell[23578, 603, 778, 17, 26, "Message",ExpressionUUID->"accb8009-9fac-f842-99b9-1c42c63ff3fa"],
Cell[24359, 622, 781, 17, 26, "Message",ExpressionUUID->"6a9553c3-1ab8-2347-a196-7abc9a3bd9f3"],
Cell[25143, 641, 781, 17, 26, "Message",ExpressionUUID->"de0f5fe1-136e-164a-9c7b-0cac82d3c6ed"],
Cell[25927, 660, 762, 17, 26, "Message",ExpressionUUID->"7e6292b0-48da-4240-8518-ed414979a284"],
Cell[26692, 679, 775, 17, 26, "Message",ExpressionUUID->"d8975a5c-a3ff-b846-960b-c9df067fd043"],
Cell[27470, 698, 772, 17, 26, "Message",ExpressionUUID->"d5d189db-e56d-9049-bec9-90965e6a373f"],
Cell[28245, 717, 793, 17, 26, "Message",ExpressionUUID->"25790802-c5f7-b242-917f-69d54248cdb9"],
Cell[29041, 736, 787, 17, 26, "Message",ExpressionUUID->"2b84a5b9-ca44-e246-a925-7caccfa76131"],
Cell[29831, 755, 755, 17, 26, "Message",ExpressionUUID->"4b7c10dd-b6f6-7c43-9019-dd3118fd438b"],
Cell[30589, 774, 779, 17, 26, "Message",ExpressionUUID->"c01081cd-c03a-de42-a213-3032f98da367"],
Cell[31371, 793, 775, 17, 26, "Message",ExpressionUUID->"d0b85543-1063-0947-aced-261b7995d9b5"],
Cell[32149, 812, 770, 17, 26, "Message",ExpressionUUID->"2b640d9f-4441-8e44-b9d5-478df30141f7"],
Cell[32922, 831, 773, 17, 26, "Message",ExpressionUUID->"48cb9491-4c5a-5741-9c9e-5765e2b467f0"],
Cell[33698, 850, 754, 17, 26, "Message",ExpressionUUID->"e1a3e8f0-d479-f344-aa15-4bb9e0b91917"],
Cell[34455, 869, 775, 17, 26, "Message",ExpressionUUID->"a6eeebe4-67a1-b240-bc27-f70c87a83230"],
Cell[35233, 888, 760, 17, 26, "Message",ExpressionUUID->"7ab4cf84-19c9-b344-bc9c-e8e88fb7217d"],
Cell[35996, 907, 776, 17, 26, "Message",ExpressionUUID->"23dec6a6-778d-e348-bd86-ce4972f38a5d"],
Cell[36775, 926, 769, 17, 26, "Message",ExpressionUUID->"d05419e1-d078-c043-b1e1-ddafd284c4c1"],
Cell[37547, 945, 779, 17, 26, "Message",ExpressionUUID->"25496c4a-3d52-2e4b-93d0-d0e974b7cfad"],
Cell[38329, 964, 663, 15, 26, "Message",ExpressionUUID->"e5293c4e-d68c-344f-a3e0-81473e1bf17d"],
Cell[38995, 981, 675, 15, 26, "Message",ExpressionUUID->"30c9597b-d9c4-0f44-bfd3-ca77e4ab8071"],
Cell[39673, 998, 568, 14, 26, "Message",ExpressionUUID->"4fc6d023-d20f-8b44-b553-c5847dd41522"],
Cell[40244, 1014, 545, 13, 26, "Message",ExpressionUUID->"610728c0-5825-7340-b8ce-886ecfb22136"],
Cell[40792, 1029, 603, 13, 37, "Message",ExpressionUUID->"11659b13-1bd0-284d-a28c-df6370f11864"],
Cell[41398, 1044, 605, 13, 37, "Message",ExpressionUUID->"2548b8c4-8084-004e-bdb1-bb260c0c87cf"],
Cell[42006, 1059, 603, 13, 37, "Message",ExpressionUUID->"64a57c39-612c-4149-8b14-928a00dedf32"],
Cell[42612, 1074, 603, 13, 37, "Message",ExpressionUUID->"427d000c-5b19-2441-b738-d2baba35e211"],
Cell[43218, 1089, 603, 13, 37, "Message",ExpressionUUID->"7380f0b0-10dc-0647-b7bb-5ec9820e7852"],
Cell[43824, 1104, 547, 13, 26, "Message",ExpressionUUID->"9dc7b312-317f-ce44-8d55-15a3348aab6c"],
Cell[44374, 1119, 485, 11, 36, "Message",ExpressionUUID->"22bd1f94-9961-f84a-b362-872dfbd6e60e"],
Cell[44862, 1132, 487, 11, 36, "Message",ExpressionUUID->"4f6752e2-a727-af48-b462-b449d0d85fb4"],
Cell[45352, 1145, 485, 11, 36, "Message",ExpressionUUID->"fa3c3bf2-feea-3f4b-806a-a5bc6bd4da87"],
Cell[45840, 1158, 485, 11, 36, "Message",ExpressionUUID->"75a37fea-40a8-3545-816f-dc319c4d12e2"],
Cell[46328, 1171, 485, 11, 36, "Message",ExpressionUUID->"d115802f-9372-3d48-bb2c-fcd17533a9ab"],
Cell[46816, 1184, 562, 14, 26, "Message",ExpressionUUID->"28db163f-fab3-ec43-a2d3-2d0335218958"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47415, 1203, 221, 3, 28, "Input",ExpressionUUID->"7cb380c0-1c2a-d842-91d1-f6e63d939fa1"],
Cell[CellGroupData[{
Cell[47661, 1210, 244, 4, 22, "Print",ExpressionUUID->"64252716-e6c0-8b46-83dc-ef5110f5f00f"],
Cell[47908, 1216, 212, 4, 22, "Print",ExpressionUUID->"3f907c28-1aad-0a40-aa7e-4d9de7d4e4ab"],
Cell[48123, 1222, 350, 8, 22, "Print",ExpressionUUID->"aa9c7dc7-f65c-1543-b2f9-591b058e7580"],
Cell[48476, 1232, 252, 5, 22, "Print",ExpressionUUID->"8b980ec3-2b4b-4049-906f-69871970cdfe"],
Cell[48731, 1239, 202, 4, 22, "Print",ExpressionUUID->"e9449411-9b1e-4f47-b000-cd552ede87cc"],
Cell[48936, 1245, 232, 4, 22, "Print",ExpressionUUID->"35c62669-4a31-2045-a2cd-6de921297b04"],
Cell[49171, 1251, 235, 4, 22, "Print",ExpressionUUID->"b78a572a-34e0-5644-b1b0-bf7b66218ec7"],
Cell[49409, 1257, 235, 4, 22, "Print",ExpressionUUID->"d1a93e13-28f4-df49-8820-98ef953745b4"],
Cell[49647, 1263, 392, 9, 39, "Print",ExpressionUUID->"0ca8cef9-fc3f-554d-b347-a69c2164ff61"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50088, 1278, 179, 2, 28, "Input",ExpressionUUID->"5f45133a-30c4-4f49-a490-39b934c560e8"],
Cell[50270, 1282, 1439, 43, 45, "Output",ExpressionUUID->"11c98f54-55ed-3241-b670-830a047d3f29"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51746, 1330, 698, 13, 66, "Input",ExpressionUUID->"b15df37a-7f9d-9b4a-93ad-a3c241b7b11e"],
Cell[CellGroupData[{
Cell[52469, 1347, 478, 12, 22, "Print",ExpressionUUID->"a3980c96-2558-f642-ad0b-2a82b829affb"],
Cell[52950, 1361, 231, 4, 22, "Print",ExpressionUUID->"e0eafb7b-6985-a344-aecd-6265a9fed6cd"],
Cell[53184, 1367, 264, 5, 22, "Print",ExpressionUUID->"00b5ec0c-5bda-bc45-870f-fd39cae14710"],
Cell[53451, 1374, 761, 17, 22, "Print",ExpressionUUID->"76b7ea4b-23c0-cc4e-9c2a-444af3e76f63"],
Cell[54215, 1393, 224, 4, 22, "Print",ExpressionUUID->"6fee55f0-c0da-c440-9c7f-706934e95948"]
}, Open  ]],
Cell[54454, 1400, 44649, 1217, 1350, "Output",ExpressionUUID->"2fc48fb1-580f-c04a-a2b6-49c965da966b"],
Cell[CellGroupData[{
Cell[99128, 2621, 476, 12, 22, "Print",ExpressionUUID->"67de92c1-c858-ec4d-9d21-dbe341d88d54"],
Cell[99607, 2635, 231, 4, 22, "Print",ExpressionUUID->"b39ed512-ff3e-b04e-b144-e3c562457ee4"],
Cell[99841, 2641, 266, 5, 22, "Print",ExpressionUUID->"f009e715-d5c0-4e45-ad1c-980b7e858b67"],
Cell[100110, 2648, 222, 4, 22, "Print",ExpressionUUID->"c6fc8b6f-b69f-584c-8135-2cecf6e2e555"],
Cell[100335, 2654, 344, 8, 22, "Print",ExpressionUUID->"717a9e8a-c45a-e643-9eed-26eaa94d5f9c"],
Cell[100682, 2664, 476, 12, 22, "Print",ExpressionUUID->"688e9f50-04ed-4443-b6d6-679191079b19"],
Cell[101161, 2678, 233, 4, 22, "Print",ExpressionUUID->"52e9eafc-028d-144a-bb0c-e6c1ee94294f"],
Cell[101397, 2684, 266, 5, 22, "Print",ExpressionUUID->"c89123aa-2829-9e4b-a85f-943f0efb83dd"],
Cell[101666, 2691, 761, 17, 22, "Print",ExpressionUUID->"a38a8c1d-4e2c-ba40-8436-83d16d18e942"],
Cell[102430, 2710, 224, 4, 22, "Print",ExpressionUUID->"9b0598c3-7c7f-9f42-a62f-c32f5bd1dbab"]
}, Open  ]],
Cell[102669, 2717, 44649, 1217, 1350, "Output",ExpressionUUID->"122842ba-8bf7-1a41-9bd1-abdd905a0e46"]
}, Open  ]],
Cell[CellGroupData[{
Cell[147355, 3939, 223, 3, 28, "Input",ExpressionUUID->"fab766d8-d4cb-c84f-bcf1-5f68d84df60f"],
Cell[147581, 3944, 418, 9, 22, "Print",ExpressionUUID->"448fc8b4-6ab5-5a46-8700-9a4611c44fe0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[148036, 3958, 222, 3, 28, "Input",ExpressionUUID->"93da15f7-93e0-b54d-8ed8-99a3080a2062"],
Cell[CellGroupData[{
Cell[148283, 3965, 618, 13, 22, "Print",ExpressionUUID->"14748a72-26b5-7d47-9b60-33f3162b7205"],
Cell[148904, 3980, 543, 14, 22, "Print",ExpressionUUID->"8960ad36-a41c-2a4f-8408-507509e6b569"],
Cell[149450, 3996, 535, 13, 22, "Print",ExpressionUUID->"34e6b173-8dce-144c-8d09-3af1839289b8"]
}, Open  ]],
Cell[150000, 4012, 217, 4, 32, "Output",ExpressionUUID->"ddfe502a-0aee-d64d-8653-414b3178ef0e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[150254, 4021, 222, 3, 28, "Input",ExpressionUUID->"cae30d0a-cd99-7642-8e93-df400f366ab9"],
Cell[CellGroupData[{
Cell[150501, 4028, 262, 5, 22, "Print",ExpressionUUID->"721e1c85-0c72-ad4d-bef8-167913d7f606"],
Cell[150766, 4035, 260, 5, 22, "Print",ExpressionUUID->"4dd11042-9d52-8346-8781-b8c4a82e8ff3"],
Cell[151029, 4042, 453, 12, 22, "Print",ExpressionUUID->"d8d38cc9-b3db-3a49-91e8-b4c7c0dc2b56"],
Cell[151485, 4056, 210, 4, 22, "Print",ExpressionUUID->"6dfcdca0-7beb-f149-a2e3-8dad6362e898"],
Cell[151698, 4062, 243, 5, 22, "Print",ExpressionUUID->"09d3dfcf-a1f2-c944-96f3-21e9817f1ae6"],
Cell[151944, 4069, 199, 4, 22, "Print",ExpressionUUID->"66813e60-f75c-1b4e-a180-80f72fbb65c9"],
Cell[152146, 4075, 321, 8, 22, "Print",ExpressionUUID->"cde200dd-5485-074c-a294-bb0478da4cb3"],
Cell[152470, 4085, 211, 4, 22, "Print",ExpressionUUID->"f33cbc5c-0168-e247-af5c-aef78c7b3878"]
}, Open  ]],
Cell[152696, 4092, 168, 3, 32, "Output",ExpressionUUID->"fa39c3f5-ceaf-804d-b68b-e3e021a2c9a4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[152901, 4100, 225, 3, 28, "Input",ExpressionUUID->"a5e57f33-df29-404b-9ea8-8312192af198"],
Cell[CellGroupData[{
Cell[153151, 4107, 455, 10, 22, "Print",ExpressionUUID->"5dd62e48-55a0-e648-9a2d-fa3301445a0b"],
Cell[153609, 4119, 235, 4, 22, "Print",ExpressionUUID->"30f7ce88-a58f-3c45-9737-2da163bf9013"],
Cell[153847, 4125, 229, 4, 22, "Print",ExpressionUUID->"1a682066-6112-fd4d-891d-855ab61a2465"],
Cell[154079, 4131, 268, 5, 22, "Print",ExpressionUUID->"ad49d252-9fcb-fc4a-a2a4-788065b50d5f"]
}, Open  ]],
Cell[154362, 4139, 673, 18, 32, "Output",ExpressionUUID->"c43918c8-cc39-c741-a20e-cbbb6bf5447d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155072, 4162, 276, 4, 28, "Input",ExpressionUUID->"fa8c60d7-a1b8-af45-980f-4c9c452debee"],
Cell[CellGroupData[{
Cell[155373, 4170, 225, 4, 22, "Print",ExpressionUUID->"8f339c16-c822-5949-a8f7-a62ac4f151b6"],
Cell[155601, 4176, 212, 4, 22, "Print",ExpressionUUID->"34ed119b-4651-aa4e-9093-9bb214aee6d8"],
Cell[155816, 4182, 216, 4, 22, "Print",ExpressionUUID->"aadfdcd9-a49f-f64c-822f-065946822bb2"],
Cell[156035, 4188, 363, 9, 22, "Print",ExpressionUUID->"30ecf34a-0ca7-894b-b247-5267c4f74939"],
Cell[156401, 4199, 359, 9, 22, "Print",ExpressionUUID->"8837650c-1ccd-ca4b-a36d-e5a5cd2de4ce"],
Cell[156763, 4210, 463, 12, 22, "Print",ExpressionUUID->"34b0a267-5897-9b45-9d38-c2b40af3e951"],
Cell[157229, 4224, 210, 4, 22, "Print",ExpressionUUID->"8d31b8ad-19ca-d240-9a2c-a2177f5f9487"],
Cell[157442, 4230, 241, 5, 22, "Print",ExpressionUUID->"8f42cc36-a80e-e643-8383-b1db65f25484"],
Cell[157686, 4237, 738, 17, 22, "Print",ExpressionUUID->"652c950e-aeac-674c-9488-fd283e174482"],
Cell[158427, 4256, 199, 4, 22, "Print",ExpressionUUID->"a82d896e-2d53-b444-bc19-adf9c0903128"]
}, Open  ]],
Cell[158641, 4263, 678, 14, 26, "Message",ExpressionUUID->"f875df1c-81cf-424a-a9e7-6777a00fbea1"],
Cell[CellGroupData[{
Cell[159344, 4281, 204, 4, 22, "Print",ExpressionUUID->"d062801a-340e-054a-9b40-4ae33c1c16f1"],
Cell[159551, 4287, 393, 9, 22, "Print",ExpressionUUID->"9c615287-eb36-3742-8995-b45e6fed6510"],
Cell[159947, 4298, 423, 10, 22, "Print",ExpressionUUID->"6f6ea25d-c9b9-6646-9fa1-72ffd0e69694"],
Cell[160373, 4310, 290, 5, 22, "Print",ExpressionUUID->"b4fac9db-37f5-ec48-af95-9c8813054169"],
Cell[160666, 4317, 734, 23, 22, "Print",ExpressionUUID->"951a397c-8c3f-8b43-bb83-f7891b8aebaa"],
Cell[161403, 4342, 293, 5, 22, "Print",ExpressionUUID->"05f6f0f6-7df3-d340-92a0-bfc11f0bf730"],
Cell[161699, 4349, 732, 22, 22, "Print",ExpressionUUID->"566860e9-620c-e644-b30b-de02e60b0045"],
Cell[162434, 4373, 293, 5, 22, "Print",ExpressionUUID->"74473d4b-adcb-2c4e-8ee0-8a9b079f49af"],
Cell[162730, 4380, 726, 22, 22, "Print",ExpressionUUID->"fb17053e-f051-0847-8d77-8c3fa51a4a30"],
Cell[163459, 4404, 293, 5, 22, "Print",ExpressionUUID->"e348400c-9be8-b140-a250-469672ddeb77"],
Cell[163755, 4411, 734, 23, 22, "Print",ExpressionUUID->"241c955e-0c23-d344-b555-15ca7a1d2672"],
Cell[164492, 4436, 293, 5, 22, "Print",ExpressionUUID->"d0f12a6b-bcc3-6746-bc17-22c00f4bc194"],
Cell[164788, 4443, 729, 22, 22, "Print",ExpressionUUID->"2b12cb14-7967-4243-a9f2-8fb8bf53cf26"],
Cell[165520, 4467, 293, 5, 22, "Print",ExpressionUUID->"bce928b5-250c-6646-b1dc-4c9cafbd1c95"],
Cell[165816, 4474, 729, 22, 22, "Print",ExpressionUUID->"818d7c10-ad78-ba4d-94e4-feb30790db46"],
Cell[166548, 4498, 293, 5, 22, "Print",ExpressionUUID->"a4aa327d-2379-8040-9ecc-f5244d05eb27"],
Cell[166844, 4505, 732, 22, 22, "Print",ExpressionUUID->"8e09b104-b42d-7a4f-9c40-41b2bf9767bc"],
Cell[167579, 4529, 293, 5, 22, "Print",ExpressionUUID->"af12f06b-0f99-704a-85ac-6d7dd62721dc"],
Cell[167875, 4536, 726, 22, 22, "Print",ExpressionUUID->"4a7c098b-b5f8-8b4a-badf-c973ec9c6eb6"],
Cell[168604, 4560, 291, 5, 22, "Print",ExpressionUUID->"bdb54263-941a-a440-9a5c-9820d764a2e2"],
Cell[168898, 4567, 727, 22, 22, "Print",ExpressionUUID->"aa2ab119-cb61-f84a-bf1e-0d91b4769963"],
Cell[169628, 4591, 293, 5, 22, "Print",ExpressionUUID->"9c7071cb-8217-4144-bd12-1b1ede36636a"],
Cell[169924, 4598, 727, 22, 22, "Print",ExpressionUUID->"e63b24e2-9227-0c4b-b49b-f870294a1f78"],
Cell[170654, 4622, 291, 5, 22, "Print",ExpressionUUID->"ee1fdab9-abbf-4e48-a030-92b72d73b10b"],
Cell[170948, 4629, 729, 22, 22, "Print",ExpressionUUID->"474cdcc6-943f-c64c-aa53-51e37d09b5c1"],
Cell[171680, 4653, 293, 5, 22, "Print",ExpressionUUID->"f1e3fac3-340f-d949-8d52-78001c43bfe9"],
Cell[171976, 4660, 727, 22, 22, "Print",ExpressionUUID->"55e11c97-3bc6-bb46-9f7e-e2e88036fb55"],
Cell[172706, 4684, 293, 5, 22, "Print",ExpressionUUID->"8b101dbd-8097-aa4d-8ba4-c61fb8cc08c7"],
Cell[173002, 4691, 729, 23, 22, "Print",ExpressionUUID->"010744c2-732e-7540-8bef-952d26c608bb"],
Cell[173734, 4716, 291, 5, 22, "Print",ExpressionUUID->"8bff4b1b-9b94-a345-98dc-450f3958498f"],
Cell[174028, 4723, 730, 22, 22, "Print",ExpressionUUID->"c1c38424-a529-1c4b-807c-1bc7e12018c2"],
Cell[174761, 4747, 291, 5, 22, "Print",ExpressionUUID->"afee26a9-c7ea-b34c-b88f-c3f15136a23d"],
Cell[175055, 4754, 729, 22, 22, "Print",ExpressionUUID->"76f19121-dbcb-ec4f-a3b6-7cb759064124"],
Cell[175787, 4778, 293, 5, 22, "Print",ExpressionUUID->"fb9716ef-801c-be46-a189-be89a7a4e722"],
Cell[176083, 4785, 730, 22, 22, "Print",ExpressionUUID->"293364a1-5c48-ca42-b9f2-7fdb415a4c00"],
Cell[176816, 4809, 291, 5, 22, "Print",ExpressionUUID->"16b0600a-bb6d-a647-b880-60313f2f6687"],
Cell[177110, 4816, 724, 22, 22, "Print",ExpressionUUID->"f800bf68-563b-2f41-b199-a8fd3394067b"],
Cell[177837, 4840, 291, 5, 22, "Print",ExpressionUUID->"9880b0a4-5c32-2c47-b448-a1921c193276"],
Cell[178131, 4847, 727, 22, 22, "Print",ExpressionUUID->"130e97b0-a6a7-cc49-8a0d-ec36e12ec86e"],
Cell[178861, 4871, 293, 5, 22, "Print",ExpressionUUID->"20abcc77-f0e7-ba46-af5d-0dc8dfd3e6c3"],
Cell[179157, 4878, 732, 23, 22, "Print",ExpressionUUID->"36447c8f-f98a-f249-ba39-ad351a7c18ef"],
Cell[179892, 4903, 291, 5, 22, "Print",ExpressionUUID->"5febde11-7ebb-8140-835a-0fd44a79c7ee"],
Cell[180186, 4910, 727, 22, 22, "Print",ExpressionUUID->"fe8e655b-8451-7d43-b830-b0aa7d79dff6"],
Cell[180916, 4934, 291, 5, 22, "Print",ExpressionUUID->"d8495231-2f1d-ef49-89c6-cbe9ead3adea"],
Cell[181210, 4941, 729, 22, 22, "Print",ExpressionUUID->"94ceb256-f6ee-4245-9f03-3461b2e03e37"],
Cell[181942, 4965, 293, 5, 22, "Print",ExpressionUUID->"776a7bc0-2dcd-5c46-8db4-ac3e35be0b4e"],
Cell[182238, 4972, 727, 22, 22, "Print",ExpressionUUID->"68c5af62-d372-6442-ac96-066a92b36721"],
Cell[182968, 4996, 291, 5, 22, "Print",ExpressionUUID->"448de6e0-a124-324a-b0fe-a97d3a7231e1"],
Cell[183262, 5003, 729, 22, 22, "Print",ExpressionUUID->"20e14f90-ef72-a14b-9e1d-6b8908e9fac4"],
Cell[183994, 5027, 291, 5, 22, "Print",ExpressionUUID->"453b2eaa-9e30-2643-90e7-85433699f8cf"],
Cell[184288, 5034, 727, 22, 22, "Print",ExpressionUUID->"19e4325c-4088-fa4b-8451-7365bc95b898"],
Cell[185018, 5058, 293, 5, 22, "Print",ExpressionUUID->"be082952-b12c-5349-9925-99c9e52af2fd"],
Cell[185314, 5065, 729, 23, 22, "Print",ExpressionUUID->"1994bfae-2ad6-6648-95f7-2282f79a7b07"],
Cell[186046, 5090, 291, 5, 22, "Print",ExpressionUUID->"37e0a00a-868b-a140-b6f9-1c590ddea276"],
Cell[186340, 5097, 727, 22, 22, "Print",ExpressionUUID->"1f395944-17c6-254f-a6b6-b2957e4ace1c"],
Cell[187070, 5121, 291, 5, 22, "Print",ExpressionUUID->"b9808f30-9ab1-ff43-9f50-2fb09c61427b"],
Cell[187364, 5128, 730, 22, 22, "Print",ExpressionUUID->"8533b95c-c74c-064d-9eef-e23f5e6b10bd"],
Cell[188097, 5152, 291, 5, 22, "Print",ExpressionUUID->"5ce56cb3-bed2-f545-9805-c5f2d20840fb"],
Cell[188391, 5159, 727, 22, 22, "Print",ExpressionUUID->"3893a505-327b-4446-897f-eb2e06e8f9aa"],
Cell[189121, 5183, 293, 5, 22, "Print",ExpressionUUID->"582651aa-9c0c-2248-a327-ac366328a358"],
Cell[189417, 5190, 724, 22, 22, "Print",ExpressionUUID->"aa3447df-86a1-b140-89c1-735005f8ab66"],
Cell[190144, 5214, 291, 5, 22, "Print",ExpressionUUID->"11a16906-6fa4-a44c-83f4-ed122b7cb50c"],
Cell[190438, 5221, 732, 22, 22, "Print",ExpressionUUID->"1c7b996b-3b81-294a-9c0c-52f0a77cafc8"],
Cell[191173, 5245, 293, 5, 22, "Print",ExpressionUUID->"87f6efb4-df2b-fd4b-aa38-85b0e3318843"],
Cell[191469, 5252, 734, 23, 22, "Print",ExpressionUUID->"4ce6375e-a8f2-4c4e-a7ad-42bf25f4e3b4"],
Cell[192206, 5277, 293, 5, 22, "Print",ExpressionUUID->"9f2345e1-5dac-2b4f-a89a-70cec99c8942"],
Cell[192502, 5284, 724, 22, 22, "Print",ExpressionUUID->"1caaa453-2b5e-2747-b406-2c996b4100e5"],
Cell[193229, 5308, 291, 5, 22, "Print",ExpressionUUID->"0fb8434a-5fd7-0c44-9886-d01b780a6678"],
Cell[193523, 5315, 732, 22, 22, "Print",ExpressionUUID->"b2c0cd50-5b44-5e45-86e6-424dad7a08ea"],
Cell[194258, 5339, 291, 5, 22, "Print",ExpressionUUID->"e80a9bc7-884a-0c41-98d0-4e5f0ed91e50"],
Cell[194552, 5346, 727, 22, 22, "Print",ExpressionUUID->"a428ed13-825a-2045-b565-6c9363e38343"],
Cell[195282, 5370, 293, 5, 22, "Print",ExpressionUUID->"b654b88b-8f66-fa44-846f-0147b27ddacc"],
Cell[195578, 5377, 726, 22, 22, "Print",ExpressionUUID->"117d0f3f-fef3-0049-b90f-91d6abf4de69"],
Cell[196307, 5401, 293, 5, 22, "Print",ExpressionUUID->"5161a2b0-ddd7-f449-9431-0e2c14f758a7"],
Cell[196603, 5408, 732, 22, 22, "Print",ExpressionUUID->"dbe052f3-eee8-cb41-a8ee-e5f26ee6e460"],
Cell[197338, 5432, 291, 5, 22, "Print",ExpressionUUID->"6efcaefe-fbc3-a549-9ae5-8a5f8fe34b2f"],
Cell[197632, 5439, 734, 23, 22, "Print",ExpressionUUID->"a4056ee3-9bf4-eb48-8ce9-64146e617ff2"],
Cell[198369, 5464, 293, 5, 22, "Print",ExpressionUUID->"ea252aef-e633-934f-bf9e-b9e4970f342c"],
Cell[198665, 5471, 729, 22, 22, "Print",ExpressionUUID->"d7ef1960-2b09-e34c-bf89-823bebeb4268"],
Cell[199397, 5495, 293, 5, 22, "Print",ExpressionUUID->"1fbbf054-72a1-7f40-a503-16c9d6a07260"],
Cell[199693, 5502, 734, 23, 22, "Print",ExpressionUUID->"b79f0232-99b4-f24b-aa7a-67610bc77543"],
Cell[200430, 5527, 293, 5, 22, "Print",ExpressionUUID->"6b17e117-0701-8849-959c-92a07c4f5421"],
Cell[200726, 5534, 727, 22, 22, "Print",ExpressionUUID->"20bba717-f82f-234a-b74b-18fc8e4e77b5"],
Cell[201456, 5558, 293, 5, 22, "Print",ExpressionUUID->"24b6f2aa-18d9-bb44-8c69-895ce3230a6c"],
Cell[201752, 5565, 729, 22, 22, "Print",ExpressionUUID->"85a5613a-bf56-9f43-b739-b5cf2c578aff"],
Cell[202484, 5589, 291, 5, 22, "Print",ExpressionUUID->"283ea457-9df6-db4d-8274-c7a548559ae3"],
Cell[202778, 5596, 732, 23, 22, "Print",ExpressionUUID->"847a51a1-2534-dd44-8d2e-7a9ca8b4600f"],
Cell[203513, 5621, 291, 5, 22, "Print",ExpressionUUID->"28f20238-15a6-454c-8657-5e7c5cc3409b"],
Cell[203807, 5628, 731, 23, 22, "Print",ExpressionUUID->"4272107c-7feb-614e-852e-3c482afc53aa"],
Cell[204541, 5653, 293, 5, 22, "Print",ExpressionUUID->"18b00cc0-39a8-014a-a366-beb5675de193"],
Cell[204837, 5660, 730, 22, 22, "Print",ExpressionUUID->"a4557512-8a2a-f445-a0f4-fb06e8fcac5b"],
Cell[205570, 5684, 293, 5, 22, "Print",ExpressionUUID->"1e4ffe7b-9877-bc4c-b51e-0c8a7a525965"],
Cell[205866, 5691, 734, 23, 22, "Print",ExpressionUUID->"6cf70ded-6188-bb48-9849-506d41c0a38c"],
Cell[206603, 5716, 291, 5, 22, "Print",ExpressionUUID->"fc007bd4-0128-084a-96a5-d87e0ca2f944"],
Cell[206897, 5723, 726, 22, 22, "Print",ExpressionUUID->"61a4f3d0-4c95-204f-a28c-e893e528460a"],
Cell[207626, 5747, 293, 5, 22, "Print",ExpressionUUID->"35d6d05e-d0d5-c646-bd63-75def190384e"],
Cell[207922, 5754, 730, 22, 22, "Print",ExpressionUUID->"652d10e8-401c-234c-8eeb-15d298ed9f9a"],
Cell[208655, 5778, 291, 5, 22, "Print",ExpressionUUID->"09d69c2e-bc46-0041-9981-6674d63f1ae3"],
Cell[208949, 5785, 734, 23, 22, "Print",ExpressionUUID->"19c9c441-b4f7-2743-9482-9a8b8ade49e1"],
Cell[209686, 5810, 293, 5, 22, "Print",ExpressionUUID->"d13d839b-b8d0-394f-bedc-ad46466022cc"],
Cell[209982, 5817, 732, 23, 22, "Print",ExpressionUUID->"9f51f731-eb76-fc41-892c-b415f7777a12"],
Cell[210717, 5842, 291, 5, 22, "Print",ExpressionUUID->"0a68a7c0-39d6-8241-b44d-6a673403d318"],
Cell[211011, 5849, 732, 22, 22, "Print",ExpressionUUID->"549f2502-0ab0-934c-b98b-4e91c5733bf0"],
Cell[211746, 5873, 293, 5, 22, "Print",ExpressionUUID->"8a64df04-1342-ed49-89e1-c76cec68964b"],
Cell[212042, 5880, 729, 23, 22, "Print",ExpressionUUID->"e45b3f58-2ace-0945-98cf-ce0e9c7461cd"],
Cell[212774, 5905, 293, 5, 22, "Print",ExpressionUUID->"c46ed651-ef91-ec42-9d99-030d2cc6fa60"],
Cell[213070, 5912, 732, 22, 22, "Print",ExpressionUUID->"11e756ee-4577-e04c-8a11-8eee6745ef39"],
Cell[213805, 5936, 291, 5, 22, "Print",ExpressionUUID->"d0486e09-c191-b54b-9b69-ed62efcbfa28"],
Cell[214099, 5943, 727, 22, 22, "Print",ExpressionUUID->"dfb5ad6d-1c66-a847-af90-d156c9c6aa68"],
Cell[214829, 5967, 291, 5, 22, "Print",ExpressionUUID->"fa142299-6f51-7b46-b95d-39b576c73bad"],
Cell[215123, 5974, 731, 23, 22, "Print",ExpressionUUID->"ad56cd8c-319f-1446-bbe9-9cabff9ee61e"],
Cell[215857, 5999, 293, 5, 22, "Print",ExpressionUUID->"1ae9f5d1-86dc-c14c-bff2-e5727fe5f3a4"],
Cell[216153, 6006, 732, 23, 22, "Print",ExpressionUUID->"e60388b9-3908-e047-941f-be6986d14237"],
Cell[216888, 6031, 291, 5, 22, "Print",ExpressionUUID->"6272cae8-2ad0-5844-b2a1-8e55ecbd7221"],
Cell[217182, 6038, 732, 22, 22, "Print",ExpressionUUID->"6e647ff3-0bf6-2745-a6f8-c9d71f321946"],
Cell[217917, 6062, 293, 5, 22, "Print",ExpressionUUID->"568d8aa8-a61d-db4d-9046-338a16fa6141"],
Cell[218213, 6069, 729, 23, 22, "Print",ExpressionUUID->"edfaa767-8407-0742-89d3-c90e7898b431"],
Cell[218945, 6094, 291, 5, 22, "Print",ExpressionUUID->"f20b708a-d9f6-db44-b9d0-b484e0757e93"],
Cell[219239, 6101, 729, 22, 22, "Print",ExpressionUUID->"ec386c58-34b5-5a42-b34b-b0712814d735"],
Cell[219971, 6125, 293, 5, 22, "Print",ExpressionUUID->"e95aedbb-afd7-4b4a-a749-ef938a2cb124"],
Cell[220267, 6132, 732, 22, 22, "Print",ExpressionUUID->"a0f04f5b-0883-534b-8745-7543124649b1"],
Cell[221002, 6156, 291, 5, 22, "Print",ExpressionUUID->"16a24df5-e4ae-a14f-b647-1ecfdf1ac435"],
Cell[221296, 6163, 729, 23, 22, "Print",ExpressionUUID->"dc4ee1ab-b3aa-ab42-8248-e229c45f27d4"],
Cell[222028, 6188, 291, 5, 22, "Print",ExpressionUUID->"eaa4d9c7-8259-5d45-aa71-fd4b15d91f48"],
Cell[222322, 6195, 729, 23, 22, "Print",ExpressionUUID->"91c53cd7-dbd3-6241-a119-a114210c39a8"],
Cell[223054, 6220, 291, 5, 22, "Print",ExpressionUUID->"aee2c2c8-879c-a943-9a11-065aaa30c4a2"],
Cell[223348, 6227, 732, 22, 22, "Print",ExpressionUUID->"3ee58789-8180-ea49-bf71-89a957151f56"],
Cell[224083, 6251, 293, 5, 22, "Print",ExpressionUUID->"7acb717b-ef27-e344-9bf0-b961fea33f27"],
Cell[224379, 6258, 732, 23, 22, "Print",ExpressionUUID->"59426181-eb38-bf46-a647-797cffdb7032"],
Cell[225114, 6283, 291, 5, 22, "Print",ExpressionUUID->"7b0321a1-570b-ad46-abd8-6451b393ad4d"],
Cell[225408, 6290, 730, 22, 22, "Print",ExpressionUUID->"8c922dbf-1a91-ea40-83a4-4c9081bb8af4"],
Cell[226141, 6314, 291, 5, 22, "Print",ExpressionUUID->"364e014f-85de-f845-aa7a-7e01d60ec456"],
Cell[226435, 6321, 726, 22, 22, "Print",ExpressionUUID->"da4797de-1fe3-4e41-b9df-42adc7946b7d"],
Cell[227164, 6345, 293, 5, 22, "Print",ExpressionUUID->"31cca2aa-d58b-304a-8775-bab2769b2876"],
Cell[227460, 6352, 734, 23, 22, "Print",ExpressionUUID->"5de9828e-1a22-c84a-b372-995befb3120b"],
Cell[228197, 6377, 293, 5, 22, "Print",ExpressionUUID->"35d699d9-d72a-694b-8da9-ecf6f27f7eae"],
Cell[228493, 6384, 734, 23, 22, "Print",ExpressionUUID->"d592bb9b-a5ac-a94f-9f49-2944e8472e18"],
Cell[229230, 6409, 291, 5, 22, "Print",ExpressionUUID->"9aa75a05-562b-a343-9cda-90ff5472fc11"],
Cell[229524, 6416, 727, 22, 22, "Print",ExpressionUUID->"22def0b4-9c6e-4946-ad03-8391ddcf7a74"],
Cell[230254, 6440, 291, 5, 22, "Print",ExpressionUUID->"3f0a2afd-a1ed-5a4a-9e44-c8c72f6abff3"],
Cell[230548, 6447, 732, 23, 22, "Print",ExpressionUUID->"476bce57-0476-1349-a7dd-e9fdbc83893b"],
Cell[231283, 6472, 291, 5, 22, "Print",ExpressionUUID->"63ac4901-288f-1c48-8eb4-29c795285045"],
Cell[231577, 6479, 729, 22, 22, "Print",ExpressionUUID->"55e8cea3-ce60-0142-82d1-bbdcbfac323e"],
Cell[232309, 6503, 293, 5, 22, "Print",ExpressionUUID->"f220c5be-a7ff-374c-9019-faa7b4eceb5c"],
Cell[232605, 6510, 727, 22, 22, "Print",ExpressionUUID->"21c01988-f45b-314c-b4a0-da870a745889"],
Cell[233335, 6534, 293, 5, 22, "Print",ExpressionUUID->"f53c05c8-3f4a-c647-97d2-ec4f306b8ff1"],
Cell[233631, 6541, 734, 23, 22, "Print",ExpressionUUID->"6d40bebb-e3f0-9346-ab54-06d49d56b537"],
Cell[234368, 6566, 291, 5, 22, "Print",ExpressionUUID->"ea773232-0080-9941-9a85-17d780f8e80d"],
Cell[234662, 6573, 732, 23, 22, "Print",ExpressionUUID->"a6fe568f-0fac-964a-a193-426b0fe077be"],
Cell[235397, 6598, 291, 5, 22, "Print",ExpressionUUID->"f34c1877-8506-1a45-ae79-d584cf0f7be6"],
Cell[235691, 6605, 724, 22, 22, "Print",ExpressionUUID->"986f789f-b588-d141-8f62-6405c9d362d6"],
Cell[236418, 6629, 291, 5, 22, "Print",ExpressionUUID->"64374aff-1a04-af4d-93fa-01b5c9a66e9a"],
Cell[236712, 6636, 735, 23, 22, "Print",ExpressionUUID->"e3a54635-a51a-4343-aa9f-d140a0201a84"],
Cell[237450, 6661, 293, 5, 22, "Print",ExpressionUUID->"4e1fbbd9-3971-1445-adbf-d2b1e0c9c5c9"],
Cell[237746, 6668, 726, 22, 22, "Print",ExpressionUUID->"d4f87efb-2a83-1a44-a754-1cc5f680cc94"],
Cell[238475, 6692, 291, 5, 22, "Print",ExpressionUUID->"210f421b-40a9-ab40-8640-8a4dbed3bff5"],
Cell[238769, 6699, 726, 22, 22, "Print",ExpressionUUID->"930d4a24-fa18-5546-a206-d7633cdecb4b"],
Cell[239498, 6723, 290, 5, 22, "Print",ExpressionUUID->"20da0257-5028-704f-8375-0688867311e8"],
Cell[239791, 6730, 735, 23, 22, "Print",ExpressionUUID->"4a81caf0-b3e1-0849-b2d8-9e3a7885d877"],
Cell[240529, 6755, 291, 5, 22, "Print",ExpressionUUID->"07c395d7-5285-e74a-a7e2-6b3e263397ab"],
Cell[240823, 6762, 729, 23, 22, "Print",ExpressionUUID->"fe34fad8-7fcb-824c-b493-7fbb81cab458"],
Cell[241555, 6787, 293, 5, 22, "Print",ExpressionUUID->"146edcd0-9ab8-f243-bf51-bf0e9991c3c9"],
Cell[241851, 6794, 727, 22, 22, "Print",ExpressionUUID->"4d09ffd8-b07a-8945-9f5f-189ec469cfeb"],
Cell[242581, 6818, 291, 5, 22, "Print",ExpressionUUID->"3a606d5d-0d2b-fb42-9fb1-d8d47ead352e"],
Cell[242875, 6825, 737, 23, 22, "Print",ExpressionUUID->"4b7dcb46-4b6b-cd4b-be66-b16ce20b9dae"],
Cell[243615, 6850, 293, 5, 22, "Print",ExpressionUUID->"b0938b89-78c5-5942-996c-6084b6820889"],
Cell[243911, 6857, 724, 22, 22, "Print",ExpressionUUID->"d090fc1b-7a1e-ba4d-9fd9-5f26be3d9745"],
Cell[244638, 6881, 291, 5, 22, "Print",ExpressionUUID->"15f8e599-a63c-3545-80ab-88bdadfba1c1"],
Cell[244932, 6888, 727, 22, 22, "Print",ExpressionUUID->"7bb198ec-7b3c-ee48-a02f-73350cee5b0d"],
Cell[245662, 6912, 290, 5, 22, "Print",ExpressionUUID->"1463eb6f-42a2-be44-9604-b190d8a0c399"],
Cell[245955, 6919, 737, 23, 22, "Print",ExpressionUUID->"91074f11-87b4-364e-aacf-926f8aaa428d"],
Cell[246695, 6944, 293, 5, 22, "Print",ExpressionUUID->"ac38b41e-1fcf-f84e-90e7-b17ae05474dd"],
Cell[246991, 6951, 731, 23, 22, "Print",ExpressionUUID->"a8a69325-0da0-5444-a16d-f47ac474def0"],
Cell[247725, 6976, 290, 5, 22, "Print",ExpressionUUID->"9eda5ddf-e3f1-eb49-a65e-fa763cdbb1f8"],
Cell[248018, 6983, 731, 23, 22, "Print",ExpressionUUID->"7f9d1ef3-4c3b-6e4c-848f-5263d0bcbab3"],
Cell[248752, 7008, 293, 5, 22, "Print",ExpressionUUID->"0461b527-d110-714e-babd-be7fc1c2a0be"],
Cell[249048, 7015, 735, 23, 22, "Print",ExpressionUUID->"390bd92f-de04-9b46-b1b5-3dede350af83"],
Cell[249786, 7040, 291, 5, 22, "Print",ExpressionUUID->"79fb19c0-c2de-c046-9a5a-f27435334cab"],
Cell[250080, 7047, 727, 22, 22, "Print",ExpressionUUID->"c3f9825c-f946-7c4e-8e79-3306cd9c620b"],
Cell[250810, 7071, 293, 5, 22, "Print",ExpressionUUID->"d640b857-b07d-0340-b5e7-6729312bee62"],
Cell[251106, 7078, 729, 23, 22, "Print",ExpressionUUID->"3bcc5b62-16de-dd42-a3ab-8ec3ba3df639"],
Cell[251838, 7103, 291, 5, 22, "Print",ExpressionUUID->"037ebe3e-93ce-544e-a5a8-7f6a1e40298f"],
Cell[252132, 7110, 737, 23, 22, "Print",ExpressionUUID->"dda4c25f-320e-994b-9a09-406c730ca2ee"],
Cell[252872, 7135, 293, 5, 22, "Print",ExpressionUUID->"b1d18180-e3e6-e046-9526-4383da403011"],
Cell[253168, 7142, 728, 23, 22, "Print",ExpressionUUID->"6627345a-be7b-7d42-9c79-d9499f4b9fdc"],
Cell[253899, 7167, 293, 5, 22, "Print",ExpressionUUID->"ebed2611-0ae6-c74e-b373-5041b5c0dae3"],
Cell[254195, 7174, 732, 23, 22, "Print",ExpressionUUID->"1a53abfb-0e1a-4449-a88f-04579293a133"],
Cell[254930, 7199, 291, 5, 22, "Print",ExpressionUUID->"723a2610-f138-4945-a7cb-6b6339ae4d8d"],
Cell[255224, 7206, 735, 23, 22, "Print",ExpressionUUID->"d77dfddd-2b14-0d4c-ae07-d42a1e423f2d"],
Cell[255962, 7231, 291, 5, 22, "Print",ExpressionUUID->"4472ac7d-f9d5-444e-874b-2583fa9b7b87"],
Cell[256256, 7238, 726, 22, 22, "Print",ExpressionUUID->"582a7154-065d-dc47-8a7a-f2c951dfe397"],
Cell[256985, 7262, 293, 5, 22, "Print",ExpressionUUID->"d98b29d1-880d-ba48-a3d5-b880a075a348"],
Cell[257281, 7269, 732, 23, 22, "Print",ExpressionUUID->"e50659c4-e7d9-4740-a7b3-a0d0af39e00f"],
Cell[258016, 7294, 291, 5, 22, "Print",ExpressionUUID->"04073f13-2dc4-f147-bcb0-3e108acbeefb"],
Cell[258310, 7301, 735, 23, 22, "Print",ExpressionUUID->"eb1c93ac-7979-9543-acc4-a103ab06f727"],
Cell[259048, 7326, 291, 5, 22, "Print",ExpressionUUID->"4c8f657d-3c23-104e-8d84-2115cd435c0d"],
Cell[259342, 7333, 734, 23, 22, "Print",ExpressionUUID->"66494fc1-5a29-574f-95f9-fc7723bf50c0"],
Cell[260079, 7358, 293, 5, 22, "Print",ExpressionUUID->"281ff91e-f9cd-2446-b420-80f3cbe18fa4"],
Cell[260375, 7365, 729, 22, 22, "Print",ExpressionUUID->"eccdbb1e-2aa5-dd45-8ac3-542ad8f84352"],
Cell[261107, 7389, 291, 5, 22, "Print",ExpressionUUID->"77dc912c-870d-0140-b269-779e6c7f3db3"],
Cell[261401, 7396, 732, 23, 22, "Print",ExpressionUUID->"bf3babe3-3ddb-934c-993a-71ce9f95ed5a"],
Cell[262136, 7421, 293, 5, 22, "Print",ExpressionUUID->"3eb53d20-bef9-ef47-a2c2-6da1053ed25b"],
Cell[262432, 7428, 727, 22, 22, "Print",ExpressionUUID->"78e70cdf-03cd-4d4d-836f-af04fc1968cb"],
Cell[263162, 7452, 291, 5, 22, "Print",ExpressionUUID->"15bf3ee6-135d-154b-9abb-1b3092440a74"],
Cell[263456, 7459, 729, 22, 22, "Print",ExpressionUUID->"c8f4f002-6832-2d41-90d0-e377f5bcbb46"],
Cell[264188, 7483, 291, 5, 22, "Print",ExpressionUUID->"5f6228fc-6605-3344-9d73-2a1a87a60837"],
Cell[264482, 7490, 732, 23, 22, "Print",ExpressionUUID->"434d4f13-8135-cb49-b289-fb748d089b8d"],
Cell[265217, 7515, 293, 5, 22, "Print",ExpressionUUID->"61c9e518-f0ba-0e46-8465-2bcd4697286a"],
Cell[265513, 7522, 734, 23, 22, "Print",ExpressionUUID->"19bc22b9-cceb-3b41-87ed-96f10b427860"],
Cell[266250, 7547, 293, 5, 22, "Print",ExpressionUUID->"b495fdaf-978f-5a4c-90f4-f2f5dea4098e"],
Cell[266546, 7554, 727, 22, 22, "Print",ExpressionUUID->"c6bb6b14-e0f0-5a42-8615-5acf1a63fc9e"],
Cell[267276, 7578, 291, 5, 22, "Print",ExpressionUUID->"8a3a8817-3a2f-ad48-ad6e-3682ac88afc6"],
Cell[267570, 7585, 734, 23, 22, "Print",ExpressionUUID->"a8feb84f-2796-904e-80ba-5ddbd3f66a51"],
Cell[268307, 7610, 293, 5, 22, "Print",ExpressionUUID->"c363727c-a859-764d-a91a-4901cc4c94be"],
Cell[268603, 7617, 729, 22, 22, "Print",ExpressionUUID->"7a937aaa-f94f-0445-898c-2c3416523ae0"],
Cell[269335, 7641, 293, 5, 22, "Print",ExpressionUUID->"acb2de20-7982-004a-96a8-ecd1065911fe"],
Cell[269631, 7648, 727, 22, 22, "Print",ExpressionUUID->"0506e947-a8ef-924c-a6e3-b6361297c784"],
Cell[270361, 7672, 291, 5, 22, "Print",ExpressionUUID->"f9c98893-0fed-794c-a11d-f39f73663f3f"],
Cell[270655, 7679, 734, 23, 22, "Print",ExpressionUUID->"a2363f93-183f-0e42-bbb4-b5d688d26dce"],
Cell[271392, 7704, 293, 5, 22, "Print",ExpressionUUID->"4d3c2dce-5661-eb44-96a6-41ffad900427"],
Cell[271688, 7711, 732, 23, 22, "Print",ExpressionUUID->"42cda035-e744-244d-8fe9-e8d57166b13f"],
Cell[272423, 7736, 291, 5, 22, "Print",ExpressionUUID->"92ef3bbc-ac7d-e449-b5a1-c3435bb898ae"],
Cell[272717, 7743, 734, 23, 22, "Print",ExpressionUUID->"600cd014-80ad-a349-b8e2-7fe6fc971a51"],
Cell[273454, 7768, 291, 5, 22, "Print",ExpressionUUID->"d5c3c4a9-7fa5-fb48-bb0d-f9642678473e"],
Cell[273748, 7775, 732, 23, 22, "Print",ExpressionUUID->"f9c84573-69d4-2347-9c35-28825ce0e874"],
Cell[274483, 7800, 293, 5, 22, "Print",ExpressionUUID->"f82c6dee-a24a-6641-8097-609d5f97cc30"],
Cell[274779, 7807, 727, 22, 22, "Print",ExpressionUUID->"603bd344-c391-2c4d-b178-75bff7f149e3"],
Cell[275509, 7831, 291, 5, 22, "Print",ExpressionUUID->"12a10d6e-f05f-6248-964a-2037e9738e1e"],
Cell[275803, 7838, 734, 23, 22, "Print",ExpressionUUID->"6b3d68ff-8eb9-1c4d-a954-8157808eddfd"],
Cell[276540, 7863, 291, 5, 22, "Print",ExpressionUUID->"a37ab36b-ceda-d049-bbba-9aa21a014499"],
Cell[276834, 7870, 732, 23, 22, "Print",ExpressionUUID->"c65e1be0-852e-b74b-99b9-00495876b5f4"],
Cell[277569, 7895, 291, 5, 22, "Print",ExpressionUUID->"75d8047a-20e4-a14a-b8a0-b2e90f97fffd"],
Cell[277863, 7902, 731, 23, 22, "Print",ExpressionUUID->"bde3a1ec-71d3-c74e-abe6-04e16d201837"],
Cell[278597, 7927, 290, 5, 22, "Print",ExpressionUUID->"8663a46a-07ba-7c43-a4a8-2fa4c6ca156b"],
Cell[278890, 7934, 734, 23, 22, "Print",ExpressionUUID->"9f143447-d1cc-f24c-bc4f-4b0886975dbc"],
Cell[279627, 7959, 293, 5, 22, "Print",ExpressionUUID->"b22f9033-2f4e-1e43-9a56-15936e8df634"],
Cell[279923, 7966, 734, 23, 22, "Print",ExpressionUUID->"9efc4a40-7dc2-ec40-b1cf-e6260ee3559a"],
Cell[280660, 7991, 291, 5, 22, "Print",ExpressionUUID->"25ced738-2158-ff49-885d-569ebdfeb978"],
Cell[280954, 7998, 727, 22, 22, "Print",ExpressionUUID->"d9615ba9-db7f-d246-8c87-246b0e85d1ec"],
Cell[281684, 8022, 291, 5, 22, "Print",ExpressionUUID->"62d06363-f0f0-0249-92ff-8eb269d2d842"],
Cell[281978, 8029, 734, 23, 22, "Print",ExpressionUUID->"6bc848d4-4f36-224e-a986-412e91736e8c"],
Cell[282715, 8054, 293, 5, 22, "Print",ExpressionUUID->"b86f171b-979f-c246-9078-2ae7c19c380d"],
Cell[283011, 8061, 732, 23, 22, "Print",ExpressionUUID->"efa8d52c-08f2-bc4f-a3a1-6ea5cc6b856e"],
Cell[283746, 8086, 291, 5, 22, "Print",ExpressionUUID->"47099bf4-8bfb-c045-b767-2b18fd303f34"],
Cell[284040, 8093, 731, 23, 22, "Print",ExpressionUUID->"8e1d50f9-3641-594c-b4d4-babe2cd489c5"],
Cell[284774, 8118, 291, 5, 22, "Print",ExpressionUUID->"6090da84-8963-a242-ba0b-a2e45dbb3dca"],
Cell[285068, 8125, 727, 22, 22, "Print",ExpressionUUID->"52e00ace-f1cd-e64b-82de-85da83aee391"],
Cell[285798, 8149, 291, 5, 22, "Print",ExpressionUUID->"900bced6-ce16-0448-9da5-77f3b25e9efb"],
Cell[286092, 8156, 737, 23, 22, "Print",ExpressionUUID->"a005a061-b98f-3b47-97fa-bd5d64572707"],
Cell[286832, 8181, 293, 5, 22, "Print",ExpressionUUID->"a64451cc-d6b9-f24b-ac32-57ec47768284"],
Cell[287128, 8188, 727, 22, 22, "Print",ExpressionUUID->"ebfc37e2-ece6-f64a-b207-2c0549a63521"],
Cell[287858, 8212, 293, 5, 22, "Print",ExpressionUUID->"a46dff40-d68e-5f4c-bc29-b604526f7058"],
Cell[288154, 8219, 726, 22, 22, "Print",ExpressionUUID->"a7eb8397-3d4d-ad4a-8581-0309432ab96b"],
Cell[288883, 8243, 293, 5, 22, "Print",ExpressionUUID->"10cc6d50-b84f-2e4d-bc03-31432df895dd"],
Cell[289179, 8250, 735, 23, 22, "Print",ExpressionUUID->"0d976be3-352a-8c4f-b182-9e915a6df369"],
Cell[289917, 8275, 293, 5, 22, "Print",ExpressionUUID->"8c3b62f8-1dd3-8c41-87b0-785f894f7bde"],
Cell[290213, 8282, 734, 23, 22, "Print",ExpressionUUID->"6da48cd9-dae9-8d4c-993c-5ef315853163"],
Cell[290950, 8307, 291, 5, 22, "Print",ExpressionUUID->"3c792239-a397-6b43-b7a7-220b500f4248"],
Cell[291244, 8314, 726, 22, 22, "Print",ExpressionUUID->"496ae409-838a-0643-8162-cf61ce4c3a72"],
Cell[291973, 8338, 293, 5, 22, "Print",ExpressionUUID->"0193e05e-4edb-5940-8273-e0c31ffcf0dd"],
Cell[292269, 8345, 735, 23, 22, "Print",ExpressionUUID->"6aaae9ab-d91a-1e4f-bb16-d1d6f53264c1"],
Cell[293007, 8370, 291, 5, 22, "Print",ExpressionUUID->"75bd458d-f6bb-5e47-b24d-eea33801c2c0"],
Cell[293301, 8377, 729, 22, 22, "Print",ExpressionUUID->"a7d0ec02-bf34-1046-b989-330bce6140fe"],
Cell[294033, 8401, 293, 5, 22, "Print",ExpressionUUID->"a429ec2e-c868-1c4c-8aab-89131a7fc2da"],
Cell[294329, 8408, 726, 22, 22, "Print",ExpressionUUID->"63c80ba9-cd45-8e43-8104-8de02ab1ceb5"],
Cell[295058, 8432, 293, 5, 22, "Print",ExpressionUUID->"30689c94-c594-0741-904e-9dc3021b3474"],
Cell[295354, 8439, 737, 23, 22, "Print",ExpressionUUID->"f7bc2896-c402-bc40-bbca-16cd053eb08f"],
Cell[296094, 8464, 293, 5, 22, "Print",ExpressionUUID->"90ff6a35-6c83-a24d-b70b-cd3273fe31d0"],
Cell[296390, 8471, 729, 23, 22, "Print",ExpressionUUID->"5e14eeea-aac3-fb4d-80b6-1146a5816887"],
Cell[297122, 8496, 293, 5, 22, "Print",ExpressionUUID->"2f1356eb-aca3-ff4b-8e28-268aef638486"],
Cell[297418, 8503, 734, 23, 22, "Print",ExpressionUUID->"34b71ffb-b849-b943-baf4-3414381e1b87"],
Cell[298155, 8528, 293, 5, 22, "Print",ExpressionUUID->"73424537-15f0-2746-bdf1-dee53def4cba"],
Cell[298451, 8535, 737, 23, 22, "Print",ExpressionUUID->"68441112-79e3-8446-b0bd-92cc80f69a72"],
Cell[299191, 8560, 293, 5, 22, "Print",ExpressionUUID->"1559fc6b-ec30-6044-ac9b-0dceeff71a40"],
Cell[299487, 8567, 726, 22, 22, "Print",ExpressionUUID->"38aafe61-f359-b541-8d7e-1081de481cae"],
Cell[300216, 8591, 293, 5, 22, "Print",ExpressionUUID->"8220faa6-c3d9-fe4e-baf2-cb961f49524f"],
Cell[300512, 8598, 732, 23, 22, "Print",ExpressionUUID->"6d776577-877b-ee49-b9f4-f3d2cb1b8869"],
Cell[301247, 8623, 291, 5, 22, "Print",ExpressionUUID->"b95cc93e-a70d-ab46-92f7-fe750d91845c"],
Cell[301541, 8630, 737, 23, 22, "Print",ExpressionUUID->"1bcacfb1-720b-df46-83ee-234606355c87"],
Cell[302281, 8655, 290, 5, 22, "Print",ExpressionUUID->"6ef00847-5a66-7347-9396-b3ef43957e62"],
Cell[302574, 8662, 731, 23, 22, "Print",ExpressionUUID->"7a624fb6-7202-974b-8fcd-bc6462384199"],
Cell[303308, 8687, 293, 5, 22, "Print",ExpressionUUID->"4bf127fb-9533-5045-b5ec-a829b1725745"],
Cell[303604, 8694, 731, 23, 22, "Print",ExpressionUUID->"2985256c-cc8d-2c46-9385-b1fcd5060e03"],
Cell[304338, 8719, 293, 5, 22, "Print",ExpressionUUID->"e451a78b-2d20-f343-80d7-f246719a5f55"],
Cell[304634, 8726, 737, 23, 22, "Print",ExpressionUUID->"0217ee0d-167b-7444-92c9-444871759dd3"],
Cell[305374, 8751, 293, 5, 22, "Print",ExpressionUUID->"9d40f566-bc51-bb41-bc67-ee301b39d541"],
Cell[305670, 8758, 729, 22, 22, "Print",ExpressionUUID->"cfc51660-4a89-e749-b274-46f4f08fe58d"],
Cell[306402, 8782, 293, 5, 22, "Print",ExpressionUUID->"eadda56e-8b4a-7a45-863b-e606720ea41c"],
Cell[306698, 8789, 731, 23, 22, "Print",ExpressionUUID->"78de110e-d895-4e47-8ad3-341498285472"],
Cell[307432, 8814, 293, 5, 22, "Print",ExpressionUUID->"2dae66e5-d1d0-904a-ac29-c87649587753"],
Cell[307728, 8821, 735, 23, 22, "Print",ExpressionUUID->"498f3c75-8e6a-0e40-9bfa-5e06b5784ffe"],
Cell[308466, 8846, 291, 5, 22, "Print",ExpressionUUID->"0cf7d285-7288-fd40-9925-baa0e61ef304"],
Cell[308760, 8853, 734, 23, 22, "Print",ExpressionUUID->"5b054cdc-455c-7e40-9906-6218a4973bb4"],
Cell[309497, 8878, 293, 5, 22, "Print",ExpressionUUID->"d77e9770-c3e2-af4a-95b5-f34ebc8b3707"],
Cell[309793, 8885, 730, 22, 22, "Print",ExpressionUUID->"ac7d0344-8160-8246-ada3-4e272cc2238d"],
Cell[310526, 8909, 293, 5, 22, "Print",ExpressionUUID->"4d91cb5c-2da5-9b48-acb7-95c00ee0dba0"],
Cell[310822, 8916, 726, 22, 22, "Print",ExpressionUUID->"123b95a3-9dae-6a43-946d-fef6ea57c396"],
Cell[311551, 8940, 291, 5, 22, "Print",ExpressionUUID->"c214a39b-5e87-4b47-a5f2-2df26f2c727d"],
Cell[311845, 8947, 732, 23, 22, "Print",ExpressionUUID->"121fc0e9-e7e0-8d48-a37c-620929a974d2"],
Cell[312580, 8972, 291, 5, 22, "Print",ExpressionUUID->"7df0c7c4-0bbd-3741-be9c-9d14a4e2a207"],
Cell[312874, 8979, 727, 22, 22, "Print",ExpressionUUID->"2a8bcdd2-60c4-a84e-ae4d-c207d33b9901"],
Cell[313604, 9003, 293, 5, 22, "Print",ExpressionUUID->"93a3d009-adce-4c41-96fb-f6de7bcb75a0"],
Cell[313900, 9010, 729, 22, 22, "Print",ExpressionUUID->"e818bed2-59f2-0a47-bd48-bb99af540898"],
Cell[314632, 9034, 293, 5, 22, "Print",ExpressionUUID->"58c90b01-8615-ad43-86c6-534a7abe02c0"],
Cell[314928, 9041, 732, 22, 22, "Print",ExpressionUUID->"c1dbfd40-0269-a349-b79d-e37e95271c93"],
Cell[315663, 9065, 293, 5, 22, "Print",ExpressionUUID->"63d9f6fc-35ba-6648-802d-a78ba67ae1bd"],
Cell[315959, 9072, 724, 22, 22, "Print",ExpressionUUID->"f9ed29da-d9d2-534e-80f1-a2f7429c6632"],
Cell[316686, 9096, 291, 5, 22, "Print",ExpressionUUID->"c29399b1-6388-e142-aedd-9d85f9bc2861"],
Cell[316980, 9103, 729, 22, 22, "Print",ExpressionUUID->"aa9b57ab-eee6-8244-84f1-2f66a87b7370"],
Cell[317712, 9127, 293, 5, 22, "Print",ExpressionUUID->"01e3964e-8d6d-f349-a4f3-35f737ffe7e9"],
Cell[318008, 9134, 727, 22, 22, "Print",ExpressionUUID->"6c03cb78-df6c-174a-bb28-fb708e5eed77"],
Cell[318738, 9158, 291, 5, 22, "Print",ExpressionUUID->"c617a7b9-c367-0d45-a544-a05884171b5d"],
Cell[319032, 9165, 727, 22, 22, "Print",ExpressionUUID->"32a1b578-024a-5749-a666-108887044597"],
Cell[319762, 9189, 291, 5, 22, "Print",ExpressionUUID->"438a1d32-0cbc-1e48-8bdc-7af79d33e7c9"],
Cell[320056, 9196, 729, 22, 22, "Print",ExpressionUUID->"4ccc04e2-925b-8543-a1b6-c1eea04c2f62"],
Cell[320788, 9220, 293, 5, 22, "Print",ExpressionUUID->"4e6090db-b0ef-614e-9a71-f92481b997bc"],
Cell[321084, 9227, 731, 23, 22, "Print",ExpressionUUID->"a6c9213a-f2c2-8249-9d0c-32b5ae8d8086"],
Cell[321818, 9252, 291, 5, 22, "Print",ExpressionUUID->"5d7f17f4-743f-d843-9fbc-31f252a60af5"],
Cell[322112, 9259, 730, 22, 22, "Print",ExpressionUUID->"df2f1df6-710f-6a48-ba7c-5b0c1180d20f"],
Cell[322845, 9283, 293, 5, 22, "Print",ExpressionUUID->"a219f0dc-3cf5-db4f-b5ea-1bbce8646d62"],
Cell[323141, 9290, 727, 22, 22, "Print",ExpressionUUID->"19d9b17a-05ce-744e-8a4a-3e0055e13c20"],
Cell[323871, 9314, 291, 5, 22, "Print",ExpressionUUID->"c3186fb4-6ee2-4643-89b0-7f4a0cf78744"],
Cell[324165, 9321, 732, 22, 22, "Print",ExpressionUUID->"3d2d0c4c-8d09-7b44-8fce-422ccdf80c06"],
Cell[324900, 9345, 293, 5, 22, "Print",ExpressionUUID->"ceb83572-74e5-564b-b959-c87075131d93"],
Cell[325196, 9352, 726, 22, 22, "Print",ExpressionUUID->"5ddc2f94-2463-9141-a4fd-07475986b5b7"],
Cell[325925, 9376, 293, 5, 22, "Print",ExpressionUUID->"b6f95af4-2bfc-ec43-8408-bdfecd9bfc34"],
Cell[326221, 9383, 729, 22, 22, "Print",ExpressionUUID->"2d273c40-d57e-1849-bfcf-0512cdd8eb83"],
Cell[326953, 9407, 291, 5, 22, "Print",ExpressionUUID->"b6e5e070-cbb7-0149-91b6-a5bf12e8f4bf"],
Cell[327247, 9414, 732, 23, 22, "Print",ExpressionUUID->"a1c32d4f-7d87-0f44-8443-fde5cb7bff67"],
Cell[327982, 9439, 293, 5, 22, "Print",ExpressionUUID->"15ec2de9-6cfc-d14c-a81b-2e0a80fa2ef2"],
Cell[328278, 9446, 727, 22, 22, "Print",ExpressionUUID->"3a05e36e-9225-0b4e-b6a8-9d14461f1e4f"],
Cell[329008, 9470, 291, 5, 22, "Print",ExpressionUUID->"ba4928a6-72c0-bb43-b7b7-a51163e6b677"],
Cell[329302, 9477, 729, 22, 22, "Print",ExpressionUUID->"a6affd35-0806-5843-9d5b-c1f96c9a07aa"],
Cell[330034, 9501, 293, 5, 22, "Print",ExpressionUUID->"73ebe1cd-af31-8645-ba66-c91860d7dd58"],
Cell[330330, 9508, 727, 22, 22, "Print",ExpressionUUID->"66d3ef9a-7a37-784b-821f-3920f4b80707"],
Cell[331060, 9532, 293, 5, 22, "Print",ExpressionUUID->"b3ba4fed-382d-994f-94ce-ec69da204209"],
Cell[331356, 9539, 729, 22, 22, "Print",ExpressionUUID->"2199413c-a020-0148-9e05-8f0654e9ddc3"],
Cell[332088, 9563, 293, 5, 22, "Print",ExpressionUUID->"8e66d96b-ca5b-0043-baa6-29fb20639104"],
Cell[332384, 9570, 729, 22, 22, "Print",ExpressionUUID->"3c67106d-f000-194c-88e4-1eae56ef1963"],
Cell[333116, 9594, 293, 5, 22, "Print",ExpressionUUID->"aa06c2f3-07e6-cf4e-8802-0c561485f87c"],
Cell[333412, 9601, 731, 23, 22, "Print",ExpressionUUID->"ca060280-fab6-ec44-9f20-1bdfa3675ee5"],
Cell[334146, 9626, 293, 5, 22, "Print",ExpressionUUID->"e75089b5-15d8-fa4a-b145-e7ba59c9e4ca"],
Cell[334442, 9633, 729, 22, 22, "Print",ExpressionUUID->"60f7b1c5-d5cb-1547-ac30-90c62e3797e2"],
Cell[335174, 9657, 291, 5, 22, "Print",ExpressionUUID->"5becb7b2-ed9f-284e-afbd-ee3d77c2503f"],
Cell[335468, 9664, 730, 22, 22, "Print",ExpressionUUID->"de08ba84-fea1-e448-9612-b82bfca3bd9c"],
Cell[336201, 9688, 291, 5, 22, "Print",ExpressionUUID->"c4fdd7b1-ce7d-9948-a02e-c75c2ea6b9a9"],
Cell[336495, 9695, 727, 22, 22, "Print",ExpressionUUID->"5ef46536-ce79-2842-90de-fa1582060087"],
Cell[337225, 9719, 291, 5, 22, "Print",ExpressionUUID->"668ec835-21eb-a74f-ba56-7b667f82735a"],
Cell[337519, 9726, 726, 22, 22, "Print",ExpressionUUID->"b6f5e767-b53c-cc42-8f4c-a40596bb83d5"],
Cell[338248, 9750, 293, 5, 22, "Print",ExpressionUUID->"282ddbd7-a23e-f64f-b4ad-e5941b4f4e10"],
Cell[338544, 9757, 730, 22, 22, "Print",ExpressionUUID->"2db474a0-6182-b042-9f2a-dbc64489dbf1"],
Cell[339277, 9781, 291, 5, 22, "Print",ExpressionUUID->"5faed649-286d-c24d-9a3d-7318f9f19883"],
Cell[339571, 9788, 732, 23, 22, "Print",ExpressionUUID->"7cce2566-9c75-cf45-aae3-5bfe02117fdc"],
Cell[340306, 9813, 293, 5, 22, "Print",ExpressionUUID->"598dc362-09d9-d541-959e-ab9c14e1c067"],
Cell[340602, 9820, 726, 22, 22, "Print",ExpressionUUID->"86595acd-a6bb-7d49-925b-72d4c9915312"],
Cell[341331, 9844, 291, 5, 22, "Print",ExpressionUUID->"4d141053-e960-9b48-a57a-6ab91ca3c38c"],
Cell[341625, 9851, 732, 22, 22, "Print",ExpressionUUID->"f22770b7-a746-9b43-94ed-1ea69bc8b79c"],
Cell[342360, 9875, 293, 5, 22, "Print",ExpressionUUID->"b4243af0-10c4-5143-862f-84590b892439"],
Cell[342656, 9882, 727, 22, 22, "Print",ExpressionUUID->"786ee6fc-1ef7-3f4d-8173-4690fe65d88e"],
Cell[343386, 9906, 293, 5, 22, "Print",ExpressionUUID->"7af8dafd-7144-5c47-8052-330988a9cae0"],
Cell[343682, 9913, 726, 22, 22, "Print",ExpressionUUID->"0400620d-5966-a747-bde2-8c6b8ef69206"],
Cell[344411, 9937, 293, 5, 22, "Print",ExpressionUUID->"79dc93b6-0bb9-524e-8e4b-e273f170c8b6"],
Cell[344707, 9944, 732, 22, 22, "Print",ExpressionUUID->"05cd7a6b-b1b0-c041-82d0-278240cdee2d"],
Cell[345442, 9968, 293, 5, 22, "Print",ExpressionUUID->"0f927fb2-d415-1e47-b51c-b24339643613"],
Cell[345738, 9975, 734, 23, 22, "Print",ExpressionUUID->"086955e5-3c8c-8842-8f62-eaa3aced5041"],
Cell[346475, 10000, 291, 5, 22, "Print",ExpressionUUID->"310a4a4b-eb5f-8e40-846d-099a1ca861b4"],
Cell[346769, 10007, 727, 22, 22, "Print",ExpressionUUID->"510a9fb6-0ac1-1547-baba-3eb352a23bc8"],
Cell[347499, 10031, 291, 5, 22, "Print",ExpressionUUID->"01819f4c-e5e3-364c-99fc-7ae2a7c21d38"],
Cell[347793, 10038, 734, 23, 22, "Print",ExpressionUUID->"d826d495-2c46-1e40-9944-ed62ff2ef5a3"],
Cell[348530, 10063, 293, 5, 22, "Print",ExpressionUUID->"75b5621f-48f8-fe46-b743-1c5d7ccb2edf"],
Cell[348826, 10070, 729, 22, 22, "Print",ExpressionUUID->"6df6d79a-df33-324e-80c4-79b545bcc7a9"],
Cell[349558, 10094, 291, 5, 22, "Print",ExpressionUUID->"d6908a33-3e5a-ea45-9e5f-22c81cad8c86"],
Cell[349852, 10101, 727, 22, 22, "Print",ExpressionUUID->"c7c96961-d9b0-914d-b5a3-e6fb52bb6ba5"],
Cell[350582, 10125, 291, 5, 22, "Print",ExpressionUUID->"29dc7061-e6e9-b040-90d2-01d499fe0a0d"],
Cell[350876, 10132, 734, 23, 22, "Print",ExpressionUUID->"39f560dd-8244-ec48-a847-df4e82394abb"],
Cell[351613, 10157, 293, 5, 22, "Print",ExpressionUUID->"b1348b61-ca07-e043-937e-97bded2b253d"],
Cell[351909, 10164, 731, 23, 22, "Print",ExpressionUUID->"46a63286-8ca0-fd45-9c16-71ddbae1e972"],
Cell[352643, 10189, 291, 5, 22, "Print",ExpressionUUID->"425f4a24-f022-cc42-ae34-969b0610a40e"],
Cell[352937, 10196, 732, 22, 22, "Print",ExpressionUUID->"0ca4e8b2-e03c-6d4d-a948-69d22c8800d7"],
Cell[353672, 10220, 293, 5, 22, "Print",ExpressionUUID->"ebf705f1-97a1-734b-a1d9-919293913757"],
Cell[353968, 10227, 732, 23, 22, "Print",ExpressionUUID->"b6c54609-00ea-ac4f-b2c1-926cec76d39e"],
Cell[354703, 10252, 291, 5, 22, "Print",ExpressionUUID->"b48b2ab3-5a3f-f34a-884d-a2cd835b8d6b"],
Cell[354997, 10259, 726, 22, 22, "Print",ExpressionUUID->"086a4b46-e71e-6442-9b5b-756b14561d6a"],
Cell[355726, 10283, 293, 5, 22, "Print",ExpressionUUID->"028aa328-b6d5-6640-8a04-1bc908df5931"],
Cell[356022, 10290, 732, 22, 22, "Print",ExpressionUUID->"6b43c85d-5ddc-ef4d-8284-315818057d52"],
Cell[356757, 10314, 293, 5, 22, "Print",ExpressionUUID->"83459ab6-5821-c448-b174-bea7f59a37c7"],
Cell[357053, 10321, 731, 23, 22, "Print",ExpressionUUID->"79758ce2-d7f7-214d-acf2-2ceefdbd105f"],
Cell[357787, 10346, 293, 5, 22, "Print",ExpressionUUID->"8d7ab3eb-2007-ed42-ba3d-e1f7f63f775f"],
Cell[358083, 10353, 734, 23, 22, "Print",ExpressionUUID->"042302f4-62e9-f44c-8a26-a7b5514b9c77"],
Cell[358820, 10378, 291, 5, 22, "Print",ExpressionUUID->"2773920c-d6bc-7e42-8f27-e42ad6a429a5"],
Cell[359114, 10385, 730, 22, 22, "Print",ExpressionUUID->"59381b05-6374-eb4f-a759-0e28a2713235"],
Cell[359847, 10409, 291, 5, 22, "Print",ExpressionUUID->"0e7d0954-4739-8d4d-ba6d-f8e7fa5744c4"],
Cell[360141, 10416, 731, 23, 22, "Print",ExpressionUUID->"a18dbaa5-8daa-3840-9372-941066acad29"],
Cell[360875, 10441, 291, 5, 22, "Print",ExpressionUUID->"b3baf90d-a823-a74c-8dbe-1f6e9861509f"],
Cell[361169, 10448, 730, 22, 22, "Print",ExpressionUUID->"ceb1abe1-9a14-d847-a09b-8947ec252567"],
Cell[361902, 10472, 291, 5, 22, "Print",ExpressionUUID->"6dfb7568-516a-5741-a5cc-93c7cbcb8fdf"],
Cell[362196, 10479, 729, 22, 22, "Print",ExpressionUUID->"026351c8-03e1-634b-ba98-25065805a967"],
Cell[362928, 10503, 293, 5, 22, "Print",ExpressionUUID->"9b65add2-a5eb-8748-9662-dec868d00711"],
Cell[363224, 10510, 729, 23, 22, "Print",ExpressionUUID->"41e65556-0111-8341-b488-4859f648f149"],
Cell[363956, 10535, 293, 5, 22, "Print",ExpressionUUID->"9bd8cb42-0c70-b14c-917b-13a73ba480de"],
Cell[364252, 10542, 734, 23, 22, "Print",ExpressionUUID->"4fa9d199-7898-934f-a783-c2c9521a38a4"],
Cell[364989, 10567, 293, 5, 22, "Print",ExpressionUUID->"dad2e85b-cf82-2d4f-8448-f5c6ad0dbf56"],
Cell[365285, 10574, 730, 22, 22, "Print",ExpressionUUID->"b67d399c-a656-6642-b915-800919a712d5"],
Cell[366018, 10598, 291, 5, 22, "Print",ExpressionUUID->"699fe89c-e435-a24c-9562-699bbe3124cc"],
Cell[366312, 10605, 729, 23, 22, "Print",ExpressionUUID->"481ac589-40ba-6549-8aac-e39c89ca2d2c"],
Cell[367044, 10630, 293, 5, 22, "Print",ExpressionUUID->"f08edf7a-6961-4747-8768-3c65596c320f"],
Cell[367340, 10637, 727, 22, 22, "Print",ExpressionUUID->"a1598043-4a89-014b-aa5d-bc12c9090a3d"],
Cell[368070, 10661, 291, 5, 22, "Print",ExpressionUUID->"ead34a8a-5849-c345-a00d-4fde69e2989e"],
Cell[368364, 10668, 730, 22, 22, "Print",ExpressionUUID->"c1442b02-a4ba-434a-b320-59da4363f66b"],
Cell[369097, 10692, 291, 5, 22, "Print",ExpressionUUID->"e076741b-6b67-a649-9e4f-bdcdfc6204bc"],
Cell[369391, 10699, 729, 23, 22, "Print",ExpressionUUID->"c355a17f-c972-674e-a09e-256ed6598b3b"],
Cell[370123, 10724, 291, 5, 22, "Print",ExpressionUUID->"a2f89f60-ba91-2848-90ff-97d0bbe464c0"],
Cell[370417, 10731, 731, 23, 22, "Print",ExpressionUUID->"03d350da-c4c6-1648-a800-e7cbfc4031b2"],
Cell[371151, 10756, 293, 5, 22, "Print",ExpressionUUID->"2e0b026d-706e-6143-9f3f-4e9f175f389f"],
Cell[371447, 10763, 730, 22, 22, "Print",ExpressionUUID->"c55ddd33-1784-4a41-b2fb-8535de3823f7"],
Cell[372180, 10787, 293, 5, 22, "Print",ExpressionUUID->"17c53f2a-4907-c040-b899-2d0d54683eb9"],
Cell[372476, 10794, 734, 23, 22, "Print",ExpressionUUID->"c07bc799-993a-3b4e-95cb-6ba2b14ce587"],
Cell[373213, 10819, 293, 5, 22, "Print",ExpressionUUID->"31b33ad7-7250-2144-ae1c-f80a629b9c95"],
Cell[373509, 10826, 730, 22, 22, "Print",ExpressionUUID->"fd972e1a-807f-1241-b59e-755b45309d44"],
Cell[374242, 10850, 291, 5, 22, "Print",ExpressionUUID->"422fe2e2-818a-e14c-bbdb-439f01f06360"],
Cell[374536, 10857, 726, 22, 22, "Print",ExpressionUUID->"eef1943f-2553-c74b-b4cf-b9341aeb97f4"],
Cell[375265, 10881, 291, 5, 22, "Print",ExpressionUUID->"ee3f614d-0103-3e45-b6e5-6a7a34a2dece"],
Cell[375559, 10888, 734, 23, 22, "Print",ExpressionUUID->"2b2440de-aff1-f044-972b-bfcd375e11e0"],
Cell[376296, 10913, 293, 5, 22, "Print",ExpressionUUID->"11f012de-400e-9442-82bf-dcdcbb8cddfc"],
Cell[376592, 10920, 734, 23, 22, "Print",ExpressionUUID->"720b9fdd-4b73-6341-8fe0-ec7f3a241725"],
Cell[377329, 10945, 293, 5, 22, "Print",ExpressionUUID->"3c15f136-bba3-d947-841e-620ac7593452"],
Cell[377625, 10952, 729, 22, 22, "Print",ExpressionUUID->"a63fdd91-7c52-c74b-b08b-a8aa492f34ce"],
Cell[378357, 10976, 293, 5, 22, "Print",ExpressionUUID->"20a0d3a7-7a08-be46-be1c-8c6cebf88797"],
Cell[378653, 10983, 732, 23, 22, "Print",ExpressionUUID->"d1eed9a1-ce46-cc4a-9075-b65f7c8e731b"],
Cell[379388, 11008, 291, 5, 22, "Print",ExpressionUUID->"53406ad8-b243-0c45-b663-f9718a3157e3"],
Cell[379682, 11015, 729, 22, 22, "Print",ExpressionUUID->"4f732d5b-d73e-1042-998c-82c2134c7a93"],
Cell[380414, 11039, 293, 5, 22, "Print",ExpressionUUID->"edd46912-3429-fe41-b988-b927f44d350f"],
Cell[380710, 11046, 727, 22, 22, "Print",ExpressionUUID->"68f20c32-c0d4-764f-9587-843de7d60919"],
Cell[381440, 11070, 293, 5, 22, "Print",ExpressionUUID->"1a40bd9c-9c44-8048-b837-bc0a7d5d949d"],
Cell[381736, 11077, 734, 23, 22, "Print",ExpressionUUID->"1e250019-eafa-8541-8c24-ba4b50a39b94"],
Cell[382473, 11102, 293, 5, 22, "Print",ExpressionUUID->"3c895efb-e0c7-994d-a97b-476b08554f49"],
Cell[382769, 11109, 732, 23, 22, "Print",ExpressionUUID->"ff6d3199-a45f-e541-9965-fe65580bd881"],
Cell[383504, 11134, 291, 5, 22, "Print",ExpressionUUID->"b331ac8e-17a4-844f-813e-fc727d06b98a"],
Cell[383798, 11141, 723, 22, 22, "Print",ExpressionUUID->"0a7207e7-be9b-ff47-a091-4da36434779b"],
Cell[384524, 11165, 290, 5, 22, "Print",ExpressionUUID->"055cb304-cd21-cb49-b5a9-d80c44746b0e"],
Cell[384817, 11172, 737, 23, 22, "Print",ExpressionUUID->"e7e03a24-8760-da4f-89a2-325c1095e502"],
Cell[385557, 11197, 291, 5, 22, "Print",ExpressionUUID->"d101fe69-adf7-c645-a3c7-9a52fb62d928"],
Cell[385851, 11204, 724, 22, 22, "Print",ExpressionUUID->"68a0a480-2774-9440-9b67-8802c0643a1d"],
Cell[386578, 11228, 293, 5, 22, "Print",ExpressionUUID->"e737a940-0bde-614c-a034-049b961210b9"],
Cell[386874, 11235, 727, 22, 22, "Print",ExpressionUUID->"2db0b9d8-1f4d-e448-8bdf-50a9f2437099"],
Cell[387604, 11259, 291, 5, 22, "Print",ExpressionUUID->"73bcf356-5774-bb43-b02f-8a847bb7986c"],
Cell[387898, 11266, 737, 23, 22, "Print",ExpressionUUID->"dfb0687e-5421-8b44-b2eb-90f445a70bd4"],
Cell[388638, 11291, 293, 5, 22, "Print",ExpressionUUID->"08575495-af7d-7648-9417-039f5f9456b7"],
Cell[388934, 11298, 731, 23, 22, "Print",ExpressionUUID->"377f64fd-a4f2-6640-8abd-b000b90d0ffa"],
Cell[389668, 11323, 291, 5, 22, "Print",ExpressionUUID->"32a22407-954a-4b40-bc07-136b30534dc1"],
Cell[389962, 11330, 729, 22, 22, "Print",ExpressionUUID->"41cc12be-ab36-fa43-9ed9-ea44bd2917c2"],
Cell[390694, 11354, 293, 5, 22, "Print",ExpressionUUID->"13c2242b-596d-3041-b0c4-eb3ff831c5f0"],
Cell[390990, 11361, 735, 23, 22, "Print",ExpressionUUID->"fd274538-d3b7-cb40-9403-09122c266a55"],
Cell[391728, 11386, 291, 5, 22, "Print",ExpressionUUID->"c395a0bd-c49f-164c-9ad3-f576aa54457a"],
Cell[392022, 11393, 724, 22, 22, "Print",ExpressionUUID->"e2b52632-3715-9648-ae8b-0a81b8e081e7"],
Cell[392749, 11417, 293, 5, 22, "Print",ExpressionUUID->"da8890e8-cde8-a441-abc1-f4a619a9691b"],
Cell[393045, 11424, 727, 22, 22, "Print",ExpressionUUID->"eb28b038-b073-934b-a0b1-06c6321dfbe2"],
Cell[393775, 11448, 291, 5, 22, "Print",ExpressionUUID->"47b5c4f7-1cfa-0846-9c5c-08f35a4032bd"],
Cell[394069, 11455, 737, 23, 22, "Print",ExpressionUUID->"a3a7e577-80c7-654e-873c-de58521c3187"],
Cell[394809, 11480, 291, 5, 22, "Print",ExpressionUUID->"ea8353e4-8f1c-e34e-ad63-928644e44c66"],
Cell[395103, 11487, 732, 23, 22, "Print",ExpressionUUID->"d9513f22-6da6-e44f-92ef-40208413a958"],
Cell[395838, 11512, 293, 5, 22, "Print",ExpressionUUID->"bea6cbbb-3782-764e-baa0-60fb1eeebbba"],
Cell[396134, 11519, 729, 23, 22, "Print",ExpressionUUID->"ca0a26b5-f461-724e-8c21-864a4dab52ea"],
Cell[396866, 11544, 291, 5, 22, "Print",ExpressionUUID->"ade3a192-ccd0-ae40-acc8-b4673ad64889"],
Cell[397160, 11551, 735, 23, 22, "Print",ExpressionUUID->"81518efc-43ad-e742-a54e-b29c4e323c25"],
Cell[397898, 11576, 293, 5, 22, "Print",ExpressionUUID->"aa8c95ff-08e3-f64b-bf7b-651fd6ccd5cd"],
Cell[398194, 11583, 726, 22, 22, "Print",ExpressionUUID->"e5067cf5-fb46-334c-a7a3-aeec08fabfc7"],
Cell[398923, 11607, 290, 5, 22, "Print",ExpressionUUID->"7728c701-93ca-ad40-acd1-1c63fb2d1a52"],
Cell[399216, 11614, 731, 23, 22, "Print",ExpressionUUID->"b6a11aee-8767-204c-a59e-1246c1a8c9be"],
Cell[399950, 11639, 291, 5, 22, "Print",ExpressionUUID->"da810acc-d924-3a4e-8a9f-2c64feb0022a"],
Cell[400244, 11646, 735, 23, 22, "Print",ExpressionUUID->"5175d5c7-5078-5b48-87d4-5dcce182185f"],
Cell[400982, 11671, 291, 5, 22, "Print",ExpressionUUID->"2d34bfc4-c7c7-eb40-885c-cee4dc08b1bc"],
Cell[401276, 11678, 731, 23, 22, "Print",ExpressionUUID->"b83f8116-9c12-c144-ad22-54305402d1de"],
Cell[402010, 11703, 293, 5, 22, "Print",ExpressionUUID->"19c923fb-289b-a64c-b0b9-50982a82bb58"],
Cell[402306, 11710, 732, 23, 22, "Print",ExpressionUUID->"dc2f33dc-cc4a-7a46-9490-b6798ea1c4cc"],
Cell[403041, 11735, 293, 5, 22, "Print",ExpressionUUID->"c3329d11-d67a-4544-a173-665b475936ce"],
Cell[403337, 11742, 735, 23, 22, "Print",ExpressionUUID->"5bcdaaac-5eea-1848-bee4-0acaf4bdac54"],
Cell[404075, 11767, 291, 5, 22, "Print",ExpressionUUID->"35ca6dfe-333d-234c-ab68-053cb048226e"],
Cell[404369, 11774, 726, 22, 22, "Print",ExpressionUUID->"86b853c6-dbdb-ca4a-be0a-fa19ee5fe30a"],
Cell[405098, 11798, 291, 5, 22, "Print",ExpressionUUID->"1990f630-d7e3-ee48-8347-88363b83323b"],
Cell[405392, 11805, 734, 23, 22, "Print",ExpressionUUID->"c91e23c8-b369-614b-bc57-9803132a8546"],
Cell[406129, 11830, 291, 5, 22, "Print",ExpressionUUID->"e22f1711-5602-8644-8e86-840fdda0a6e1"],
Cell[406423, 11837, 737, 23, 22, "Print",ExpressionUUID->"a1f8bb93-eecd-af43-a500-b1800587ae49"],
Cell[407163, 11862, 293, 5, 22, "Print",ExpressionUUID->"3782f0da-6219-0948-a34e-f9f88685231a"],
Cell[407459, 11869, 734, 23, 22, "Print",ExpressionUUID->"7e8a28ea-d5c2-7e41-83ab-73fa71386d22"],
Cell[408196, 11894, 291, 5, 22, "Print",ExpressionUUID->"a5a31fd4-743b-f243-b25d-638bed17a289"],
Cell[408490, 11901, 729, 22, 22, "Print",ExpressionUUID->"036346e3-e00f-6846-bb9b-29d312753986"],
Cell[409222, 11925, 293, 5, 22, "Print",ExpressionUUID->"f07c4520-b2ff-e24d-9d5e-d7cfc02b8f24"],
Cell[409518, 11932, 731, 23, 22, "Print",ExpressionUUID->"a07af9ff-e712-1847-8057-0e06b5d09586"],
Cell[410252, 11957, 290, 5, 22, "Print",ExpressionUUID->"6d91e6a4-1879-cc4f-ac99-55a69097ec78"],
Cell[410545, 11964, 729, 22, 22, "Print",ExpressionUUID->"1f20d445-4c81-3d4b-8f74-334689c27d16"],
Cell[411277, 11988, 293, 5, 22, "Print",ExpressionUUID->"42fbf703-c0ca-3242-be0d-71d72c883391"],
Cell[411573, 11995, 727, 22, 22, "Print",ExpressionUUID->"ce229bfc-6320-e543-b837-2a5a77db558b"],
Cell[412303, 12019, 293, 5, 22, "Print",ExpressionUUID->"db395d53-7452-2e40-9b59-39131adfcee5"],
Cell[412599, 12026, 732, 23, 22, "Print",ExpressionUUID->"6e901714-ed5e-f146-a059-0804fb03f604"],
Cell[413334, 12051, 291, 5, 22, "Print",ExpressionUUID->"f141e561-1ba9-3349-9f25-0aeddea5d6d8"],
Cell[413628, 12058, 732, 23, 22, "Print",ExpressionUUID->"e7881a04-7bf3-e942-9ea0-d2bd2be6870f"],
Cell[414363, 12083, 293, 5, 22, "Print",ExpressionUUID->"02c1abbb-5f29-f64e-ad30-bbec1c3eaa8e"],
Cell[414659, 12090, 727, 22, 22, "Print",ExpressionUUID->"0f8ec326-d6e2-6e40-a1aa-8e2334572bc0"],
Cell[415389, 12114, 293, 5, 22, "Print",ExpressionUUID->"87065f07-f89f-9a4b-98c2-a2fca8f1717a"],
Cell[415685, 12121, 734, 23, 22, "Print",ExpressionUUID->"ba4379f0-6e40-7840-b7e6-8c0b4756bc4c"],
Cell[416422, 12146, 291, 5, 22, "Print",ExpressionUUID->"6314c7a0-a372-1447-9ad6-349071b6e0fd"],
Cell[416716, 12153, 729, 22, 22, "Print",ExpressionUUID->"c952b43a-d400-5b42-8af2-0dbddb92e09f"],
Cell[417448, 12177, 293, 5, 22, "Print",ExpressionUUID->"d9c61074-5f01-0741-8d3e-43aae5f14824"],
Cell[417744, 12184, 729, 22, 22, "Print",ExpressionUUID->"b665b8ea-b9c9-e149-8ef6-190f38bd4801"],
Cell[418476, 12208, 291, 5, 22, "Print",ExpressionUUID->"e90def26-41e4-fa46-a294-5bf02673da6b"],
Cell[418770, 12215, 732, 23, 22, "Print",ExpressionUUID->"07a4c346-4957-1c44-adda-ffadf31111fb"],
Cell[419505, 12240, 293, 5, 22, "Print",ExpressionUUID->"8d6ab24f-e189-0344-acbf-fee5ef4725d0"],
Cell[419801, 12247, 734, 23, 22, "Print",ExpressionUUID->"4f2c114c-742d-6046-b66f-69baedb80006"],
Cell[420538, 12272, 293, 5, 22, "Print",ExpressionUUID->"95292581-abe7-d348-8b9f-8572fda1b699"],
Cell[420834, 12279, 734, 23, 22, "Print",ExpressionUUID->"3f58612e-d96c-cc48-95e9-44e9c775528e"],
Cell[421571, 12304, 291, 5, 22, "Print",ExpressionUUID->"826c435f-10a1-4f4e-945d-20e000905405"],
Cell[421865, 12311, 732, 23, 22, "Print",ExpressionUUID->"8cec1a05-8d9d-f34b-a26c-2616184daf8c"],
Cell[422600, 12336, 291, 5, 22, "Print",ExpressionUUID->"62a6fd4f-5539-0840-ae88-396cafae97d3"],
Cell[422894, 12343, 729, 22, 22, "Print",ExpressionUUID->"ee99d51e-0168-f144-b097-76bc477ea73c"],
Cell[423626, 12367, 291, 5, 22, "Print",ExpressionUUID->"a50823c2-2e41-b443-bc0e-2764759d53b0"],
Cell[423920, 12374, 734, 23, 22, "Print",ExpressionUUID->"a38a66fd-24f1-e84e-821f-62818b8b5c3c"],
Cell[424657, 12399, 293, 5, 22, "Print",ExpressionUUID->"1254f354-9983-3f47-8cb5-867162c7ad40"],
Cell[424953, 12406, 734, 23, 22, "Print",ExpressionUUID->"c98c90c8-6f48-9042-9e19-e29b3c6f7fa4"],
Cell[425690, 12431, 293, 5, 22, "Print",ExpressionUUID->"0bce8b9d-d896-ff4e-bc6a-714f69732e26"],
Cell[425986, 12438, 734, 23, 22, "Print",ExpressionUUID->"b8d7a585-9cfc-3447-9ee0-100b7b72a38c"],
Cell[426723, 12463, 291, 5, 22, "Print",ExpressionUUID->"e3bffa4e-292b-2343-aa35-cb2ebe16145d"],
Cell[427017, 12470, 734, 23, 22, "Print",ExpressionUUID->"dc18027f-e286-604c-a63b-533b4899516b"],
Cell[427754, 12495, 293, 5, 22, "Print",ExpressionUUID->"d8339040-fd13-e64e-839c-7ea4b76c9d65"],
Cell[428050, 12502, 734, 23, 22, "Print",ExpressionUUID->"f1cbfafe-0df5-7345-a027-9337493f0b27"],
Cell[428787, 12527, 290, 5, 22, "Print",ExpressionUUID->"6cbabbfc-d23b-894d-be76-1e1b18913e76"],
Cell[429080, 12534, 729, 22, 22, "Print",ExpressionUUID->"6e1e4b53-541e-2d4c-842e-ac0304687be3"],
Cell[429812, 12558, 293, 5, 22, "Print",ExpressionUUID->"5b8e52b8-5e5f-1649-97e4-4ab667758809"],
Cell[430108, 12565, 734, 23, 22, "Print",ExpressionUUID->"1a12a4fd-f83c-3c4a-bc10-39c41447783d"],
Cell[430845, 12590, 293, 5, 22, "Print",ExpressionUUID->"a199ad55-ef57-8c41-aac3-c67044ba7df6"],
Cell[431141, 12597, 732, 23, 22, "Print",ExpressionUUID->"d687fa6e-f796-af44-9e3e-9c0fe1cf9b8d"],
Cell[431876, 12622, 291, 5, 22, "Print",ExpressionUUID->"ccde92a7-4d57-c641-a8c5-5c79c0ca9557"],
Cell[432170, 12629, 729, 23, 22, "Print",ExpressionUUID->"16dfeb16-1c89-f145-8f6f-0be3dfdfcc2f"],
Cell[432902, 12654, 291, 5, 22, "Print",ExpressionUUID->"9d8583d0-ba18-024f-a3c2-6877dcd4e504"],
Cell[433196, 12661, 729, 22, 22, "Print",ExpressionUUID->"f6c178c3-26a7-4646-bf87-387e8320448d"],
Cell[433928, 12685, 291, 5, 22, "Print",ExpressionUUID->"516c180b-0d7e-8f49-a7ad-543bc11b5fe3"],
Cell[434222, 12692, 735, 23, 22, "Print",ExpressionUUID->"c6e94a96-4c4b-b648-a137-109c390bf1db"],
Cell[434960, 12717, 293, 5, 22, "Print",ExpressionUUID->"4c43cf4f-8b21-3b48-9915-c1a1c9b2b2f2"],
Cell[435256, 12724, 729, 22, 22, "Print",ExpressionUUID->"1f45d244-9c5d-2a4d-bb37-5faf8657a2cf"],
Cell[435988, 12748, 293, 5, 22, "Print",ExpressionUUID->"0e2ecf87-561a-0144-a9a6-53549fd4f8bf"],
Cell[436284, 12755, 724, 22, 22, "Print",ExpressionUUID->"32a4ba3c-95a4-c542-87a3-6a1b5b784909"],
Cell[437011, 12779, 291, 5, 22, "Print",ExpressionUUID->"5ea0cc80-590e-2046-9cda-713c9d93daf7"],
Cell[437305, 12786, 735, 23, 22, "Print",ExpressionUUID->"8b86ed02-6024-b540-be2d-8250e4852b87"],
Cell[438043, 12811, 291, 5, 22, "Print",ExpressionUUID->"b9e6b72c-dfb4-cd41-a6db-8b2e519bc194"],
Cell[438337, 12818, 732, 23, 22, "Print",ExpressionUUID->"5da70cb5-1aba-7a43-8430-842e62240772"],
Cell[439072, 12843, 291, 5, 22, "Print",ExpressionUUID->"390b4869-aa5a-0241-8944-42094cb18546"],
Cell[439366, 12850, 724, 22, 22, "Print",ExpressionUUID->"592e000f-098b-4646-814b-d97f3e04de03"],
Cell[440093, 12874, 293, 5, 22, "Print",ExpressionUUID->"73f4a6a9-fe99-7e4c-b7e0-623d743f66e2"],
Cell[440389, 12881, 735, 23, 22, "Print",ExpressionUUID->"816ab3ac-7eec-274b-a026-c2eb0ebce66a"],
Cell[441127, 12906, 291, 5, 22, "Print",ExpressionUUID->"a0e891c7-a8ef-1d41-81f5-aefbf2cbe204"],
Cell[441421, 12913, 729, 22, 22, "Print",ExpressionUUID->"25d3aa09-f2fd-974f-a6b7-c53d3eeb6cff"],
Cell[442153, 12937, 290, 5, 22, "Print",ExpressionUUID->"e6e98792-19ab-f947-a5a4-e2ee4f17f57c"],
Cell[442446, 12944, 723, 22, 22, "Print",ExpressionUUID->"f1e06684-ec21-e340-989f-985c8cac3204"],
Cell[443172, 12968, 293, 5, 22, "Print",ExpressionUUID->"6100fcef-d562-8844-90f9-8816d2b14ddd"],
Cell[443468, 12975, 735, 23, 22, "Print",ExpressionUUID->"b8457f67-d794-904e-8535-1cbeb08e2661"],
Cell[444206, 13000, 291, 5, 22, "Print",ExpressionUUID->"0aedaa03-3522-d448-ad1f-189b5e5a5a4d"],
Cell[444500, 13007, 731, 23, 22, "Print",ExpressionUUID->"28c8dc00-8bbb-2b47-a832-7c6d271834e1"],
Cell[445234, 13032, 290, 5, 22, "Print",ExpressionUUID->"11990f92-de61-8445-afa8-6efe43137842"],
Cell[445527, 13039, 731, 23, 22, "Print",ExpressionUUID->"03eb3d99-4f86-ed4c-b9ae-6bccbf8f6760"],
Cell[446261, 13064, 291, 5, 22, "Print",ExpressionUUID->"c98ea9df-f6ff-8a47-821c-e435d9ce9602"],
Cell[446555, 13071, 737, 23, 22, "Print",ExpressionUUID->"58567102-b07f-ee49-95a6-03ca18f15073"],
Cell[447295, 13096, 293, 5, 22, "Print",ExpressionUUID->"cbfdc418-c180-8540-92f2-a15726da0abf"],
Cell[447591, 13103, 723, 22, 22, "Print",ExpressionUUID->"5984b99f-15bd-0942-a41a-0713a08dda4d"],
Cell[448317, 13127, 290, 5, 22, "Print",ExpressionUUID->"03527b0d-3f3e-f84d-9b3c-0013cb396a89"],
Cell[448610, 13134, 734, 23, 22, "Print",ExpressionUUID->"718b4216-f945-c242-a16f-652fd7a16c1f"],
Cell[449347, 13159, 291, 5, 22, "Print",ExpressionUUID->"62d63a7b-1879-ff46-a716-32c7daf2e905"],
Cell[449641, 13166, 737, 23, 22, "Print",ExpressionUUID->"3e0c768f-dbaa-0247-8f41-94366daffb4c"],
Cell[450381, 13191, 293, 5, 22, "Print",ExpressionUUID->"2f19bb26-6319-054a-b755-ba923b929079"],
Cell[450677, 13198, 734, 23, 22, "Print",ExpressionUUID->"1171e2f7-5b33-314f-9afd-239d51f40e5c"],
Cell[451414, 13223, 293, 5, 22, "Print",ExpressionUUID->"d573a2c2-d0b4-db47-b513-a6ca6c52e5d2"],
Cell[451710, 13230, 731, 23, 22, "Print",ExpressionUUID->"04b53fbe-5d31-e34b-96c3-5f0ac6744f3a"],
Cell[452444, 13255, 293, 5, 22, "Print",ExpressionUUID->"c984b85b-5685-9044-9290-371ced54ebf1"],
Cell[452740, 13262, 737, 23, 22, "Print",ExpressionUUID->"12256f83-d2c9-774b-ad50-860c9f65ff8f"],
Cell[453480, 13287, 293, 5, 22, "Print",ExpressionUUID->"98fd5553-7c18-7d45-8abd-989cf0c94c66"],
Cell[453776, 13294, 727, 22, 22, "Print",ExpressionUUID->"b0d61138-0e99-124e-84b3-4b0ba6237fae"],
Cell[454506, 13318, 291, 5, 22, "Print",ExpressionUUID->"ef466e1b-c0ed-df45-9698-1ff33724486d"],
Cell[454800, 13325, 731, 23, 22, "Print",ExpressionUUID->"c7bf4843-44c8-784a-86e4-fc7654c14535"],
Cell[455534, 13350, 291, 5, 22, "Print",ExpressionUUID->"8a878769-1e6b-6e47-9bce-d8913ac7a7d8"],
Cell[455828, 13357, 735, 23, 22, "Print",ExpressionUUID->"8a413389-44f3-ba41-b6f3-2742fa7f49e7"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[456612, 13386, 1032, 26, 47, "Input",ExpressionUUID->"728e42c4-a9da-ac4d-a4d1-275b0ef2eed5"],
Cell[CellGroupData[{
Cell[457669, 13416, 307, 6, 22, "Print",ExpressionUUID->"85a03383-b52e-544e-96cf-94acdec3eaa0"],
Cell[457979, 13424, 837, 18, 22, "Print",ExpressionUUID->"13903dd8-07a1-c241-a39a-87246fd8db44"]
}, Open  ]],
Cell[458831, 13445, 536, 12, 26, "Message",ExpressionUUID->"f4e412e9-8dfa-1c43-9fae-12f31e2e0ced"],
Cell[459370, 13459, 308, 5, 32, "Output",ExpressionUUID->"591bad7e-772a-dd4d-af87-b52e66c22205"]
}, Open  ]]
}
]
*)

